/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.OppoField;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.BaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.bean.SnapShotAssociateProtectObject;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.storage.manager.StorageManagerUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.system.plugin.DrmBaseApplication;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractBaseProtectAction
implements BaseProtectAction {
    protected static final long MAX_TIME_OUT = 0x6DDD00L;
    private static final String IGNORE_FAILURE = "Frame_Action_Ignore_Failure";
    private static final Log logger = LogFactory.getInstance(AbstractBaseProtectAction.class);
    @OppoField(fieldName="actionId")
    private String actionId = UUIDGenerator.getUUID();
    @OppoField(fieldName="protectGroupId")
    private String protectGroupId;
    @OppoField(fieldName="actionType")
    private String actionType = "Ordinary";
    @OppoField(fieldName="protectLocation", fieldType=int.class)
    private int protectLocation;
    @OppoField(fieldName="editable", fieldType=boolean.class)
    private boolean editable = false;
    @OppoField(fieldName="enable", fieldType=boolean.class)
    private boolean enable = true;
    @OppoField(fieldName="preAction")
    private String preAction;
    @OppoField(fieldName="nextAction")
    private String nextAction;
    @OppoField(fieldName="params", fieldType=Map.class)
    private Map<String, String> params = new HashMap<String, String>();
    @OppoField(fieldName="name")
    private String name;
    @OppoField(fieldName="nameParams")
    private String nameParams = "";
    @OppoField(fieldName="detail")
    private String detail = "--";
    @OppoField(fieldName="detailParams")
    private String detailParams = "";
    @OppoField(fieldName="protectedType", fieldType=Integer.class)
    private Integer protectedType;

    protected Set<ProtectObject> combineProtectObjectByType(Set<ProtectObject> poSet, ProtectGroup pg) {
        if (poSet == null || poSet.isEmpty()) {
            return new HashSet<ProtectObject>();
        }
        int poType = pg.getPoType();
        IApplicationManager appManager = ApplicationAdapterProxy.getInstance().getAppManager(poType);
        if (appManager == null) {
            logger.error((Object)"appManager is null.poType:%s", new Object[]{String.valueOf(poType)});
            throw new LegoCheckedException(1073947394L);
        }
        return appManager.combineProtectObject(poSet);
    }

    public void preExcute(ActionContext context) {
        logger.debug((Object)"preExcute");
    }

    public abstract boolean doExecute(ActionContext var1);

    public void postExcute(ActionContext context) {
        logger.debug((Object)"postExcute");
    }

    public void callBack(ActionContext context) {
        logger.debug((Object)"callBack");
    }

    protected List<ReplicationRelationBo> getReplicationRelationBos(ActionContext context) {
        logger.debug((Object)"Method getReplicationRelationBos.");
        Set poReplicas = (Set)context.getObject("PO_REPLICA_ENTITY");
        if (VerifyUtil.isEmpty((Collection)poReplicas)) {
            logger.error((Object)"poReplicas is empty.");
            return null;
        }
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(pg.getTemplate().getType())) {
            return this.getReplicationRelationBosFromPg(context, poReplicas);
        }
        List<ReplicationRelationBo> rrbs = this.getReplicationRelationBos(context, poReplicas);
        context.addObject("PO_GROUP_MAP", rrbs);
        return rrbs;
    }

    protected List<ReplicationRelationBo> getReplicationRelationBos(ActionContext context, Set<ProtectObjectReplica> poReplicas) {
        logger.debug((Object)"getReplicationRelationBos");
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        List rrbs = pg.getReplicationRelationBos(poReplicas);
        return rrbs;
    }

    protected ProtectGroupLogDetail initActionLog(ActionContext context, ProtectGroupLog historyLog) {
        logger.debug((Object)"initActionLog");
        Date startTime = new Date();
        ProtectGroupLogDetail historyDetailLog = ProtectionJobUtil.getInstance().createActionLog("", this.getName(), startTime);
        historyLog.getPgHistoryLogDetails().add(historyDetailLog);
        historyDetailLog.setLogId(historyLog.getHistoryLogId());
        return historyDetailLog;
    }

    public boolean isAppConsistent(ActionContext context) {
        Schedule schedule = this.getSchedule(context);
        if (null == schedule) {
            logger.warn((Object)"Protetion task schedule is null");
            return false;
        }
        Boolean isAppConsistent = schedule.isAppConsistent();
        logger.debug((Object)"App Consistent is %s", new Object[]{isAppConsistent});
        return null == isAppConsistent ? false : isAppConsistent;
    }

    public Object clone() throws CloneNotSupportedException {
        logger.debug((Object)"clone");
        Object obj = super.clone();
        if (obj != null) {
            AbstractBaseProtectAction action = (AbstractBaseProtectAction)obj;
            action.setActionId(UUIDGenerator.getUUID());
            action.setParams(new ConcurrentHashMap<String, String>(this.params));
        }
        return obj;
    }

    public String getActionId() {
        logger.debug((Object)"getActionId");
        return this.actionId;
    }

    public void setActionId(String actionId) {
        logger.debug((Object)"setActionId");
        this.actionId = actionId;
    }

    public boolean equals(Object paramObject) {
        logger.debug((Object)"equals");
        if (paramObject == null) {
            return false;
        }
        if (paramObject instanceof AbstractBaseProtectAction) {
            AbstractBaseProtectAction action = (AbstractBaseProtectAction)paramObject;
            return action.getActionId().equals(this.actionId);
        }
        return false;
    }

    public int hashCode() {
        logger.debug((Object)"hashCode");
        return this.actionId.hashCode();
    }

    public Schedule getSchedule(ActionContext context) {
        ProtectionTask task = (ProtectionTask)context.getObject("TASK_ENTITY", ProtectionTask.class);
        if (task == null) {
            logger.warn((Object)"Cannot get protection task from actionContext by key:%s", new Object[]{"TASK_ENTITY"});
            return null;
        }
        return task.getSchedule();
    }

    protected int getResult(boolean flag) {
        logger.debug((Object)"getResult");
        if (flag) {
            return 1;
        }
        return 0;
    }

    public void checkParams(Map<String, String> param) {
        logger.debug((Object)"checkParams");
    }

    public String getProtectGroupId() {
        logger.debug((Object)"getProtectGroupId");
        return this.protectGroupId;
    }

    public void setProtectGroupId(String protectGroupId) {
        logger.debug((Object)"setProtectGroupId");
        this.protectGroupId = protectGroupId;
    }

    public String getActionType() {
        logger.debug((Object)"getActionType");
        return this.actionType;
    }

    public void setActionType(String actionType) {
        logger.debug((Object)"setActionType");
        this.actionType = actionType;
    }

    public int getProtectLocation() {
        logger.debug((Object)"getProtectLocation");
        return this.protectLocation;
    }

    public void setProtectLocation(int protectLocation) {
        logger.debug((Object)"setProtectLocation");
        this.protectLocation = protectLocation;
    }

    public boolean isEditable() {
        logger.debug((Object)"isEditable");
        return this.editable;
    }

    public void setEditable(boolean editable) {
        logger.debug((Object)"setEditable");
        this.editable = editable;
    }

    public String getPreAction() {
        logger.debug((Object)"getPreAction");
        return this.preAction;
    }

    public void setPreAction(String preAction) {
        logger.debug((Object)"setPreAction");
        this.preAction = preAction;
    }

    public String getNextAction() {
        logger.debug((Object)"getNextAction");
        return this.nextAction;
    }

    public void setNextAction(String nextAction) {
        logger.debug((Object)"setNextAction");
        this.nextAction = nextAction;
    }

    public String getName() {
        return VerifyUtil.isEmpty((String)this.name) ? this.getClass().getName() : this.name;
    }

    public String getNameParams() {
        logger.debug((Object)"getNameParams");
        return this.nameParams;
    }

    public String getDetail() {
        logger.debug((Object)"getDetail");
        return VerifyUtil.isEmpty((String)this.detail) ? "--" : this.detail;
    }

    public void setDetail(String detail) {
        logger.debug((Object)"setDetail");
        this.detail = detail;
    }

    public String getDetailParams() {
        logger.debug((Object)"getDetailParams");
        return this.detailParams;
    }

    public void setDetailParams(String detailParams) {
        logger.debug((Object)"setDetailParams");
        this.detailParams = detailParams;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Map<String, String> getParams() {
        logger.debug((Object)"getParams");
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        logger.debug((Object)"setParams");
        this.params = params;
    }

    public void setName(String name) {
        logger.debug((Object)"setName");
        this.name = name;
    }

    public void setNameParams(String nameParams) {
        logger.debug((Object)"setNameParams");
        this.nameParams = nameParams;
    }

    public Integer getProtectedType() {
        return this.protectedType;
    }

    public void setProtectedType(Integer protectedType) {
        this.protectedType = protectedType;
    }

    public void setIgnoreFailure(Boolean ingoreFailue) {
        this.params.put(IGNORE_FAILURE, String.valueOf(ingoreFailue));
    }

    public Boolean getIngoreFailure() {
        String ignoreFailureStr = this.params.get(IGNORE_FAILURE);
        logger.debug((Object)"ignoreFailureStr%s", new Object[]{ignoreFailureStr});
        if (VerifyUtil.isEmpty((String)ignoreFailureStr)) {
            return false;
        }
        return Boolean.valueOf(ignoreFailureStr);
    }

    private List<ReplicationRelationBo> getReplicationRelationBosFromPg(ActionContext context, Set<ProtectObjectReplica> poReplicas) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        Set protectGroupReplicas = pg.getReplicaList();
        ProtectGroupReplica pgReplica = this.getReplicaByPoReps(poReplicas);
        Set<ProtectObjectReplica> newPoReplicas = new HashSet<ProtectObjectReplica>();
        if (!VerifyUtil.isEmpty((Collection)protectGroupReplicas)) {
            for (ProtectGroupReplica replica : protectGroupReplicas) {
                if (ProtectGroupUtil.isLocalStorageReplica(replica) || VerifyUtil.isEmpty((Object)pgReplica) || !replica.getId().equals(pgReplica.getId())) continue;
                newPoReplicas.addAll(replica.getReplicas());
            }
        }
        if (CollectionUtils.isEmpty(newPoReplicas)) {
            logger.error((Object)"NewPoReplicas is empty, put old poReplicas.");
            newPoReplicas = poReplicas;
        }
        return this.getReplicationRelationBos(context, newPoReplicas);
    }

    private ProtectGroupReplica getReplicaByPoReps(Set<ProtectObjectReplica> poReplicas) {
        Optional opt = poReplicas.stream().findFirst();
        return opt.map(ProtectObjectReplica::getPgReplica).orElse(null);
    }

    protected void setTimeStamp(ActionContext context) {
        Map map = (Map)context.getObject("EXCUTE_PARAMETER_MAP");
        String timeStamp = null;
        if (map != null && map.get("REPLICA_TIMESTANP") instanceof String) {
            timeStamp = (String)map.get("REPLICA_TIMESTANP");
        }
        context.addObject("REPLICA_TIMESTANP", VerifyUtil.isEmpty(timeStamp) ? String.valueOf(new Date().getTime()) : timeStamp);
    }

    public boolean execute(ActionContext context) {
        if (this.enable) {
            return this.doExecute(context);
        }
        return true;
    }

    public final String constructParams(String[] param) {
        if (null == param) {
            logger.debug((Object)"param in empty");
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < param.length; ++i) {
            buf.append(param[i]);
            if (i >= param.length - 1) continue;
            buf.append(';');
        }
        return buf.toString();
    }

    protected final String getRecoverSiteIdBySchedule(int location, ProtectGroup pg) {
        String result = "";
        for (Schedule schedule : pg.getTemplate().getSchedules()) {
            String targetSiteId = schedule.getTargetSiteId();
            if (schedule.getProtectLocation() != location || VerifyUtil.isEmpty((String)targetSiteId)) continue;
            return targetSiteId;
        }
        return result;
    }

    public void checkInterruptPoint() {
        boolean isInterrupt = Thread.currentThread().isInterrupted();
        if (isInterrupt) {
            logger.info((Object)"checked current thread is interrupted, need stop name:%s", new Object[]{Thread.currentThread().getName()});
            throw new LegoCheckedException(-1L);
        }
    }

    protected void setBackScriptParams(ActionContext context, Map<String, String> scriptParams, String key) {
        JSONObject scriptJsonParams = JSONObject.fromObject((Object)scriptParams.get(key));
        SnapShotAssociateProtectObject apo = (SnapShotAssociateProtectObject)context.getObject("PO_GROUP_MAP");
        Map<String, String> snapshotInfo = apo.getSnapshotInfo();
        StringBuilder srcLunIds = new StringBuilder();
        StringBuilder snapshotIds = new StringBuilder();
        StringBuilder srcLunWwns = new StringBuilder();
        if (!VerifyUtil.isEmpty(snapshotInfo)) {
            for (Map.Entry<String, String> info : snapshotInfo.entrySet()) {
                srcLunIds.append(info.getKey() + ",");
                snapshotIds.append(info.getValue() + ",");
            }
            if (!VerifyUtil.isEmpty((Object)srcLunIds)) {
                srcLunIds.setLength(srcLunIds.length() - 1);
            }
            if (!VerifyUtil.isEmpty((Object)snapshotIds)) {
                snapshotIds.setLength(snapshotIds.length() - 1);
            }
        }
        String srcProviderSn = apo.getSrcStorageProviderSN();
        List<ProtectObjectStorageInfo> allProtectObjectStorageInfo = this.getAllProtectObjectStorageInfo(context);
        if (!VerifyUtil.isEmpty((Object)srcLunIds) && !VerifyUtil.isEmpty(allProtectObjectStorageInfo)) {
            String[] srcLunIdArr;
            for (String lunId : srcLunIdArr = srcLunIds.toString().split(",")) {
                for (ProtectObjectStorageInfo protectObjectStorageInfo : allProtectObjectStorageInfo) {
                    if (!lunId.equals(protectObjectStorageInfo.getResourceId())) continue;
                    srcLunWwns.append(protectObjectStorageInfo.getLunWWN() + ",");
                }
            }
        }
        if (!VerifyUtil.isEmpty((Object)srcLunWwns)) {
            srcLunWwns.setLength(srcLunWwns.length() - 1);
        }
        scriptJsonParams.put((Object)"SrcLunIds", (Object)srcLunIds.toString());
        scriptJsonParams.put((Object)"SnapshotIds", (Object)snapshotIds.toString());
        scriptJsonParams.put((Object)"SrcLunWWNs", (Object)srcLunWwns.toString());
        scriptJsonParams.put((Object)"SrcProviderSN", (Object)srcProviderSn);
        scriptParams.put(key, scriptJsonParams.toString());
    }

    protected List<ProtectObjectStorageInfo> getAllProtectObjectStorageInfo(ActionContext context) {
        ArrayList<ProtectObjectStorageInfo> protectObjectStorageInfoList = new ArrayList<ProtectObjectStorageInfo>();
        Set pos = (Set)context.getObject("PO_ENTITY");
        for (ProtectObject po : pos) {
            Set usedStorageResourceSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo protectObjectStorageInfo : usedStorageResourceSet) {
                protectObjectStorageInfoList.add(protectObjectStorageInfo);
            }
        }
        return protectObjectStorageInfoList;
    }

    protected final void sendSnapShotExceedLimitMsg(String pgId, long createSnapShotErrorCode) {
        if (StorageManagerUtil.isExceedLimit(createSnapShotErrorCode)) {
            logger.debug((Object)"sendNotification  sendSnapShotOverSpecificationMsg");
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(20003L);
            mu.setObj((Object)pgId);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(DrmBaseApplication.class.getName());
            ((IMessageCenter)ServiceLocator.getInstance().getService(IMessageCenter.class)).sendMessage(mu);
        }
    }

    static class ReplicationProgress {
        private boolean completed;
        private Integer progress;

        ReplicationProgress() {
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public ReplicationProgress setCompleted(boolean isCompletedParam) {
            this.completed = isCompletedParam;
            return this;
        }

        public Integer getProgress() {
            return this.progress;
        }

        public ReplicationProgress setProgress(Integer progressParam) {
            this.progress = progressParam;
            return this;
        }
    }
}

