/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.executor;

import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.executor.FixedProtectionThreadPool;
import com.huawei.ism.drm.protection.framework.engine.executor.ProtectionActionMonitorCallable;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectActionLogManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ProtectionExecutorCallable
implements Callable<Boolean> {
    private static final Log logger = LogFactory.getInstance(ProtectionExecutorCallable.class);
    private ActionContext context;
    private AbstractBaseProtectAction action;
    private CountDownLatch doneSignal;
    private ProtectGroupLogDetail detail;

    public ProtectionExecutorCallable(AbstractBaseProtectAction action, ActionContext context, CountDownLatch doneSignal, ProtectGroupLogDetail historyDetailLog) {
        this.action = action;
        this.context = context;
        this.doneSignal = doneSignal;
        this.detail = historyDetailLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        boolean executeResult = true;
        try {
            ProtectionActionMonitorCallable monitorCallable = new ProtectionActionMonitorCallable(this.action, true, this.detail);
            Future<Boolean> monitorResult = null;
            try {
                Date currentDate = new Date();
                this.detail.setStartTime(String.valueOf(currentDate.getTime()));
                this.detail.setResult(2L);
                ProtectActionLogManager.getInstance().saveOrUpdateProtectGroupLogDetail(this.detail);
                monitorResult = FixedProtectionThreadPool.submit(FixedProtectionThreadPool.FixedProtectionThreadPoolEnum.PROTECT_MONITOR_EXECUTOR, monitorCallable);
                executeResult = this.action.execute(this.context);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"action execute failed!", (Throwable)e, e.getErrorCode());
                executeResult = false;
            }
            catch (Exception e) {
                logger.error((Object)"action execute failed. error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                executeResult = false;
            }
            this.callDealIssue(executeResult, monitorCallable, monitorResult);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"action execute failed!", (Throwable)e, e.getErrorCode());
        }
        catch (Exception e) {
            logger.error((Object)"action execute failed. error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            this.doneSignal.countDown();
        }
        return executeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callDealIssue(boolean executeResult, ProtectionActionMonitorCallable monitorCallable, Future<Boolean> monitorResult) throws InterruptedException, ExecutionException, TimeoutException {
        block8: {
            try {
                this.action.postExcute(this.context);
            }
            catch (Exception e) {
                logger.error((Object)"action post execute failed. error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            try {
                if (!executeResult) {
                    this.callbackAction(this.action);
                }
                monitorCallable.setUpdate(false);
                if (monitorResult == null) break block8;
            }
            catch (Exception e) {
                block9: {
                    try {
                        logger.error((Object)"action callback execute failed. error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                        monitorCallable.setUpdate(false);
                        if (monitorResult == null) break block9;
                    }
                    catch (Throwable throwable) {
                        monitorCallable.setUpdate(false);
                        if (monitorResult != null) {
                            monitorResult.get(1L, TimeUnit.MINUTES);
                        }
                        Date currentDate = new Date();
                        this.detail.setEndTime(String.valueOf(currentDate.getTime()));
                        this.detail.setInfo(this.action.getDetail());
                        this.detail.setInfoParams(this.action.getDetailParams());
                        this.detail.setResult(executeResult ? 1L : 0L);
                        ProtectActionLogManager.getInstance().saveOrUpdateProtectGroupLogDetail(this.detail);
                        throw throwable;
                    }
                    monitorResult.get(1L, TimeUnit.MINUTES);
                }
                Date currentDate = new Date();
                this.detail.setEndTime(String.valueOf(currentDate.getTime()));
                this.detail.setInfo(this.action.getDetail());
                this.detail.setInfoParams(this.action.getDetailParams());
                this.detail.setResult(executeResult ? 1L : 0L);
                ProtectActionLogManager.getInstance().saveOrUpdateProtectGroupLogDetail(this.detail);
            }
            monitorResult.get(1L, TimeUnit.MINUTES);
        }
        Date currentDate = new Date();
        this.detail.setEndTime(String.valueOf(currentDate.getTime()));
        this.detail.setInfo(this.action.getDetail());
        this.detail.setInfoParams(this.action.getDetailParams());
        this.detail.setResult(executeResult ? 1L : 0L);
        ProtectActionLogManager.getInstance().saveOrUpdateProtectGroupLogDetail(this.detail);
    }

    private void callbackAction(AbstractBaseProtectAction actionParam) {
        try {
            actionParam.callBack(this.context);
        }
        catch (Exception e) {
            logger.error((Object)"post Execute error. error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }
}

