/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SystemScenarioUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.license.sdk.ILicenseBaseControl;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.DeleteProtectGroupTask;
import com.huawei.ism.drm.protection.framework.service.group.DeleteProtectObjectTask;
import com.huawei.ism.drm.protection.framework.service.group.ProtectCustomStepHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupQueryServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.RefreshProtectGroupBackTask;
import com.huawei.ism.drm.protection.framework.service.group.UpdatePolicyTemplateBackTask;
import com.huawei.ism.drm.protection.framework.service.group.UpdateProtectGroupTransaction;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateBaseTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupSyncRatePolicy;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.transaction.support.TransactionCallback;

public abstract class AbstractProtectGroupServiceImpl
extends ProtectGroupQueryServiceImpl
implements SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(AbstractProtectGroupServiceImpl.class);
    protected static final Object THREAD_LOCK = new Object();
    private static boolean started = false;
    protected IPolicyTemplateManager policyTemplateManager;
    protected IProtectionTaskService protectionTaskService;
    protected ILicenseBaseControl licenseControl;

    public ILicenseBaseControl getLicenseControl() {
        logger.debug((Object)"getLicenseControl");
        return this.licenseControl;
    }

    public void setLicenseControl(ILicenseBaseControl licenseControl) {
        logger.debug((Object)"setLicenseControl");
        this.licenseControl = licenseControl;
    }

    public IPolicyTemplateManager getPolicyTemplateManager() {
        logger.debug((Object)"getPolicyTemplateManager");
        return this.policyTemplateManager;
    }

    public void setPolicyTemplateManager(IPolicyTemplateManager policyTemplateManager) {
        logger.debug((Object)"setPolicyTemplateManager");
        this.policyTemplateManager = policyTemplateManager;
    }

    public IProtectionTaskService getProtectionTaskService() {
        logger.debug((Object)"getProtectionTaskService");
        return this.protectionTaskService;
    }

    public void setProtectionTaskService(IProtectionTaskService protectionTaskService) {
        logger.debug((Object)"setProtectionTaskService");
        this.protectionTaskService = protectionTaskService;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        logger.debug((Object)"onStatusChangedEvent");
        if (event.getStatus() == Status.STATUS_STARTED && !started) {
            this.initialize();
            AbstractProtectGroupServiceImpl.setStarted(true);
        }
    }

    public static void setStarted(boolean started) {
        logger.info((Object)"started:%s", new Object[]{started});
        AbstractProtectGroupServiceImpl.started = started;
    }

    @Override
    public void initialize() {
        logger.debug((Object)"initialize");
        super.initialize();
        this.createIndexForPgLogDetail(null);
    }

    public long createProtectGroup(ProtectGroup protectGroup, boolean createRp) {
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            logger.error((Object)"po list is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkProtectObjectQuantity(protectGroup.getPolist().size());
        this.licenseControl.isEnableCreateProtectGroup(protectGroup.getTemplate().getType());
        CreateProtectGroupRefineService instanceService = CreateProtectGroupRefineService.getInstance();
        instanceService.setConfigSyncRateService(this.getConfigSyncRateService());
        instanceService.setRetentionManager(this.getRetentionManager());
        return instanceService.createProtectGroup(protectGroup, createRp);
    }

    public void resetProtectGroupStatus(String protectGroupId) {
        String sql = String.join((CharSequence)" ", "update ti_protectgroup", "set status=?, LASTEXECTIME=null, LAST_EXEC_RESULT=null, LOCKTIME=null", "where PGID=?");
        this.getBaseDao().update(sql, new Object[]{DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus(), protectGroupId});
    }

    public synchronized void deleteProtectGroupFromSecondSite(String protectGroupId, Boolean forceDelete) {
        boolean isUsedProtectGroupByRp;
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId);
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.DELETE, protectGroup);
        if (!forceDelete.booleanValue()) {
            ProtectGroupHelper.getInstance().checkProductPGIsExisted(protectGroup);
        }
        if (isUsedProtectGroupByRp = ((IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class)).isUsedProtectGroupByAllRp(protectGroupId)) {
            logger.error((Object)"ProtectGroup(%s) is used by RecoveryPlan.", new Object[]{protectGroupId});
            throw new LegoCheckedException(1073948160L);
        }
        DeleteProtectGroupTask task = new DeleteProtectGroupTask(this, protectGroup);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProtectGroupById(String protectGroupId) {
        logger.info((Object)"Begin to delete protect group with id :%s", new Object[]{protectGroupId});
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            this.createIndexForPgLogDetail(session);
            session.beginTransaction();
            String delLogDetail = "DELETE FROM ti_protectgrouplogdetail t1 USING ti_protectgrouplog t2 WHERE t2.HISTORYLOGID = t1.HISTORYLOGID AND t2.PGID=:pgid";
            String delLog = "DELETE FROM ti_protectgrouplog where PGID=:pgid";
            String delPg = "DELETE FROM ti_protectgroup WHERE PGID=:pgid";
            NativeQuery qDelLogDetail = session.createSQLQuery(delLogDetail);
            qDelLogDetail.setString("pgid", protectGroupId);
            NativeQuery qDelLog = session.createSQLQuery(delLog);
            qDelLog.setString("pgid", protectGroupId);
            NativeQuery qDelPg = session.createSQLQuery(delPg);
            qDelPg.setString("pgid", protectGroupId);
            int dbResult = qDelLogDetail.executeUpdate();
            if (dbResult <= 0) {
                logger.warn((Object)"Current protect group do not contains any log detail or delete failed, pg id: %s.", new Object[]{protectGroupId});
            }
            if ((dbResult = qDelLog.executeUpdate()) <= 0) {
                logger.warn((Object)"Current protect group do not contains any log detail or delete failed, pg id: %s.", new Object[]{protectGroupId});
            }
            if ((dbResult = qDelPg.executeUpdate()) <= 0) {
                logger.error((Object)"Failed to delete protectGroup by id: %s", new Object[]{protectGroupId});
                throw new LegoCheckedException(-1L);
            }
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"Delete protectGroup by id failed!", (long)-1L, (String[])new String[0], (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                logger.info((Object)"End to delete protect group with id :%s", new Object[]{protectGroupId});
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
            logger.info((Object)"End to delete protect group with id :%s", new Object[]{protectGroupId});
        }
        DBOperationUtil.closeSession(session);
        logger.info((Object)"End to delete protect group with id :%s", new Object[]{protectGroupId});
    }

    public long removeProtectObjects(String protectGroupId, Set<ProtectObject> protectObjectSet) {
        logger.debug((Object)"enter removeProtectObjects");
        if (VerifyUtil.isEmpty(protectObjectSet)) {
            logger.error((Object)"failed to remove ProtectObjects because of invalidity paramiter.");
            throw new LegoCheckedException(1073947393L);
        }
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            logger.error((Object)"The pg is locked, pgId: %s.", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.REMOVE, protectGroup);
            ProtectGroupHelper.getInstance().checkAddOrRemovePoIsAvailable(protectGroup);
            DeleteProtectObjectTask task = new DeleteProtectObjectTask(this, protectGroup, protectObjectSet);
            if (PolicyTemplateBaseTools.getInstance().isNotimeout(protectGroup.getTemplate().getType())) {
                task.setTimeout(2147483);
            }
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        catch (LegoCheckedException e1) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw e1;
        }
        catch (Throwable e) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw new LegoCheckedException(-1L, ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    protected MessageEvent constructEnableMessage(ProtectGroup protectGroup, int messageType) {
        MessageEvent event = new MessageEvent();
        event.setMessageType(messageType);
        ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
        objectList.add(protectGroup);
        event.setObjectList(objectList);
        return event;
    }

    public long updateProtectGroupTemplate(String protectGroupId, PolicyTemplate policyTemplate) {
        logger.debug((Object)"enter updateProtectGroupTemplate.");
        if (protectGroupId == null || policyTemplate == null) {
            logger.error((Object)"param is error.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (protectGroup == null) {
            logger.error((Object)"cannot get protectGroup.");
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.UPDATE_TEMPLATE, protectGroup);
        protectGroup.setTemplate(policyTemplate);
        this.getRetentionManager().checkRetentionStrategy(protectGroup);
        UpdatePolicyTemplateBackTask task = new UpdatePolicyTemplateBackTask(this, protectGroup, policyTemplate);
        long taskId = BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProtectObjectProps(String protectGroupId, String protectObjectId, Map<String, String> protectObjectProps) {
        logger.debug((Object)"enter updateProtectObjectProps");
        if (VerifyUtil.isEmpty((String)protectGroupId) || VerifyUtil.isEmpty((String)protectObjectId) || VerifyUtil.isEmpty(protectObjectProps)) {
            logger.error((Object)"parameter is error.");
            throw new LegoCheckedException(1073947393L);
        }
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            logger.error((Object)"The pg is locked, pgId: %s.", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.UPDATE_PROTECTOBJECT_PROPS, protectGroup);
            ProtectObject protectObject = null;
            for (ProtectObject tempProtectObject : protectGroup.getPolist()) {
                if (!tempProtectObject.getUuid().equals(protectObjectId)) continue;
                protectObject = tempProtectObject;
            }
            if (null == protectObject) {
                logger.error((Object)"ProtectObject(%s) not exists", new Object[]{protectObjectId});
                throw new LegoCheckedException(1073947394L);
            }
            IProtectObjectBaseProvider poProvider = this.getProtectObjectProvider(protectObject.getPoType());
            poProvider.updateProtectObjectProps(protectObject, protectObjectProps);
            UpdateProtectGroupTransaction callBack = new UpdateProtectGroupTransaction(this, protectGroup, null);
            this.getBaseDao().getTransactionTemplate().execute((TransactionCallback)callBack);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long refreshProtectGroup(String protectGroupId) {
        logger.debug((Object)"enter refreshProtectGroup");
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            logger.error((Object)"The pg is locked: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            Object object = THREAD_LOCK;
            synchronized (object) {
                ProtectGroupHelper.getInstance().checkProtectGroupRefresh(protectGroup);
                ProtectGroupHelper.getInstance().checkPgOperationByRecoveryPlanStatus(protectGroup);
                RefreshProtectGroupBackTask task = new RefreshProtectGroupBackTask(this, protectGroup);
                return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
            }
        }
        catch (LegoCheckedException le) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw le;
        }
        catch (Throwable e) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            ExceptionUtil.rethrowException((Throwable)e, (String)("refresh error, protectGroupId: " + protectGroupId), (long)-1L, (String[])new String[0], (Log)logger);
            return -1L;
        }
    }

    public void updateProtectObjectProperties(ProtectGroup protectGroup) {
        logger.debug((Object)"enter updateProtectObjectProperties");
        IProtectObjectBaseProvider poProvider = this.getProtectObjectProvider(protectGroup.getPoType());
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            protectObject.setProtectGroup(protectGroup);
            poProvider.updateProtectObjectProps(protectObject, protectObject.getProps());
        }
        poProvider.buildProtectObjects(protectGroup);
        try {
            ArrayList<ProtectObject> protectObjectList = new ArrayList<ProtectObject>();
            protectObjectList.addAll(protectGroup.getPolist());
            ProtectGroupHelper.getInstance().deleteProtectObjectStorageInfo(protectObjectList);
        }
        catch (Exception e) {
            logger.error((Object)"delete temp po StorageInfo error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    protected void checkProtectObjectsInProtectGroup(ProtectGroup protectGroup) {
        logger.debug((Object)"checkProtectObjectsInProtectGroup");
        this.getProtectObjectProvider(protectGroup.getPoType()).checkProtectObjectsInProtectGroup(protectGroup);
    }

    public void createProtectionTask(ProtectGroup protectGroup) {
        logger.debug((Object)"createProtectionTask");
        this.protectionTaskService.createTask(protectGroup);
    }

    public void deleteProtectionTask(String protectGroupId) {
        logger.debug((Object)"deleteProtectionTask");
        this.protectionTaskService.deleteTaskAndJob(protectGroupId);
    }

    public void checkPolicyProps(int pgAppType, PolicyTemplate policyTemplate) {
        logger.debug((Object)"enter checkPolicyProps");
        if (null == policyTemplate) {
            logger.error((Object)"Policy template is null");
            throw new LegoCheckedException(1073947393L);
        }
        PolicyTemplate policyTemplateFromDB = this.getPolicyTemplateManager().getPtByUuid(policyTemplate.getUuid());
        if (policyTemplateFromDB == null) {
            logger.error((Object)"PolicyTemplate[%s] is not exists!", new Object[]{1073947394L, policyTemplate.getUuid()});
            throw new LegoCheckedException(1073947394L, "PolicyTemplate is not exists!");
        }
        IPolicyTemplateFilter filter = TemplateFilterManager.getInstance().getTemplateFilterByType(policyTemplate.getType());
        if (!filter.checkPolicyTemplate(policyTemplate)) {
            return;
        }
        IProtectObjectBaseProvider poProvider = this.getProtectObjectProvider(pgAppType);
        policyTemplate.setType(policyTemplateFromDB.getType());
        poProvider.checkPolicyProps(policyTemplate);
    }

    public void invalidProtectGroupReplica(String pgId, List<String> replicaIds) {
        logger.debug((Object)"enter invalidProtectGroupReplica");
        if (VerifyUtil.isEmpty((String)pgId) || VerifyUtil.isEmpty(replicaIds)) {
            logger.error((Object)"the parameters is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupHelper.getInstance().invalidProtectGroupReplica(pgId, replicaIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexForPgLogDetail(Session session) {
        logger.info((Object)"Create index TI_PROTECTGROUPLOGDETAIL_INDEX_RELATEDDETAILID");
        boolean isNewSession = false;
        try {
            if (null == session) {
                session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                isNewSession = true;
            }
            Transaction transaction = session.beginTransaction();
            String querySql = "SELECT 1 FROM pg_class c LEFT JOIN pg_namespace n ON n.oid = c.relnamespace WHERE n.nspname = 'PUBLIC' and c.relname  = 'TI_PROTECTGROUPLOGDETAIL_INDEX_RELATEDDETAILID'";
            NativeQuery alterQuery = session.createSQLQuery(querySql);
            List consList = alterQuery.list();
            if (null != consList && !consList.isEmpty()) {
                logger.info((Object)"Index TI_PROTECTGROUPLOGDETAIL_INDEX_RELATEDDETAILID has been exist.");
                transaction.commit();
                return;
            }
            String createIndexSql = "CREATE INDEX TI_PROTECTGROUPLOGDETAIL_INDEX_RELATEDDETAILID ON TI_PROTECTGROUPLOGDETAIL (RELATEDDETAILID)";
            NativeQuery cIndexQuery = session.createSQLQuery(createIndexSql);
            cIndexQuery.executeUpdate();
            transaction.commit();
        }
        catch (Exception ex) {
            DBOperationUtil.rollbackSession(session);
            logger.error((Object)"Failed to create index for TI_PROTECTGROUPLOGDETAIL. error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        finally {
            if (isNewSession) {
                DBOperationUtil.closeSession(session);
            }
        }
    }

    protected void checkProtectObjectQuantity(int addNum) {
        long limitNum = this.getLimitNum();
        String hql = "select count(*) from ProtectObject";
        long existNum = this.getBaseDao().getTotalCount(hql, new Object[0]);
        if ((long)addNum + existNum > limitNum) {
            logger.error((Object)"protectobject is over limit.current num:[%s], addNum:[%s]", new Object[]{existNum, addNum});
            throw new LegoCheckedException(1073948163L);
        }
    }

    private long getLimitNum() {
        long limitNum = SystemScenarioUtil.isOpenStackAvailable() ? LegoBaseConfig.getInstance().getNumber("protectobject.quantity.config", 1280000L) : LegoBaseConfig.getInstance().getNumber("protectobject.quantity.config", 3000L);
        return limitNum;
    }

    protected void resumeSyncRateTask(ProtectGroup protectGroup) {
        logger.debug((Object)"resumeSyncRateTask");
        PolicyTemplate policyTemplate = protectGroup.getTemplate();
        String protectGroupId = protectGroup.getUuid();
        if (!VerifyUtil.isEmpty((Map)policyTemplate.getProps())) {
            List<ProtectGroupSyncRatePolicy> pgsrps = ProtectGroupUtil.convertToSyncRatePolicy(policyTemplate);
            this.getConfigSyncRateService().updateSyncRateTask(protectGroupId, pgsrps);
            this.getConfigSyncRateService().runAtOnce(protectGroup, pgsrps, false);
        }
    }

    public void deleteSyncRateTask(String pgId) {
        logger.debug((Object)"deleteSyncRateTask");
        this.getConfigSyncRateService().deleteSyncRateTask(pgId);
    }

    public void deleteProtectGroupHistory(String protectGroupId) {
        logger.debug((Object)"enter deleteProtectGroupHistory");
        List<ProtectGroupLog> logs = this.queryProtectGroupLogs(protectGroupId, 1, "starttime", false);
        if (VerifyUtil.isEmpty(logs)) {
            return;
        }
        try {
            for (ProtectGroupLog log : logs) {
                List<ProtectGroupLogDetail> details = this.queryHistoryLogDetail(String.valueOf(log.getHistoryLogId()));
                for (ProtectGroupLogDetail detail : details) {
                    this.getBaseDao().getHibernateTemplate().delete((Object)detail);
                }
                this.getBaseDao().getHibernateTemplate().delete((Object)log);
            }
        }
        catch (Exception e) {
            logger.error((Object)"deleteProtectGroupHistory error, cause by: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public boolean checkPublicParamsChanged(String protectGroupId, Map<String, String> publicParams) {
        PolicyTemplate template = AbstractProtectGroupServiceImpl.queryPolicyTemplateByProtectGroup(protectGroupId);
        JSONObject newPublicParams = JSONObject.fromObject(publicParams);
        JSONObject oldPublicParams = JSONObject.fromObject(template.getProps().get("publicParam"));
        return ProtectCustomStepHelper.isParamChanged(newPublicParams, oldPublicParams);
    }

    public static PolicyTemplate queryPolicyTemplateByProtectGroup(String protectGroupId) {
        PolicyTemplate template = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            transaction = session.beginTransaction();
            Query query = session.createQuery("From ProtectGroup where uuid = :uuid");
            query.setParameter("uuid", (Object)protectGroupId);
            List results = query.list();
            if (VerifyUtil.isEmpty((Collection)results)) {
                throw new HibernateException("protect group is not exists", (Throwable)new LegoCheckedException(2117645L));
            }
            ProtectGroup protectGroup = (ProtectGroup)results.get(0);
            template = protectGroup.getTemplate();
            transaction.commit();
        }
        catch (HibernateException e) {
            try {
                DBOperationUtil.rollbackSession(session);
                LegoCheckedException exception = e.getCause() instanceof LegoCheckedException ? (LegoCheckedException)((Object)LegoCheckedException.class.cast(e.getCause())) : new LegoCheckedException(0x300001L);
                throw exception;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return template;
    }

    public long runSchedule(String protectGroupId, String scheduleId, Map<String, Object> parameter) {
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.MANUAL_EXECUTE, protectGroup);
        Schedule runSchedule = protectGroup.getTemplate().getSchedules().stream().filter(schedule1 -> schedule1.getScheduleId().equals(scheduleId)).findFirst().orElse(null);
        if (null == runSchedule) {
            logger.error((Object)"schedule is not exists, protectGroupId is %s and scheduleId is %s.", new Object[]{protectGroupId, scheduleId});
            throw new LegoCheckedException(1073947393L);
        }
        if (runSchedule.getPeriodType() == 5) {
            logger.error((Object)"Second snapshot schedule is not supported manual execute,protectGroupId is %s and scheduleId is %s", new Object[]{protectGroupId, scheduleId});
            throw new LegoCheckedException(1073948251L);
        }
        if (VerifyUtil.isEmpty(parameter)) {
            ProtectGroupHelper.getInstance();
            ProtectGroupHelper.checkTimeAllowExecute(protectGroup);
        } else {
            Integer procType = (Integer)parameter.get("SYNC_EXECUTE_IN_RECOVERY_PROCESS");
            if (VerifyUtil.isEmpty((Object)procType) || procType.intValue() != DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
                ProtectGroupHelper.getInstance();
                ProtectGroupHelper.checkTimeAllowExecute(protectGroup);
            }
        }
        return this.protectionTaskService.runTask(protectGroupId, scheduleId, parameter);
    }

    private ProtectGroup checkAndGetProtectGroup(String protectGroupId, Schedule schedule) {
        if (schedule == null) {
            logger.error((Object)"Schedule is null");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.UPDATE_TEMPLATE, protectGroup);
        return protectGroup;
    }
}

