/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.SystemScenarioUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.ProtectObjectConstant;
import com.huawei.ism.drm.drp.task.CreateRecoveryPlanBackTask;
import com.huawei.ism.drm.protection.framework.service.group.CreateProtectGroupTransaction;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.refinement.BaseProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderBaseDelegate;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.transaction.support.TransactionCallback;

public class CreateProtectGroupBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(CreateProtectGroupBackTask.class);
    private CreateProtectGroupRefineService service;
    private ProtectGroup protectGroup;
    private boolean createRp = false;
    private ProtectGroupHelper helper = ProtectGroupHelper.getInstance();

    public CreateProtectGroupBackTask(CreateProtectGroupRefineService service, ProtectGroup protectGroup, boolean createRp) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.pg.addpg", (String)MapUtils.getString((Map)protectGroup.getProps(), (Object)"createUser"), (String)"", null), true);
        this.service = service;
        this.protectGroup = protectGroup;
        this.protectGroup.setPrimary(true);
        this.createRp = createRp;
    }

    protected void doWork() {
        int poCount = this.protectGroup.getPoCount();
        try {
            ProtectObjectConstant.CREATING_PG_COUNT.addAndGet(1);
            ProtectObjectConstant.CREATING_PO_COUNT.addAndGet(poCount);
            CreateProtectGroupRefineService.checkProtectGroupTotalCount(this.protectGroup.getTemplate().getType());
            ProtectGroup tempProtectGroup = (ProtectGroup)this.protectGroup.clone();
            tempProtectGroup.setPolist(new HashSet(this.protectGroup.getPolist()));
            IProtectObjectBaseProvider poProvider = BaseProtectGroupRefineService.getProtectObjectProvider(tempProtectGroup.getPoType());
            if (VerifyUtil.isEmpty((Object)poProvider)) {
                logger.error((Object)("there is no ProtectObjectProvider for " + tempProtectGroup));
                throw new LegoCheckedException(1073947394L);
            }
            poProvider.checkProtectObjectsInProtectGroup(tempProtectGroup);
            this.excuteWork();
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"Error to clone ProtectGroup", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        finally {
            ProtectObjectConstant.CREATING_PG_COUNT.addAndGet(-1);
            ProtectObjectConstant.CREATING_PO_COUNT.addAndGet(-poCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excuteWork() {
        IProtectObjectProviderBaseDelegate providerDelegate = (IProtectObjectProviderBaseDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderBaseDelegate.class);
        for (ProtectObject po : this.protectGroup.getPolist()) {
            boolean checkResult = providerDelegate.testProtectObject(this.protectGroup.getPoType(), po);
            if (checkResult) continue;
            logger.error((Object)"Authorization for application unvalid.");
            throw new LegoCheckedException(1073947393L, "Authorization for application unvalid!");
        }
        HashSet<TaskResultItem> resultSet = new HashSet<TaskResultItem>();
        this.helper.lockPos(new HashSet<ProtectObject>(this.protectGroup.getPolist()), 5, this.getBackTask(), resultSet);
        try {
            this.helper.checkPoIsValid(this.protectGroup.getPolist(), this.protectGroup);
            MessageEvent event = new MessageEvent();
            event.setMessageType(0);
            ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
            objectList.add(this.protectGroup);
            event.setObjectList(objectList);
            this.service.notifyObserver(event, () -> {
                if (!this.service.getRetentionManager().checkRetentionStrategy(this.protectGroup)) {
                    throw new LegoCheckedException(1073947393L);
                }
                CreateProtectGroupTransaction callback = new CreateProtectGroupTransaction(this.service, this.protectGroup);
                CommonDAOLocator.getBaseDao().getTransactionTemplate().execute((TransactionCallback)callback);
            });
        }
        catch (LegoCheckedException le) {
            this.helper.notifyObserverException(this.protectGroup, 24);
            ExceptionUtil.rethrowException((Throwable)le, (String)("failed to create ProtectGroup(" + this.protectGroup.getUuid() + ")."), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
        }
        catch (Exception e) {
            this.helper.notifyObserverException(this.protectGroup, 24);
            ExceptionUtil.rethrowException((Throwable)e, (String)("failed to create ProtectGroup(" + this.protectGroup.getUuid() + ")."), (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            this.helper.unlockPos(this.protectGroup.getPolist(), 5);
        }
        this.createRecoveryPlan();
    }

    private void createRecoveryPlan() {
        boolean isCreateRp = false;
        if (SystemScenarioUtil.isOpenStackAvailable() && this.createRp) {
            isCreateRp = true;
        } else if (!SystemScenarioUtil.isOpenStackAvailable() && this.createRp && this.protectGroup.getTemplate().getType() != 38) {
            isCreateRp = true;
        }
        if (isCreateRp) {
            HashSet<ProtectGroup> protectGroups = new HashSet<ProtectGroup>();
            protectGroups.add(this.protectGroup);
            CreateRecoveryPlanBackTask task = new CreateRecoveryPlanBackTask(this.protectGroup.getOwnerId(), this.protectGroup.getName(), protectGroups);
            BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
    }
}

