/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.ObjectConvert;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.BaseProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectTempStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupHelperService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.TryCatchThrowable;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

public class ProtectGroupHelper {
    public static final String NOTIFY_TYPE_BEFORE = "before";
    public static final String NOTIFY_TYPE_AFTER = "after";
    public static final String NOTIFY_TYPE_ERROR = "onError";
    public static final String NOTIFY_TYPE_FINAL = "onFinal";
    public static final long DISABLED_NOT_SUPPORT_ERROR = 1073948193L;
    public static final long NORMAL_NOT_SUPPORT_ERROR = 1073948194L;
    public static final long WAITTING_NOT_SUPPORT_ERROR = 1073948693L;
    public static final long INVALID_NOT_SUPPORT_ERROR = 1073948195L;
    public static final long LOCKED_NOT_SUPPORT_ERROR = 1073948196L;
    public static final long RUNNING_NOT_SUPPORT_ERROR = 1073948197L;
    public static final String EXECTTE_PROTECT_LOCATION = "executeProtectLocation_";
    public static final String CONCURRENT_SYNC_ASYNC_RING_SKETCH = "policy_template_5_concurrent_sa_dr_star.png";
    public static final String CASCADE_SYNC_ASYNC_RING_SKETCH = "policy_template_3_cascaded_sa_dr_star.png";
    private static final List<Integer> MATCH_TEMPLATE_FILTER_BY_TEMPLATE = Arrays.asList(17, 28, 20, 3, 5, 38, 39);
    private static final Map<Integer, List<Integer>> TEMPLATE_TYPE_CONVERT = new HashMap<Integer, List<Integer>>();
    private static final Map<String, Map<Integer, String>> TEMPLATE_SKETCH_CONVERT = new HashMap<String, Map<Integer, String>>();
    private static final long[][] STATUS_OPT;
    private static final Map<Integer, Set<ProtectGroupOpt>> TEMPLATE_FORBIDDEN_OPT;
    private static final Log logger;
    private static ProtectGroupHelper helperInstance;
    private static Map<Integer, Set<String>> moKeyMap;

    public static ProtectGroupHelper getInstance() {
        return helperInstance;
    }

    public void validateProtectGroupParameter(ProtectGroup protectGroup, boolean isAddObj) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"ProtectGroup is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)protectGroup.getUuid())) {
            protectGroup.setUuid(UUIDGenerator.getUUID());
        }
        if (VerifyUtil.isEmpty((String)protectGroup.getName())) {
            logger.error((Object)"ProtectGroup name is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)protectGroup.getPoType())) {
            logger.error((Object)"ProtectObject Type is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)protectGroup.getPoProviderSN())) {
            logger.error((Object)"ProtectObject ProviderSN is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)protectGroup.getProductSiteId())) {
            logger.error((Object)"Product Site Id or name is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (isAddObj && VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            logger.error((Object)"ProtectObject list is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (this.checkTemplateEmpty(protectGroup)) {
            logger.error((Object)"Policy template or template uuid is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (this.checkTemplateType(protectGroup)) {
            logger.error((Object)"Policy template type is error!");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean checkTemplateEmpty(ProtectGroup protectGroup) {
        logger.debug((Object)"checkTemplateEmpty");
        return VerifyUtil.isEmpty((Object)protectGroup.getTemplate()) || VerifyUtil.isEmpty((String)protectGroup.getTemplate().getUuid());
    }

    private boolean checkTemplateType(ProtectGroup protectGroup) {
        logger.debug((Object)"checkTemplateType");
        return VerifyUtil.isEmpty((Object)protectGroup.getTemplate().getType());
    }

    public boolean checkPoStorageInfoChanged(Set<ProtectObjectStorageInfo> older, Set<ProtectObjectStorageInfo> newer) {
        if (older == null || newer == null) {
            return false;
        }
        ArrayList<String> olderStorageInfo = new ArrayList<String>();
        ArrayList<String> newerStorageInfo = new ArrayList<String>();
        for (ProtectObjectStorageInfo poStorage : older) {
            olderStorageInfo.add(poStorage.getResourceProviderSN() + ":" + poStorage.getResourceId());
        }
        logger.debug((Object)"The olderStorageInfo:%s", new Object[]{((Object)olderStorageInfo).toString()});
        for (ProtectObjectStorageInfo poStorage : newer) {
            newerStorageInfo.add(poStorage.getResourceProviderSN() + ":" + poStorage.getResourceId());
        }
        logger.debug((Object)"The newerStorageInfo:%s", new Object[]{((Object)newerStorageInfo).toString()});
        for (String olderInfo : olderStorageInfo) {
            if (newerStorageInfo.contains(olderInfo)) {
                newerStorageInfo.remove(olderInfo);
                continue;
            }
            return true;
        }
        return !newerStorageInfo.isEmpty();
    }

    public Map<Integer, Integer> getClassifiedPolicyTemplates() {
        IProtectGroupHelperService protectGroupHelperService = (IProtectGroupHelperService)ServiceLocator.getInstance().getService(IProtectGroupHelperService.class);
        return protectGroupHelperService.getClassifiedPolicyTemplates();
    }

    public void checkProtectGroupOpt(ProtectGroupOpt opt, ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)((Object)opt)) || VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"Failed to operate protectGroup because of invalidity parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        int optValue = opt.getStatus();
        int status = protectGroup.getStatus();
        int templateType = protectGroup.getTemplate().getType();
        if (!this.getClassifiedPolicyTemplates().containsKey(templateType)) {
            logger.error((Object)"Failed to operate protectGroup, templateType(%s).", new Object[]{String.valueOf(templateType)});
            throw new LegoCheckedException(1073947393L);
        }
        this.checkOptStatus(optValue, status);
        if (TEMPLATE_FORBIDDEN_OPT.containsKey(templateType) && TEMPLATE_FORBIDDEN_OPT.get(templateType).contains((Object)opt)) {
            logger.error((Object)"Failed to operate protectGroup, templateType(%s) optValue(%s).", new Object[]{String.valueOf(templateType), String.valueOf(optValue)});
            throw new LegoCheckedException(1073948184L);
        }
        if (!protectGroup.isPrimary()) {
            if (this.checkStatus(opt)) {
                return;
            }
            logger.error((Object)"Failed to operate protectGroup.");
            throw new LegoCheckedException(1073948184L);
        }
    }

    public boolean checkProtectGroupDatastoreBelong(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            logger.error((Object)"Protect group is null!");
            throw new LegoCheckedException(1073947393L);
        }
        Set poList = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)poList)) {
            logger.error((Object)"Protect object list is empty, protect group name: %s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        List storageInfoList = poList.stream().map(ProtectObject::getUsedStorageResourceSet).filter(storageResource -> !VerifyUtil.isEmpty((Collection)storageResource)).flatMap(Collection::stream).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(storageInfoList)) {
            logger.error((Object)"Storage info list is empty, protect group name: %s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return storageInfoList.stream().map(ProtectObjectStorageInfo::getResourceProviderSN).filter(sn -> !VerifyUtil.isEmpty((String)sn)).distinct().count() == 1L;
    }

    public void checkOptStatus(int optValue, int status) {
        if (optValue >= ProtectGroupOpt.ERRORCODE.getStatus()) {
            logger.error((Object)"Failed to operate protectGroup, optValue(%s).", new Object[]{String.valueOf(optValue)});
            throw new LegoCheckedException(1073947393L);
        }
        if (status > DrmEnumDefine.ProtectGroupStatus.RUNNING.getStatus()) {
            logger.error((Object)"Failed to operate protectGroup, status(%s).", new Object[]{String.valueOf(status)});
            throw new LegoCheckedException(1073947393L);
        }
        if (status > STATUS_OPT.length || optValue > STATUS_OPT[status].length) {
            logger.error((Object)"failed to operate protectGroup, status(%s).", new Object[]{String.valueOf(status)});
            throw new LegoCheckedException(1073947393L);
        }
        if (STATUS_OPT[status][optValue] == 0L) {
            logger.error((Object)"failed to operate protectGroup, status(%s) optValue(%s).", new Object[]{String.valueOf(status), String.valueOf(optValue)});
            throw new LegoCheckedException(STATUS_OPT[status][ProtectGroupOpt.ERRORCODE.getStatus()]);
        }
    }

    public void checkAddOrRemovePoIsAvailable(ProtectGroup protectGroup) {
        logger.debug((Object)"chaeck add or remove po is available.", 90160758786988L);
        this.checkPgOperationByRecoveryPlanStatus(protectGroup);
    }

    public void checkPgOperationByRecoveryPlanStatus(ProtectGroup protectGroup) {
        RecoveryPlan plan;
        boolean isUsedProtectGroupByRp = ((IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class)).isUsedProtectGroupByRp(protectGroup.getUuid());
        if (isUsedProtectGroupByRp && !this.checkSubAddPo(plan = ((IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class)).getRecoveryPlan(((IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class)).getAssociatedRecoveryPlanWithProtectGroup(protectGroup.getUuid()), false, false))) {
            logger.error((Object)"Failed to operate protectGroup, recoveryPlan status: %s.", new Object[]{String.valueOf(plan.getPlanStatus())});
            throw new LegoCheckedException(1073948749L);
        }
    }

    private boolean checkSubAddPo(RecoveryPlan plan) {
        if (VerifyUtil.isEmpty((Object)plan)) {
            logger.error((Object)"Failed to search RecoveryPlan");
            throw new LegoCheckedException(1073948184L);
        }
        return plan.getPlanStatus() == DrmEnumDefine.RecoveryPlanStatusE.READY.getValue() || plan.getPlanStatus() == DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue() || plan.getPlanStatus() == DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED.getValue() || plan.getPlanStatus() == DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue();
    }

    private boolean checkStatus(ProtectGroupOpt opt) {
        logger.debug((Object)"checkStatus");
        return opt.getStatus() == ProtectGroupOpt.DELETE.getStatus() || opt.getStatus() == ProtectGroupOpt.LOCK.getStatus() || opt.getStatus() == ProtectGroupOpt.UNLOCK.getStatus();
    }

    public Boolean checkProductPGIsExisted(ProtectGroup protectGroup) {
        if (!protectGroup.isPrimary()) {
            Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(protectGroup.getProductSiteId());
            if (VerifyUtil.isEmpty((Object)site)) {
                logger.error((Object)"Failed to operate protectGroup");
                throw new LegoCheckedException(1073948184L);
            }
            RestClient client = SiteUtil.initClient(site);
            try {
                HashMap<String, String> uriVariables = new HashMap<String, String>();
                uriVariables.put("protectGroupId", protectGroup.getUuid());
                String url = "/ws/protectgroups/{protectGroupId}";
                client.invoke(url, uriVariables, HttpMethod.GET);
            }
            catch (LegoCheckedException e) {
                long errorCode = e.getErrorCode();
                if (errorCode == 1073947394L) {
                    logger.error((Object)"ProtectGroup is not exist.");
                    return false;
                }
                ExceptionUtil.rethrowException((Throwable)e, (String)e.getMessage(), (long)e.getErrorCode(), (String[])new String[0], (Log)logger);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"Query protectgroup from remote site error", (long)1073948184L, (String[])new String[0], (Log)logger);
            }
        }
        return true;
    }

    public void checkProtectGroupRefresh(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"Failed to operate protectGroup because of invalidity parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkProtectGroupOpt(ProtectGroupOpt.REFRESH, protectGroup);
        String isManual = (String)protectGroup.getProps().get("IS_MANUAL");
        if (!VerifyUtil.isEmpty((String)isManual) && String.valueOf(1).equals(isManual)) {
            logger.error((Object)"Failed to operate protectGroup, protectGroup's isManual(%s).", new Object[]{isManual});
            throw new LegoCheckedException(1073948184L);
        }
    }

    public void updateProtectObjectStorageInfo(ProtectGroup oldProtectGroup, ProtectGroup newProtectGroup) {
        logger.debug((Object)"updateProtectObjectStorageInfo");
        HashMap protectObjectMap = new HashMap();
        for (ProtectObject po : newProtectGroup.getPolist()) {
            HashSet olderStorageInfo = new HashSet();
            olderStorageInfo.addAll(po.getUsedStorageResourceSet());
            protectObjectMap.put(po.getMoUuid(), olderStorageInfo);
        }
        for (ProtectObject po : oldProtectGroup.getPolist()) {
            po.clearUsedStorageResource();
            Set newerStorageInfo = (Set)protectObjectMap.get(po.getMoUuid());
            po.setUsedStorageResourceSet(newerStorageInfo);
            po.setProtectGroup(oldProtectGroup);
        }
    }

    public void updateProtectObjectStorageInfo(ProtectGroup oldProtectGroup, ProtectObject newProtectObject) {
        logger.debug((Object)"updateProtectObjectStorageInfo");
        for (ProtectObject po : oldProtectGroup.getPolist()) {
            String oldMoUuid = po.getMoUuid();
            String newMoUuid = newProtectObject.getMoUuid();
            if (VerifyUtil.isEmpty((String)oldMoUuid) || !oldMoUuid.equals(newMoUuid)) continue;
            po.clearUsedStorageResource();
            Set newerStorageInfo = newProtectObject.getUsedStorageResourceSet();
            po.setUsedStorageResourceSet(newerStorageInfo);
            po.setProtectGroup(oldProtectGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectObject> getProtectObjectListByMoUUID(List<String> moUuIds) {
        List listResult = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add(Restrictions.in((String)"name", moUuIds));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            listResult = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"Method getProtectObjectListByMoUUID failed.", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return listResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectObject getProtectObjectByMoUUID(String protectGroupId, String uuId) {
        if (VerifyUtil.isEmpty((String)protectGroupId) || VerifyUtil.isEmpty((String)uuId)) {
            logger.error((Object)"The pgId or uuid is empty for getProtectObjectByMoUUID.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject result = null;
        Session session = null;
        try {
            List pos;
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add((Criterion)Restrictions.eq((String)"moUuid", (Object)uuId));
            crit.createAlias("protectGroup", "protectGroup").add((Criterion)Restrictions.eq((String)"protectGroup.pgId", (Object)protectGroupId));
            try {
                pos = crit.list();
            }
            catch (DataAccessException e) {
                logger.error((Object)"Failed to query ProtectObject.", (Throwable)e);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            if (!VerifyUtil.isEmpty((Collection)pos)) {
                result = (ProtectObject)pos.get(0);
            }
        }
        catch (Throwable throwable) {
            DBOperationUtil.closeSession(session);
            throw throwable;
        }
        DBOperationUtil.closeSession(session);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectObject getProtectObjectByMoUUID(int templateType, String uuId) {
        Session session;
        ProtectObject result;
        block5: {
            result = null;
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                Criteria crit = session.createCriteria(ProtectObject.class);
                crit.add((Criterion)Restrictions.eq((String)"moUuid", (Object)uuId));
                crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
                List protectObjectList = crit.list();
                if (VerifyUtil.isEmpty((Collection)protectObjectList)) break block5;
                for (ProtectObject protectObject : protectObjectList) {
                    ProtectGroup pg;
                    if (VerifyUtil.isEmpty((Object)protectObject) || templateType != (pg = protectObject.getProtectGroup()).getTemplate().getType()) continue;
                    result = protectObject;
                    break;
                }
            }
            catch (DataAccessException e) {
                try {
                    logger.error((Object)"Failed to query ProtectObject.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return result;
    }

    public void addBatchTaskResultItem(Set<ProtectObject> protectObjectSet, ProtectGroup protectGroup, BackTask resultItem, Set<TaskResultItem> resultSet) {
        boolean availableToShow = false;
        long emptyItemError = -1L;
        boolean poIsEmpty = this.isPoIsEmpty(protectGroup);
        List<Integer> allowTypes = Arrays.asList(16, 30, 31, 32);
        HashSet<ProtectObject> addPos = new HashSet<ProtectObject>();
        Iterator<ProtectObject> itr = protectObjectSet.iterator();
        while (itr.hasNext()) {
            Long errorCode = 0L;
            ProtectObject po = itr.next();
            String isManual = (String)po.getProps().get("IS_MANUAL");
            TaskResultItem result = this.getTaskResultItem(resultItem, po);
            try {
                if (this.checkManual(protectGroup, isManual)) {
                    logger.error((Object)"The po's 'IS_MANUAL' property is not the same with pg (%s).", new Object[]{protectGroup.getName()});
                    availableToShow = true;
                    errorCode = 1073948185L;
                    this.setResult(resultItem, errorCode, result, 1073948185L);
                } else if (this.checkSameProtectGroup(protectGroup, poIsEmpty, po)) {
                    logger.error((Object)"The po(%s) is existed in the same ProtectGroup.", new Object[]{po.getMoUuid()});
                    availableToShow = true;
                    errorCode = 1073948177L;
                    this.setResult(resultItem, errorCode, result, 1073948177L);
                } else if (!allowTypes.contains(protectGroup.getTemplate().getType()) && !VerifyUtil.isEmpty((Object)this.getProtectObjectByMoUUID(protectGroup.getTemplate().getType(), po.getMoUuid()))) {
                    logger.error((Object)"The po(%s) is existed in the same template ProtectGroup.", new Object[]{po.getMoUuid()});
                    availableToShow = true;
                    errorCode = 1073948177L;
                    this.setResult(resultItem, errorCode, result, 1073948177L);
                } else {
                    this.normalCase(protectGroup, addPos, po, result);
                }
            }
            catch (LegoCheckedException le) {
                logger.error((Object)"Add po error1.", (Throwable)le, 90160758786989L);
                availableToShow = true;
                errorCode = 0L == le.getErrorCode() ? -1L : le.getErrorCode();
                this.setResult(resultItem, errorCode, result, le.getErrorCode());
            }
            catch (Exception e) {
                logger.error((Object)"Add po error2, error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                errorCode = -1L;
                availableToShow = true;
                this.setResult(resultItem, errorCode, result, -1L);
            }
            emptyItemError = this.getEmptyItemError(resultSet, emptyItemError, errorCode, result);
        }
        this.judgeAfter(resultItem, resultSet, availableToShow, addPos, emptyItemError);
    }

    private boolean isPoIsEmpty(ProtectGroup protectGroup) {
        boolean poIsEmpty = false;
        if (protectGroup.getPolist().isEmpty()) {
            poIsEmpty = true;
        }
        return poIsEmpty;
    }

    private TaskResultItem getTaskResultItem(BackTask resultItem, ProtectObject po) {
        TaskResultItem result = new TaskResultItem();
        result.setResName(po.getName());
        result.setResultItem(resultItem);
        return result;
    }

    private long getEmptyItemError(Set<TaskResultItem> resultSet, long emptyItemError, Long errorCode, TaskResultItem result) {
        resultSet.add(result);
        if (errorCode != 0L) {
            emptyItemError = errorCode;
        }
        return emptyItemError;
    }

    private void judgeAfter(BackTask resultItem, Set<TaskResultItem> resultSet, boolean availableToShow, Set<ProtectObject> addPos, long emptyItemError) {
        if (availableToShow) {
            resultItem.setTaskResultSet(resultSet);
        }
        if (addPos.isEmpty()) {
            logger.error((Object)"The number %s of po which can be added is zero.", new Object[]{String.valueOf(emptyItemError)});
            throw new LegoCheckedException(emptyItemError);
        }
    }

    private void normalCase(ProtectGroup protectGroup, Set<ProtectObject> addPos, ProtectObject po, TaskResultItem result) {
        addPos.add(po);
        protectGroup.getPolist().add(po);
        po.setProtectGroup(protectGroup);
        result.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_SUCCESS));
        result.setDetail("ism.drm.site.success");
    }

    private void setResult(BackTask resultItem, Long errorCode, TaskResultItem result, long appNotSupportAdapterAndManual) {
        result.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
        result.setDetail("lego.err." + errorCode);
        resultItem.setTaskDetail(String.valueOf(appNotSupportAdapterAndManual));
    }

    private boolean checkSameProtectGroup(ProtectGroup protectGroup, boolean poIsEmpty, ProtectObject po) {
        logger.debug((Object)"checkSameProtectGroup");
        return !poIsEmpty && !VerifyUtil.isEmpty((Object)this.getProtectObjectByMoUUID(protectGroup.getUuid(), po.getMoUuid()));
    }

    private boolean checkManual(ProtectGroup protectGroup, String isManual) {
        return !VerifyUtil.isEmpty((String)isManual) && !isManual.equals(protectGroup.getProps().get("IS_MANUAL"));
    }

    public void checkPoIsValid(Set<ProtectObject> protectObjectSet, ProtectGroup protectGroup) {
        for (ProtectObject po : protectObjectSet) {
            Long errorCode;
            String isManual = (String)po.getProps().get("IS_MANUAL");
            List<Integer> allowTypes = Arrays.asList(16, 30, 31, 32);
            try {
                if (this.checkManual(protectGroup, isManual)) {
                    logger.error((Object)"The po's 'IS_MANUAL' property is not the same with pg (%s)", new Object[]{protectGroup.getName()});
                    errorCode = 1073948185L;
                    throw new LegoCheckedException(errorCode.longValue(), String.format(Locale.ROOT, "The po's 'IS_MANUAL' property is not the same with pg (%s)", protectGroup.getName()));
                }
                if (!VerifyUtil.isEmpty((Object)this.getProtectObjectByMoUUID(protectGroup.getUuid(), po.getMoUuid()))) {
                    logger.error((Object)"The po(%s) is existed in the same ProtectGroup.", new Object[]{po.getMoUuid()});
                    errorCode = 1073948177L;
                    throw new LegoCheckedException(errorCode.longValue(), "The po's 'IS_MANUAL' property is not the same with pg (" + protectGroup.getName() + ")");
                }
                if (allowTypes.contains(protectGroup.getTemplate().getType()) || VerifyUtil.isEmpty((Object)this.getProtectObjectByMoUUID(protectGroup.getTemplate().getType(), po.getMoUuid()))) continue;
                logger.error((Object)"The po(%s) is existed in the same template ProtectGroup.", new Object[]{po.getMoUuid()});
                errorCode = 1073948177L;
                throw new LegoCheckedException(errorCode.longValue(), "The po's 'IS_MANUAL' property is not the same with pg (" + protectGroup.getName() + ")");
            }
            catch (LegoCheckedException le) {
                ExceptionUtil.rethrowException((Throwable)le, (String)String.format(Locale.ROOT, "Failed to create ProtectGroup(%s).", protectGroup.getUuid()), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
            }
            catch (Exception e) {
                errorCode = -1L;
                ExceptionUtil.rethrowException((Throwable)e, (String)String.format(Locale.ROOT, "Failed to create ProtectGroup(%s).", protectGroup.getUuid()), (long)errorCode, (String[])new String[0], (Log)logger);
            }
        }
    }

    public synchronized void lockPos(Set<ProtectObject> pos, Integer opt, BackTask backTask, Set<TaskResultItem> resultSet) {
        HashSet<ProtectObject> allowPos = new HashSet<ProtectObject>();
        if (moKeyMap.containsKey(opt)) {
            Set<String> existUuids = moKeyMap.get(opt);
            for (ProtectObject po : pos) {
                if (existUuids.contains(po.getMoUuid())) {
                    this.unlockPos(allowPos, opt);
                    logger.error((Object)"po(%s) is under using. moCreatingMap = {%s}", new Object[]{po.getName(), existUuids.toString()});
                    this.generateResultSet(resultSet, pos, backTask);
                    backTask.setTaskResultSet(resultSet);
                    throw new LegoCheckedException(1073947906L, new String[]{po.getName()});
                }
                allowPos.add(po);
                existUuids.add(po.getMoUuid());
            }
        } else {
            moKeyMap.put(opt, this.getMoUuidSet(pos));
        }
    }

    private Set<String> getMoUuidSet(Set<ProtectObject> existPoIds) {
        logger.debug((Object)"getMoUuidSet");
        HashSet<String> allowPos = new HashSet<String>();
        for (ProtectObject po : existPoIds) {
            allowPos.add(po.getMoUuid());
        }
        return allowPos;
    }

    private void generateResultSet(Set<TaskResultItem> resultSet, Set<ProtectObject> pos, BackTask resultItem) {
        logger.debug((Object)"generateResultSet");
        for (ProtectObject po : pos) {
            TaskResultItem result = this.getTaskResultItem(resultItem, po);
            result.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
            result.setDetail("lego.err.-1");
            resultSet.add(result);
        }
    }

    public Set<TaskResultItem> removeBatchTaskResultItem(Set<ProtectObject> protectGroupSet, ProtectGroup protectGroup, BackTask resultItem, Map<String, ProtectObject> toRemovedProtectObjectMap) {
        HashSet<TaskResultItem> resultSet = new HashSet<TaskResultItem>();
        Iterator<ProtectObject> itr = protectGroupSet.iterator();
        boolean availableToShow = false;
        Map<String, ProtectObject> id2PoMap = this.getPoMap(protectGroup.getPolist());
        while (itr.hasNext()) {
            ProtectObject po = itr.next();
            TaskResultItem opt = this.getTaskResultItem(resultItem, po);
            if (VerifyUtil.isEmpty((String)po.getUuid())) {
                this.setResult(resultItem, 1073947393L, opt, 1073947393L);
                availableToShow = true;
            } else if (!protectGroup.getPolist().contains(po)) {
                this.setResult(resultItem, 1073947394L, opt, 1073947394L);
                availableToShow = true;
            } else {
                protectGroup.getPolist().remove(po);
                toRemovedProtectObjectMap.put(po.getUuid(), id2PoMap.get(po.getUuid()));
                opt.setResId(po.getUuid());
                opt.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_SUCCESS));
                opt.setDetail("ism.drm.site.success");
            }
            resultSet.add(opt);
        }
        this.removeBatchTaskResultItemAfterCheck(protectGroup, resultItem, toRemovedProtectObjectMap, resultSet, availableToShow);
        return resultSet;
    }

    private void removeBatchTaskResultItemAfterCheck(ProtectGroup protectGroup, BackTask resultItem, Map<String, ProtectObject> toRemovedProtectObjectMap, Set<TaskResultItem> resultSet, boolean availableToShow) {
        if (this.checkPoListIsEmpty(protectGroup)) {
            logger.error((Object)"Failed to remove protectobject from potectgroup(%s ,%s) because of polist is null.", new Object[]{protectGroup.getName(), protectGroup.getUuid()});
            for (TaskResultItem opt : resultSet) {
                opt.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
                opt.setDetail("lego.err.1073948166");
            }
            resultItem.setTaskResultSet(resultSet);
            throw new LegoCheckedException(1073948166L);
        }
        if (availableToShow) {
            resultItem.setTaskResultSet(resultSet);
        }
        if (VerifyUtil.isEmpty(toRemovedProtectObjectMap)) {
            logger.error((Object)"The number of po which can be removed is zero! pg:%s .", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(-1L);
        }
    }

    private Map<String, ProtectObject> getPoMap(Set<ProtectObject> polist) {
        HashMap<String, ProtectObject> id2PoMap = new HashMap<String, ProtectObject>();
        for (ProtectObject po : polist) {
            id2PoMap.put(po.getUuid(), po);
        }
        return id2PoMap;
    }

    private boolean checkPoListIsEmpty(ProtectGroup protectGroup) {
        logger.debug((Object)"checkPoListIsEmpty");
        Set polist = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)polist)) {
            return true;
        }
        int poType = protectGroup.getPoType();
        for (ProtectObject po : polist) {
            if (po.getPoType() != poType) continue;
            return false;
        }
        return true;
    }

    public void checkPolicyTemplate(ProtectGroup protectGroup) {
        IPolicyTemplateFilter filter = TemplateFilterManager.getInstance().getTemplateFilterByType(protectGroup.getTemplate().getType());
        if (filter == null) {
            logger.error((Object)"Cannot get policyTemplateFilter, pgUUid =%s .", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            protectObjects.add(protectObject);
        }
        IProtectGroupHelperService protectGroupHelperService = (IProtectGroupHelperService)ServiceLocator.getInstance().getService(IProtectGroupHelperService.class);
        List matchTemplateFilterByTemplate = protectGroupHelperService.getMatchTemplateFilterByTemplate();
        if (matchTemplateFilterByTemplate.contains(protectGroup.getTemplate().getType())) {
            if (!filter.isMatch(protectObjects, protectGroup.getTemplate())) {
                logger.error((Object)"ProtectObjects and PolicyTemplate does not match.");
                throw new LegoCheckedException(1073948191L);
            }
            return;
        }
        if (!filter.isMatch(protectObjects)) {
            logger.error((Object)"ProtectObjects and PolicyTemplate does not match.");
            throw new LegoCheckedException(1073948191L);
        }
    }

    public void checkPolicyTemplateForGroupRefresh(ProtectGroup protectGroup) {
        IPolicyTemplateFilter filter = TemplateFilterManager.getInstance().getTemplateFilterByType(protectGroup.getTemplate().getType());
        if (filter == null) {
            logger.error((Object)"Cannot get policyTemplateFilter, pgUUid =%s,errorCode=%s.", new Object[]{protectGroup.getUuid(), String.valueOf(1073947394L)});
            throw new LegoCheckedException(1073947394L);
        }
        if (PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_ASYNC_RING.getValue() == protectGroup.getTemplate().getType()) {
            ArrayList protectObjects = new ArrayList(protectGroup.getPolist());
            if (!filter.isMatchForGroupRefresh(protectObjects)) {
                logger.error((Object)"ProtectObjects and PolicyTemplate do not match.");
                throw new LegoCheckedException(1073948191L);
            }
        } else {
            this.checkPolicyTemplate(protectGroup);
        }
    }

    public PolicyTemplate matchAvailableTemplate(ProtectGroup protectGroup) {
        PolicyTemplate pgTemplate = protectGroup.getTemplate();
        int oldPgTemplateType = pgTemplate.getType();
        String pgTemplateSketch = pgTemplate.getSketch();
        List<Integer> converTemplate = TEMPLATE_TYPE_CONVERT.get(oldPgTemplateType);
        if (VerifyUtil.isEmpty(converTemplate) || VerifyUtil.isEmpty((String)pgTemplateSketch)) {
            logger.info((Object)"ConverTemplate or pgTemplateSketch is empty. oldPgTemplateType\uff1a%s", new Object[]{String.valueOf(oldPgTemplateType)});
            return null;
        }
        Map<Integer, String> convertSketchs = TEMPLATE_SKETCH_CONVERT.get(pgTemplateSketch);
        ArrayList<PolicyTemplate> allPolicyTemplate = new ArrayList<PolicyTemplate>();
        allPolicyTemplate.add(pgTemplate);
        IPolicyTemplateManager policyTemplateManager = (IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class);
        for (Integer type : converTemplate) {
            String targetSketch;
            PolicyTemplate newTemplate = policyTemplateManager.clonePolicyTemlate(type.intValue());
            newTemplate.setPtId(pgTemplate.getPtId());
            newTemplate.setUuid(pgTemplate.getUuid());
            newTemplate.setIsSystemDefine(Boolean.valueOf(true));
            newTemplate.setSchedules(pgTemplate.getSchedules());
            if (!VerifyUtil.isEmpty(convertSketchs) && !VerifyUtil.isEmpty((String)(targetSketch = convertSketchs.get(type)))) {
                newTemplate.setSketch(targetSketch);
            }
            allPolicyTemplate.add(newTemplate);
        }
        return this.matchTemplate(allPolicyTemplate, protectGroup);
    }

    private PolicyTemplate matchTemplate(List<PolicyTemplate> allPolicyTemplate, final ProtectGroup protectGroup) {
        for (final PolicyTemplate policyTemplate : allPolicyTemplate) {
            final IPolicyTemplateFilter templateFilter = TemplateFilterManager.getInstance().getTemplateFilterByType(policyTemplate.getType());
            final AtomicBoolean matchSuccess = new AtomicBoolean(false);
            new TryCatchThrowable(){

                protected void doTry() {
                    matchSuccess.set(templateFilter.isMatch(new ArrayList(protectGroup.getPolist()), policyTemplate));
                }

                protected void doCatch(Throwable e) {
                    logger.error((Object)"Match policyTemplate error, error :%s . ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
            }.run();
            if (!matchSuccess.get()) continue;
            logger.debug((Object)"Match success. type :%s", (long)policyTemplate.getType());
            return policyTemplate;
        }
        logger.error((Object)"Match template error.");
        return null;
    }

    public boolean isRebuildReplica(PolicyTemplate oldPolicyTemplate, PolicyTemplate newPolicyTemplate) {
        logger.debug((Object)"isRebuildReplica");
        boolean isRebuildReplica = this.isHyperMetroReplicaCntChanged(oldPolicyTemplate, newPolicyTemplate);
        String newReplicaCount = (String)newPolicyTemplate.getProps().get("PP_SNAPSHOT_COUNT");
        String oldReplicaCount = (String)oldPolicyTemplate.getProps().get("PP_SNAPSHOT_COUNT");
        if (!(VerifyUtil.isEmpty((String)newReplicaCount) || VerifyUtil.isEmpty((String)oldReplicaCount) || oldReplicaCount.equals(newReplicaCount))) {
            isRebuildReplica = true;
        }
        return isRebuildReplica;
    }

    public void updateBatchOperationResult(List<BatchOperation> resultList, Long singleResult) {
        logger.debug((Object)"updateBatchOperationResult");
        for (BatchOperation opt : resultList) {
            if (0L != opt.getErrorCode()) continue;
            opt.setErrorCode(singleResult.longValue());
        }
    }

    public void updateBatchTaskResult(Set<TaskResultItem> resultSet, Long singleResult, String[] resultParams) {
        logger.info((Object)"updateBatchTaskResult");
        for (TaskResultItem opt : resultSet) {
            if (CommonConstant.BACKTASK_RESULT_SUCCESS != opt.getResult()) continue;
            opt.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
            opt.setDetail("lego.err." + singleResult);
            if (VerifyUtil.isEmpty((Object[])resultParams)) continue;
            List paramList = AbstractBackTask.limitSize((String[])resultParams, (int)1000, (int)200);
            StringBuilder sb = new StringBuilder("");
            for (String resultParam : paramList) {
                sb.append(VerifyUtil.isEmpty((String)sb.toString()) ? resultParam : "|" + resultParam);
            }
            opt.setParam(sb.toString());
        }
    }

    public void updateBatchOperationResult(List<BatchOperation> resultList, LegoCheckedException le) {
        logger.debug((Object)"updateBatchTaskResult");
        Long singleResult = le.getErrorCode() == 0L ? Long.valueOf(-1L) : Long.valueOf(le.getErrorCode());
        for (BatchOperation opt : resultList) {
            if (0L != opt.getErrorCode()) continue;
            opt.setErrorCode(singleResult.longValue());
            opt.setDetailParam(le.getParameters());
        }
    }

    public synchronized void unlockPos(Set<ProtectObject> pos, Integer opt) {
        logger.debug((Object)"unlockPos");
        if (pos == null) {
            return;
        }
        Set<String> moUuidSet = moKeyMap.get(opt);
        if (moUuidSet == null) {
            return;
        }
        for (ProtectObject po : pos) {
            moUuidSet.remove(po.getMoUuid());
        }
    }

    public static String generateTaskUuid(ProtectGroup protectGroup, String type) {
        logger.debug((Object)"generateTaskUuid");
        StringBuilder builder = new StringBuilder(type);
        builder.append("-");
        builder.append(protectGroup.getUuid());
        builder.append("-");
        builder.append(UUIDGenerator.getUUID());
        return builder.toString();
    }

    public void buildReplica(ProtectGroup protectGroup) {
        this.buildReplica(protectGroup, true);
    }

    public void buildReplica(ProtectGroup protectGroup, boolean isNeedSave) {
        logger.debug((Object)"buildReplica");
        ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();
        IReplicaBuilder builder = factory.getTemplateByType(protectGroup.getTemplate().getType());
        if (builder != null) {
            builder.buildReplica(protectGroup);
            if (isNeedSave && !VerifyUtil.isEmpty((Object)protectGroup.getTemplate())) {
                ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).addTemplate(protectGroup.getTemplate());
            }
        }
    }

    public Set<ProtectGroupReplica> deleteReplica(ProtectGroup protectGroup) {
        logger.debug((Object)"deleteReplica");
        ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();
        IReplicaBuilder builder = factory.getTemplateByType(protectGroup.getTemplate().getType());
        if (builder != null) {
            return builder.beforeDeleteProtectGroup(protectGroup);
        }
        return null;
    }

    public void checkAndBuildReplica(ProtectGroup protectGroup) {
        logger.debug((Object)"checkAndBuildReplica");
        this.checkPolicyTemplate(protectGroup);
        this.buildReplica(protectGroup);
    }

    public void saveProtectObjectStorageInfo(ProtectObject ... protectObjectList) {
        logger.debug((Object)"saveProtectObjectStorageInfo");
        if (null == protectObjectList || protectObjectList.length == 0) {
            return;
        }
        for (ProtectObject protectObject : protectObjectList) {
            Set storageList = protectObject.getUsedStorageResourceSet();
            if (null == storageList || storageList.isEmpty()) continue;
            HashSet<ProtectObjectTempStorageInfo> tempList = new HashSet<ProtectObjectTempStorageInfo>();
            for (ProtectObjectStorageInfo storageInfo : storageList) {
                ProtectObjectTempStorageInfo temp = new ProtectObjectTempStorageInfo();
                ObjectConvert.antiConvert((Object)storageInfo, (Object)temp);
                temp.setArchiveLog(storageInfo.getArchiveLog());
                temp.setPoType(storageInfo.getPoType());
                temp.setResourceType(storageInfo.getResourceType());
                temp.setStorageType(storageInfo.getStorageType());
                temp.setStorageSubType(storageInfo.getStorageSubType());
                temp.setProtectObjectUuId(protectObject.getUuid());
                temp.setId(UUIDGenerator.getUUID());
                temp.setCurrentHostSn(storageInfo.getHostSN());
                temp.setHostSN(protectObject.getProviderSN());
                temp.setAlias(storageInfo.getAlias());
                tempList.add(temp);
            }
            CommonDAOLocator.getBaseDao().saveOrUpdateAll(tempList);
        }
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        logger.debug((Object)"loadProtectObjectStorageInfo");
        if (null == protectObjectList || protectObjectList.isEmpty()) {
            return;
        }
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        for (ProtectObject protectObject : protectObjectList) {
            String uuid = protectObject.getUuid();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("protectObjectUuId", uuid);
            List criterionList = baseDao.translatePropsToCriterions(map);
            List tempList = baseDao.createCriteria(ProtectObjectTempStorageInfo.class, criterionList.toArray(new Criterion[criterionList.size()]));
            if (tempList == null || tempList.isEmpty()) continue;
            protectObject.clearUsedStorageResource();
            for (ProtectObjectTempStorageInfo tempStorageInfo : tempList) {
                ProtectObjectStorageInfo storageInfo = new ProtectObjectStorageInfo();
                ObjectConvert.convert((Object)tempStorageInfo, (Object)storageInfo);
                storageInfo.setArchiveLog(tempStorageInfo.getArchiveLog());
                storageInfo.setPoType(tempStorageInfo.getPoType());
                storageInfo.setResourceType(tempStorageInfo.getResourceType());
                storageInfo.setStorageType(tempStorageInfo.getStorageType());
                storageInfo.setStorageSubType(tempStorageInfo.getStorageSubType());
                storageInfo.setAlias(tempStorageInfo.getAlias());
                storageInfo.setCurrentHostSn(tempStorageInfo.getCurrentHostSn());
                protectObject.setProviderSN(tempStorageInfo.getHostSN());
                protectObject.addHostStorageResourceInfo(storageInfo);
            }
        }
    }

    public void deleteProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        logger.debug((Object)"deleteProtectObjectStorageInfo");
        if (protectObjectList == null || protectObjectList.isEmpty()) {
            return;
        }
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        for (ProtectObject protectObject : protectObjectList) {
            String uuid = protectObject.getUuid();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("protectObjectUuId", uuid);
            List criterionList = baseDao.translatePropsToCriterions(map);
            List tempList = baseDao.createCriteria(ProtectObjectTempStorageInfo.class, criterionList.toArray(new Criterion[criterionList.size()]));
            if (null == tempList || tempList.isEmpty()) continue;
            baseDao.getHibernateTemplate().deleteAll((Collection)tempList);
        }
    }

    public boolean checkIsUnvalid(ProtectGroup protectGroup) {
        boolean checkResult = false;
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (1 != replica.getStatus()) continue;
            checkResult = true;
        }
        return checkResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetProtectGroupStatus(ProtectGroup pg) {
        String currentPgId = "";
        Session session = null;
        try {
            String sql = "UPDATE ti_protectgroup SET STATUS=?, LOCKTIME=?, LAST_EXEC_RESULT=?  WHERE PGID=?";
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            NativeQuery query = session.createSQLQuery(sql);
            query.setParameter(0, (Object)pg.getStatus());
            query.setParameter(1, (Object)pg.getLockTime());
            query.setParameter(2, (Object)pg.getLastExecResult());
            query.setString(3, pg.getUuid());
            int updateResult = query.executeUpdate();
            session.getTransaction().commit();
            if (updateResult != 1) {
                logger.error((Object)"Update protectGroup status failed.");
                throw new LegoCheckedException(-1L);
            }
        }
        catch (LegoCheckedException le) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Failed to update status of protectgroup(%s),error :%s.", new Object[]{currentPgId, ExceptionUtil.getErrorMessage((Throwable)le)});
                throw le;
                catch (DataAccessException e) {
                    DBOperationUtil.rollbackSession(session);
                    logger.error((Object)"Failed to update status of protectgroup(%s),error :%s.", new Object[]{currentPgId, ExceptionUtil.getErrorMessage((Throwable)e)});
                    throw new LegoCheckedException(-1L, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
    }

    public void invalidProtectGroupReplica(String pgId, List<String> replicaIds) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"The pg is Empty.");
            throw new LegoCheckedException(-1L);
        }
        List replicaList = ((IReplicaBaseService)ServiceLocator.getInstance().getService(IReplicaBaseService.class)).queryProtectGroupReplicaByGroup(pgId, "TIME_STAMP", false);
        ArrayList<String> pgrIds = new ArrayList<String>();
        for (ProtectGroupReplica pgr : replicaList) {
            String pgrId = pgr.getId();
            pgrIds.add(pgrId);
            if (!replicaIds.contains(pgrId) || DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue() != pgr.getStatus()) continue;
            pgr.setStatus(DrmEnumDefine.ReplicaStatus.ERROR_STATUS.getValue());
        }
        if (!pgrIds.containsAll(replicaIds)) {
            logger.error((Object)"Parameter[replicaIds] is not all legal! replicaIds: %s , pgrIds:%s .", new Object[]{replicaIds, pgrIds});
            throw new LegoCheckedException(-1L);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        this.resetReplicaIndex(replicaList, props);
        for (ProtectGroupReplica pgr : replicaList) {
            ((IReplicaBaseService)ServiceLocator.getInstance().getService(IReplicaBaseService.class)).updateProtectGroupReplica(pgr);
        }
        ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).saveOrUpdateProtectGroupProps(pgId, props);
        logger.debug((Object)"To invalid ProtectGroupReplica is sucessful!pgId: %s,replicaIds:%s", new Object[]{pgId, replicaIds});
    }

    private void resetReplicaIndex(List<ProtectGroupReplica> replicaList, Map<String, String> props) {
        List<ProtectGroupReplica> pgReplicaList;
        logger.debug((Object)"resetReplicaIndex");
        HashMap<Integer, List<ProtectGroupReplica>> protectLocation2PgReplica = new HashMap<Integer, List<ProtectGroupReplica>>();
        for (ProtectGroupReplica protectGroupReplica : replicaList) {
            int protectLocation = protectGroupReplica.getProtectLocation();
            pgReplicaList = (ArrayList<ProtectGroupReplica>)protectLocation2PgReplica.get(protectLocation);
            if (pgReplicaList != null) {
                pgReplicaList.add(protectGroupReplica);
                continue;
            }
            pgReplicaList = new ArrayList<ProtectGroupReplica>();
            pgReplicaList.add(protectGroupReplica);
            protectLocation2PgReplica.put(protectLocation, pgReplicaList);
        }
        for (Map.Entry entry : protectLocation2PgReplica.entrySet()) {
            Integer protectLocation = (Integer)entry.getKey();
            pgReplicaList = (List)entry.getValue();
            this.orderReplicaList(pgReplicaList);
            int size = pgReplicaList.size();
            for (int i = 0; i < size; ++i) {
                pgReplicaList.get(i).setIndex(i + 1);
            }
            props.put("DrmFrameWork_Pg_Replica_Inedx" + protectLocation, String.valueOf(1));
        }
    }

    public void orderReplicaList(List<ProtectGroupReplica> replicaList) {
        logger.debug((Object)"orderReplicaList");
        Collections.sort(replicaList, new Comparator<ProtectGroupReplica>(){

            @Override
            public int compare(ProtectGroupReplica pgr0, ProtectGroupReplica pgr1) {
                int power1;
                int status0 = pgr0.getStatus();
                int status1 = pgr1.getStatus();
                int power0 = ProtectGroupHelper.this.getPower(status0);
                if (power0 != (power1 = ProtectGroupHelper.this.getPower(status1))) {
                    Integer powerInteger0 = NumberUtil.convertToInteger((Object)power0);
                    Integer powerInteger1 = NumberUtil.convertToInteger((Object)power1);
                    return powerInteger0.compareTo(powerInteger1);
                }
                return pgr0.compareTo(pgr1);
            }
        });
    }

    private int getPower(int status) {
        switch (status) {
            case 1: 
            case 4: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 0: {
                return 1;
            }
        }
        logger.error((Object)"The Nas Snap builder don't support the status.");
        throw new LegoCheckedException(-1L);
    }

    public boolean checkSiteResourceExist(String providerSN, String siteId) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySnAndSiteId(providerSN, siteId);
        if (drResource == null) {
            logger.error((Object)"DrResource(SN: %s) is empty.", new Object[]{providerSN});
            return false;
        }
        Set childResources = drResource.getChildResources();
        if (!VerifyUtil.isEmpty((Collection)childResources)) {
            for (DrResource res : childResources) {
                if (!res.getSiteId().equals(siteId)) continue;
                return true;
            }
            return false;
        }
        return drResource.getSiteId().equals(siteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<ProtectObject> getProtectObjectListByUuid(List<String> uuids) {
        List listResult = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add(Restrictions.in((String)"uuid", uuids));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            listResult = crit.list();
        }
        catch (DataAccessException e) {
            logger.error((Object)"Method getProtectObjectListByUuid failed,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            DBOperationUtil.closeSession(session);
        }
        catch (Exception e2) {
            logger.error((Object)"Method getProtectObjectListByUuid failed,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
            {
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return listResult;
    }

    private boolean isHyperMetroReplicaCntChanged(PolicyTemplate oldPolicyTemplate, PolicyTemplate newPolicyTemplate) {
        logger.debug((Object)"isHyperMetroReplicaCntChanged");
        if (oldPolicyTemplate.getType() == 19 || oldPolicyTemplate.getType() == 17 || oldPolicyTemplate.getType() == 28) {
            ArrayList<DrmEnumDefine.ProtectLocation> allLocation = new ArrayList<DrmEnumDefine.ProtectLocation>();
            if (oldPolicyTemplate.getType() != 28) {
                allLocation.add(DrmEnumDefine.ProtectLocation.A_A);
            }
            allLocation.add(DrmEnumDefine.ProtectLocation.B_B);
            for (DrmEnumDefine.ProtectLocation location : allLocation) {
                int newCnt;
                int oldCnt = NumberUtil.convertToInteger(oldPolicyTemplate.getProps().get("PP_SNAPSHOT_COUNT" + location.getValue()));
                if (oldCnt == (newCnt = NumberUtil.convertToInteger(newPolicyTemplate.getProps().get("PP_SNAPSHOT_COUNT" + location.getValue())).intValue())) continue;
                return true;
            }
        }
        return false;
    }

    public void notifyObserverException(ProtectGroup protectGroup, int message) {
        MessageEvent event = new MessageEvent();
        event.setMessageType(message);
        ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
        objectList.add(protectGroup);
        event.setObjectList(objectList);
        BaseProtectGroupRefineService baseProtectGroupRefineService = new BaseProtectGroupRefineService();
        baseProtectGroupRefineService.notifyObserverList(event, NOTIFY_TYPE_AFTER);
    }

    public static void checkTimeAllowExecute(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"The protectGroup is null");
            throw new LegoCheckedException(1073947393L);
        }
        Date nowDate = new Date();
        Long lastExec = protectGroup.getLastExecTime();
        if (lastExec != null && nowDate.getTime() - lastExec < 240000L) {
            logger.error((Object)"Don't executeJob because time too short, protectGroup is %s, nowDate is %s, lastExecTime is %s, gap is %s.", new Object[]{protectGroup.getName(), nowDate, lastExec, nowDate.getTime() - lastExec});
            throw new LegoCheckedException(1073947723L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectObject> getProtectObjectListByRealMoUUID(List<String> moUuIds) {
        List listResult = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add(Restrictions.in((String)"moUuid", moUuIds));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            listResult = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"getProtectObjectListByMoUUID failed.", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return listResult;
    }

    static {
        TEMPLATE_TYPE_CONVERT.put(3, Arrays.asList(5));
        TEMPLATE_TYPE_CONVERT.put(5, Arrays.asList(3));
        HashMap<Integer, String> cascadeSyncAsyncRingAndSkech = new HashMap<Integer, String>();
        cascadeSyncAsyncRingAndSkech.put(3, CASCADE_SYNC_ASYNC_RING_SKETCH);
        TEMPLATE_SKETCH_CONVERT.put(CONCURRENT_SYNC_ASYNC_RING_SKETCH, cascadeSyncAsyncRingAndSkech);
        HashMap<Integer, String> concurrentSyncAsyncRingAndSkech = new HashMap<Integer, String>();
        concurrentSyncAsyncRingAndSkech.put(5, CONCURRENT_SYNC_ASYNC_RING_SKETCH);
        TEMPLATE_SKETCH_CONVERT.put(CASCADE_SYNC_ASYNC_RING_SKETCH, concurrentSyncAsyncRingAndSkech);
        STATUS_OPT = new long[][]{{1L, 0L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1073948193L}, {1L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 1073948194L}, {1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 1L, 0L, 0L, 1073948693L}, {1L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1073948195L}, {1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 1073948196L}, {1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1073948197L}};
        TEMPLATE_FORBIDDEN_OPT = new ImmutableMap.Builder().put((Object)0, (Object)ImmutableSet.of((Object)((Object)ProtectGroupOpt.MANUAL_EXECUTE), (Object)((Object)ProtectGroupOpt.AUTO_EXECUTE), (Object)((Object)ProtectGroupOpt.DISABLE), (Object)((Object)ProtectGroupOpt.ENABLE))).put((Object)8, (Object)ImmutableSet.of((Object)((Object)ProtectGroupOpt.MANUAL_EXECUTE), (Object)((Object)ProtectGroupOpt.AUTO_EXECUTE), (Object)((Object)ProtectGroupOpt.DISABLE), (Object)((Object)ProtectGroupOpt.ENABLE), (Object)((Object)ProtectGroupOpt.UPDATE_TEMPLATE))).put((Object)10, (Object)ImmutableSet.of((Object)((Object)ProtectGroupOpt.MANUAL_EXECUTE), (Object)((Object)ProtectGroupOpt.AUTO_EXECUTE), (Object)((Object)ProtectGroupOpt.DISABLE), (Object)((Object)ProtectGroupOpt.ENABLE), (Object)((Object)ProtectGroupOpt.UPDATE_TEMPLATE))).put((Object)12, (Object)ImmutableSet.of((Object)((Object)ProtectGroupOpt.MANUAL_EXECUTE), (Object)((Object)ProtectGroupOpt.AUTO_EXECUTE), (Object)((Object)ProtectGroupOpt.DISABLE), (Object)((Object)ProtectGroupOpt.ENABLE), (Object)((Object)ProtectGroupOpt.UPDATE_TEMPLATE))).put((Object)15, (Object)ImmutableSet.of((Object)((Object)ProtectGroupOpt.MANUAL_EXECUTE), (Object)((Object)ProtectGroupOpt.AUTO_EXECUTE), (Object)((Object)ProtectGroupOpt.DISABLE), (Object)((Object)ProtectGroupOpt.ENABLE), (Object)((Object)ProtectGroupOpt.UPDATE_TEMPLATE))).put((Object)21, (Object)ImmutableSet.of((Object)((Object)ProtectGroupOpt.MANUAL_EXECUTE), (Object)((Object)ProtectGroupOpt.AUTO_EXECUTE))).put((Object)23, (Object)ImmutableSet.of((Object)((Object)ProtectGroupOpt.MANUAL_EXECUTE), (Object)((Object)ProtectGroupOpt.AUTO_EXECUTE), (Object)((Object)ProtectGroupOpt.DISABLE), (Object)((Object)ProtectGroupOpt.ENABLE))).put((Object)24, (Object)ImmutableSet.of((Object)((Object)ProtectGroupOpt.MANUAL_EXECUTE), (Object)((Object)ProtectGroupOpt.AUTO_EXECUTE), (Object)((Object)ProtectGroupOpt.DISABLE), (Object)((Object)ProtectGroupOpt.ENABLE))).put((Object)25, (Object)ImmutableSet.of((Object)((Object)ProtectGroupOpt.MANUAL_EXECUTE), (Object)((Object)ProtectGroupOpt.AUTO_EXECUTE), (Object)((Object)ProtectGroupOpt.UPDATE_TEMPLATE))).put((Object)29, (Object)ImmutableSet.of((Object)((Object)ProtectGroupOpt.MANUAL_EXECUTE), (Object)((Object)ProtectGroupOpt.AUTO_EXECUTE), (Object)((Object)ProtectGroupOpt.UPDATE_TEMPLATE))).build();
        logger = LogFactory.getInstance(ProtectGroupHelper.class);
        helperInstance = new ProtectGroupHelper();
        moKeyMap = new HashMap<Integer, Set<String>>();
    }

    public static enum ProtectGroupOpt {
        CREATE(0),
        MOFIFY(1),
        DELETE(2),
        MANUAL_EXECUTE(3),
        AUTO_EXECUTE(4),
        DISABLE(5),
        ENABLE(6),
        ADD(7),
        REMOVE(8),
        UPDATE_STORAGEINFO(9),
        REFRESH(10),
        UPDATE_PROTECTOBJECT_PROPS(11),
        UPDATE_TEMPLATE(12),
        LOCK(13),
        UNLOCK(14),
        ERRORCODE(15);

        private int status;

        private ProtectGroupOpt(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public static ProtectGroupOpt valueOf(int status) {
            ProtectGroupOpt result = null;
            for (ProtectGroupOpt value : ProtectGroupOpt.values()) {
                if (status != value.getStatus()) continue;
                result = value;
                break;
            }
            return result;
        }
    }
}

