/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.protection.action.service.IHostScriptSchemeService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectCustomStepHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.Map;

public class ScriptPolicyObserver
implements IObjectObserver {
    public void before(MessageEvent event) {
        int messageType = event.getMessageType();
        if (messageType != 13) {
            return;
        }
        Map message = event.getMessageMap();
        Object protectGroupObject = message.get(ProtectGroup.class.getSimpleName());
        if (!(protectGroupObject instanceof ProtectGroup)) {
            return;
        }
        Object scheduleObject = message.get(Schedule.class.getSimpleName());
        if (!(scheduleObject instanceof Schedule)) {
            return;
        }
        Schedule schedule = (Schedule)scheduleObject;
        if (null == schedule.isAppConsistent() || !schedule.isAppConsistent().booleanValue()) {
            return;
        }
        ProtectGroup protectGroup = (ProtectGroup)protectGroupObject;
        if (protectGroup.getPoType() == 11 && protectGroup.getTemplate().getType() == 2) {
            ProtectCustomStepHelper.checkScriptParams(schedule);
            this.updateScriptSensitiveParams(protectGroup, schedule);
        }
    }

    public void after(MessageEvent event) {
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private void updateScriptSensitiveParams(ProtectGroup pg, Schedule schedule) {
        Map frontProps = schedule.getExtParameters();
        Schedule oldSchedule = pg.getTemplate().getSchedules().stream().filter(item -> item.getScheduleId().equals(schedule.getScheduleId())).findFirst().orElse(null);
        if (oldSchedule == null) {
            return;
        }
        Map backProps = oldSchedule.getExtParameters();
        String schemeId = (String)frontProps.get("scriptSchemeId");
        if (VerifyUtil.isEmpty((String)schemeId)) {
            return;
        }
        pg.getTemplate().getProps().put("scriptSchemeId", schemeId);
        String frontFreezeScriptParam = (String)frontProps.get("freezeParams");
        String backFreezeScriptParam = (String)backProps.get("freezeParams");
        String frontUnfreezeScriptParam = (String)frontProps.get("unfreezeParam");
        String backUnfreezeScriptParam = (String)backProps.get("unfreezeParam");
        String frontQueryFreezeScriptParam = (String)frontProps.get("queryParam");
        String backQueryFreezeScriptParam = (String)backProps.get("queryParam");
        String frontPublicScriptParam = (String)frontProps.get("publicParam");
        String backPublicScriptParam = (String)backProps.get("publicParam");
        Map paramValidation = ((IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class)).getParamValidation(schemeId);
        String freezeScriptParam = ScriptParamsUtils.updateSensitiveParam((Map)paramValidation, (String)frontFreezeScriptParam, (String)backFreezeScriptParam);
        String unfreezeScriptParam = ScriptParamsUtils.updateSensitiveParam((Map)paramValidation, (String)frontUnfreezeScriptParam, (String)backUnfreezeScriptParam);
        String queryFreezeScriptParam = ScriptParamsUtils.updateSensitiveParam((Map)paramValidation, (String)frontQueryFreezeScriptParam, (String)backQueryFreezeScriptParam);
        String publicScriptParam = ScriptParamsUtils.updateSensitiveParam((Map)paramValidation, (String)frontPublicScriptParam, (String)backPublicScriptParam);
        frontProps.put("freezeParams", freezeScriptParam);
        frontProps.put("unfreezeParam", unfreezeScriptParam);
        frontProps.put("queryParam", queryFreezeScriptParam);
        frontProps.put("publicParam", publicScriptParam);
    }
}

