/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.refinement;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.BaseProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class UpdateProtectGroupRefineService
extends BaseProtectGroupRefineService {
    private static final UpdateProtectGroupRefineService INSTANCE = new UpdateProtectGroupRefineService();
    private static final Log logger = LogFactory.getInstance(UpdateProtectGroupRefineService.class);
    private static final String PERFORMANCE_OPTIMIZATION_UPDATE = "PERFORMANCE_OPTIMIZATION_UPDATE";

    private UpdateProtectGroupRefineService() {
    }

    public static UpdateProtectGroupRefineService getInstance() {
        return INSTANCE;
    }

    public void updateProtectGroup(ProtectGroup protectGroup) {
        this.performanceOptimizationUpdate(protectGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performanceOptimizationUpdate(ProtectGroup protectGroup) {
        Session session = null;
        String isUpdated = (String)protectGroup.getProps().get(PERFORMANCE_OPTIMIZATION_UPDATE);
        if (!VerifyUtil.isEmpty((String)isUpdated)) {
            logger.error((Object)"this pg has been updated!");
            return;
        }
        Transaction transaction = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            transaction = session.beginTransaction();
            this.updatePo(protectGroup, session);
            this.updatePoReplica(protectGroup, session);
            protectGroup.getProps().put(PERFORMANCE_OPTIMIZATION_UPDATE, "true");
            session.saveOrUpdate((Object)protectGroup);
            transaction.commit();
        }
        catch (Exception e) {
            try {
                logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L);
                DBOperationUtil.rollbackSession(session);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    private void updatePo(ProtectGroup protectGroup, Session session) {
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            if (!VerifyUtil.isEmpty((String)protectObject.getStorageMetadata())) continue;
            String queryHostStorageResourceIdSql = "select id from ti_hoststorageresource where poid=?";
            List idList = CommonDAOLocator.getBaseDao().executeNativeSql(queryHostStorageResourceIdSql, new Object[]{protectObject.getUuid()});
            if (VerifyUtil.isEmpty((Collection)idList)) {
                logger.error((Object)"IdList is empty!protect group name:%s, po name:%s.", new Object[]{protectGroup.getName(), protectObject.getName()});
                continue;
            }
            String usedStorageQueryHql = "from ProtectObjectStorageInfo po where po.id in(:ids)";
            Query query = session.createQuery(usedStorageQueryHql);
            query.setParameterList("ids", (Collection)idList);
            List usedStorages = query.list();
            protectObject.setUsedStorageResourceSet(new HashSet(usedStorages));
        }
    }

    private void updatePoReplica(ProtectGroup protectGroup, Session session) {
        for (ProtectGroupReplica pgReplica : protectGroup.getReplicaList()) {
            if (!VerifyUtil.isEmpty((String)pgReplica.getPoReplicaMateData())) continue;
            String queryPoReplicaIdSql = "select id from ti_protectobjectreplica where pgreplicaid=?";
            List idList = CommonDAOLocator.getBaseDao().executeNativeSql(queryPoReplicaIdSql, new Object[]{pgReplica.getId()});
            if (VerifyUtil.isEmpty((Collection)idList)) {
                logger.error((Object)"idList is empty.");
                return;
            }
            String poReplicaHql = "from ProtectObjectReplica as poReplica where poReplica.id in (:ids)";
            Query query = session.createQuery(poReplicaHql);
            query.setParameterList("ids", (Collection)idList);
            List poReplicas = query.list();
            pgReplica.setReplicas(new HashSet(poReplicas));
            this.updateReplicaPo(protectGroup, poReplicas);
        }
    }

    private void updateReplicaPo(ProtectGroup protectGroup, List<ProtectObjectReplica> poReplicas) {
        if (ExecuteReplicaManager.getInstance().getRealTimeReplicaPolicyType().contains(protectGroup.getTemplate().getType())) {
            for (ProtectObjectReplica poReplica : poReplicas) {
                if (!VerifyUtil.isEmpty((Object)poReplica.getProtectObject())) continue;
                poReplica.setProtectObject(this.findProtectObject(protectGroup, poReplica.getPoId()));
            }
        }
    }

    private ProtectObject findProtectObject(ProtectGroup pg, String poId) {
        for (ProtectObject po : pg.getPolist()) {
            if (!po.getUuid().equals(poId)) continue;
            return po;
        }
        return null;
    }
}

