/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.provider;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.model.VMConfigs;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.orm.hibernate5.HibernateTemplate;

public abstract class AbstractBaseProtectObjectProvider
implements IProtectObjectBaseProvider {
    private static final Log logger = LogFactory.getInstance(AbstractBaseProtectObjectProvider.class);
    public static final int DEFAULF_MAX_APP_LIMIT = 32;
    protected static final String PARAM_NAME = "name";

    public boolean testProtectObject(ProtectObject po) {
        return true;
    }

    public void refreshProtectObjectProperties(List<ProtectObject> protectObjectList) {
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        ProtectGroupHelper.getInstance().loadProtectObjectStorageInfo(protectObjectList);
    }

    public void checkProtectObjectsInProtectGroup(ProtectGroup protectGroup) {
        this.checkProtectObjectNumber(protectGroup);
    }

    protected void checkProtectObjectNumber(ProtectGroup protectGroup) {
        int currentNum;
        if (!VerifyUtil.isEmpty((Collection)protectGroup.getPolist()) && (currentNum = protectGroup.getPolist().size()) > 32) {
            logger.error((Object)("protectobject is over limit.current num:" + currentNum));
            throw new LegoCheckedException(1073948163L);
        }
    }

    public void updateProtectObjectsProps(ProtectGroup protectGroup) {
    }

    public void updateProtectObjectProps(ProtectObject protectObject, Map<String, String> props) {
    }

    public void checkPolicyProps(PolicyTemplate policyTemplate) {
    }

    public Map<String, Object> pretreatmentParams(Map<String, Object> params) {
        return new HashMap<String, Object>(params);
    }

    public void encryptProperties(ProtectGroup protectGroup) {
    }

    public void decryptPropreties(ProtectGroup protectGroup) {
    }

    protected void checkPolicyTemplate(PolicyTemplate policyTemplate) {
        if (policyTemplate == null) {
            logger.error((Object)"policyTemplate is null.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        Set scheduleSet = policyTemplate.getSchedules();
        if (VerifyUtil.isEmpty((Collection)scheduleSet)) {
            logger.error((Object)"Schedule is null.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected Set<ProtectGroupReplica> getOldProtectGroupReplica(Set<ProtectGroupReplica> replicaList) {
        HashSet<ProtectGroupReplica> oldReplicas = new HashSet<ProtectGroupReplica>();
        if (VerifyUtil.isEmpty(replicaList)) {
            return oldReplicas;
        }
        try {
            for (ProtectGroupReplica oldReplica : replicaList) {
                if (ProtectGroupUtil.isLocalStorageReplica(oldReplica)) continue;
                oldReplicas.add((ProtectGroupReplica)oldReplica.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"clone replica error!", (Throwable)e);
        }
        return oldReplicas;
    }

    protected void recoveryReplicaStatus(Set<ProtectGroupReplica> oldReplicaList, Set<ProtectGroupReplica> replicaList) {
        ProtectGroupUtil.fillBackRemoteReplicasStatus(oldReplicaList, replicaList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshPolicyTemplate(ProtectGroup pg, int oldSubType) {
        int newSubType = pg.getTemplate().getSubType();
        if (newSubType != oldSubType) {
            logger.info((Object)"subType changed!old subType:%s, new subType:%s, protect name:%s", new Object[]{oldSubType, newSubType, pg.getName()});
            HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
            template.bulkUpdate("update PolicyTemplate set subType=? where uuid=?", new Object[]{newSubType, pg.getTemplate().getUuid()});
        }
        if (pg.getTemplate().getType() == 28) {
            logger.info((Object)"temple ti_policytemplate_prop protectionRelation changed! protect name:%s", new Object[]{pg.getName()});
            Session session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                String strSQL = "update ti_policytemplate_prop set PROPVALUE=:PROPVALUE where PTID in (select PTID from ti_policytemplate where uuid=:uuid) and PROPNAME='protectionRelation'";
                NativeQuery query = session.createSQLQuery(strSQL);
                session.getTransaction().begin();
                query.setString("PROPVALUE", (String)pg.getTemplate().getProps().get("protectionRelation"));
                query.setString("uuid", pg.getTemplate().getUuid());
                query.executeUpdate();
                session.getTransaction().commit();
            }
            catch (Exception e) {
                try {
                    DBOperationUtil.rollbackSession(session);
                    ExceptionUtil.rethrowException((Exception)e, (String)"refreshPolicyTemplate failed.", (long)0x300001L, null);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
            DBOperationUtil.closeSession(session);
        }
    }

    protected void reDecodeQueryParam(String key, Map<String, Object> queryParam) {
        String nameValue = (String)queryParam.get(key);
        if (!VerifyUtil.isEmpty((String)nameValue)) {
            nameValue = nameValue.trim();
            nameValue = DiscParamValidator.decodeByLength((String)nameValue);
            queryParam.put(key, nameValue);
        } else {
            queryParam.remove(key);
        }
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        return null;
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList, int replicationType) {
        return this.getSupportPolicyTemplate(protectObjectList);
    }

    public BatchOperationResult multiSetVmBlockIoHangTimeout(String cloudSn, List<VMConfigs> vmConfigsList) {
        throw new LegoCheckedException("Not supported.");
    }
}

