/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.provider;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderBaseDelegate;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractProtectObjectProviderDelegateImpl
extends BaseService
implements IProtectObjectProviderBaseDelegate {
    private static final Log logger = LogFactory.getInstance(AbstractProtectObjectProviderDelegateImpl.class);
    protected Map<Integer, IProtectObjectBaseProvider> providerList = null;

    public List<ProtectObject> getSupportProtectObjectTypes() {
        ArrayList<ProtectObject> supportPoList = new ArrayList<ProtectObject>();
        for (Map.Entry<Integer, IProtectObjectBaseProvider> entry : this.providerList.entrySet()) {
            IProtectObjectBaseProvider provider = entry.getValue();
            supportPoList.addAll(provider.getSupportProtectObjectTypes());
        }
        return supportPoList;
    }

    public void onBind(IProtectObjectBaseProvider provider, Map<?, ?> properties) {
        this.providerList.put(provider.getProviderByType(), provider);
    }

    public void onUnbind(IProtectObjectBaseProvider provider, Map<?, ?> properties) {
        this.providerList.remove(provider.getProviderByType());
    }

    public List<ProtectObject> getAvailableProtectObject(int applicationType, String poProviderSn, Map<String, Object> extendCondition) {
        IProtectObjectBaseProvider provider = this.getProviderByAppType(applicationType);
        return provider.getAvailableProtectObject(poProviderSn, extendCondition);
    }

    public IProtectObjectBaseProvider getProviderByAppType(int applicationType) {
        IProtectObjectBaseProvider provider = this.providerList.get(applicationType);
        if (provider == null) {
            String errorMsg = "connot get provider by " + applicationType;
            throw new LegoCheckedException(1073947395L, errorMsg);
        }
        return provider;
    }

    public boolean testProtectObject(int applicationType, ProtectObject po) {
        IProtectObjectBaseProvider provider = this.getProviderByAppType(applicationType);
        return provider.testProtectObject(po);
    }

    public List<ProtectObject> getAddAvailableProtectObject(int applicationType, String poProviderSn, String pgId, Map<String, Object> extParamInQueryParam) {
        IProtectObjectBaseProvider provider = this.getProviderByAppType(applicationType);
        return provider.getAddAvailableProtectObject(poProviderSn, pgId, extParamInQueryParam);
    }

    public Map<String, Object> pretreatmentParams(int applicationType, Map<String, Object> params) {
        IProtectObjectBaseProvider provider = this.getProviderByAppType(applicationType);
        return provider.pretreatmentParams(params);
    }
}

