/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.recovery.process.IRecoveryPreChecker;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RecoveryPreCheckerManager {
    private static final Log logger = LogFactory.getInstance(RecoveryPreCheckerManager.class);
    private static RecoveryPreCheckerManager instance = new RecoveryPreCheckerManager();
    private Map<String, IRecoveryPreChecker> preCheckers = new HashMap<String, IRecoveryPreChecker>();

    private RecoveryPreCheckerManager() {
    }

    public static RecoveryPreCheckerManager getInstance() {
        return instance;
    }

    public void check(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        try {
            Iterator<IRecoveryPreChecker> iterator = this.preCheckers.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().check(plan, execType);
            }
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"PreCheck failed.");
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"PreCheck failed, PreCheck results=%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1053L, (Throwable)ex);
        }
        finally {
            logger.info((Object)"PreCheck finished.");
        }
    }

    public void onBind(IRecoveryPreChecker preChecker, Map<?, ?> properties) {
        this.preCheckers.put(preChecker.getClass().getName(), preChecker);
    }

    public void onUnbind(IRecoveryPreChecker preChecker, Map<?, ?> properties) {
        this.preCheckers.remove(preChecker.getClass().getName());
    }
}

