/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.provider.DeleteProcessorByNameComparator;
import com.huawei.ism.drm.recovery.framework.provider.IComparator;
import com.huawei.ism.drm.recovery.framework.template.RecoveryProcessDefTemplateMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractBaseRecoveryProcessProvider
implements IRecoveryProcessBaseProvider {
    private static final Log logger = LogFactory.getInstance(AbstractBaseRecoveryProcessProvider.class);
    private static List<Integer> needCheckTplForRollBack = new ArrayList<Integer>();

    public RecoveryProcessDefinition getRecoveryProcess(RecoveryPlan recoveryPlan, String disasterSiteId, DrmEnumDefine.AppType appType, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, ProtectGroup protectGroup) {
        DrmEnumDefine.RecoveryTargetType recoveryTargetTypeE = DrmEnumDefine.RecoveryTargetType.getType((String)recoveryPlan.getRecoveryTargetType());
        Integer replicaType = recoveryPlan.getReplicaType();
        RecoveryProcessDefinition rpDefinition = this.createRecoveryProcess(recoveryPlan.getPlanId(), disasterSiteId, appType, execType, recoveryTargetTypeE, replicaType, protectGroup);
        if (rpDefinition == null) {
            logger.error((Object)"the rpDefinition is null");
            throw new LegoCheckedException(-1L);
        }
        this.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, false);
        Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
        for (RecoveryProcessor processor : recoveryProcessors) {
            processor.resetEnableStatus(recoveryPlan, execType);
        }
        return rpDefinition;
    }

    public Set<RecoveryProcessDefinition> getRecoveryProcesses(RecoveryPlan recoveryPlan, DrmEnumDefine.AppType appType, ProtectGroup protectGroup) {
        DrmEnumDefine.RecoveryTargetType recoveryTargetTypeE = DrmEnumDefine.RecoveryTargetType.getType((String)recoveryPlan.getRecoveryTargetType());
        Integer replicaType = recoveryPlan.getReplicaType();
        HashSet<RecoveryProcessDefinition> rpDefinitiones = new HashSet<RecoveryProcessDefinition>();
        List<DrmEnumDefine.RecoveryPlanExecuteTypeE> procTypes = this.getSuitableProcTypes(recoveryPlan);
        for (DrmEnumDefine.RecoveryPlanExecuteTypeE procType : procTypes) {
            RecoveryProcessDefinition rpDefinition = this.createRecoveryProcess(recoveryPlan.getPlanId(), null, appType, procType, recoveryTargetTypeE, replicaType, protectGroup);
            if (rpDefinition == null) {
                logger.debug((Object)"rpDefinition is null");
                continue;
            }
            this.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, false);
            Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
            for (RecoveryProcessor processor : recoveryProcessors) {
                processor.resetEnableStatus(recoveryPlan, procType);
            }
            rpDefinitiones.add(rpDefinition);
        }
        return rpDefinitiones;
    }

    protected abstract List<DrmEnumDefine.RecoveryPlanExecuteTypeE> getSuitableProcTypes(RecoveryPlan var1);

    public int getProtectionType(ProtectGroup protectGroup) {
        logger.debug((Object)"enter getProtectionType");
        return protectGroup.getTemplate().getType();
    }

    public Map<Integer, Class<? extends RecoveryProcessor>> registerSyncProcessor() {
        logger.debug((Object)"begin registerSyncProcessor");
        return new HashMap<Integer, Class<? extends RecoveryProcessor>>();
    }

    public void insertRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> afterProcCls, RecoveryProcessor recoveryProcessor, boolean isEnable, boolean isNeedUpdateDb) {
        if (recoveryProcessDef == null || recoveryProcessDef.getRecoveryProcessors().isEmpty() || afterProcCls == null || recoveryProcessor == null) {
            logger.debug((Object)"The params is null");
            return;
        }
        RecoveryProcessor indexProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, afterProcCls);
        if (indexProcessor == null) {
            return;
        }
        this.addRecoveryProcessors(recoveryProcessDef, indexProcessor, indexProcessor.getNextProcessor(), recoveryProcessor, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public void insertRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor afterProcessor, RecoveryProcessor recoveryProcessor, boolean isEnable, boolean isNeedUpdateDb) {
        if (recoveryProcessDef == null || recoveryProcessDef.getRecoveryProcessors().isEmpty() || afterProcessor == null || recoveryProcessor == null) {
            logger.debug((Object)"The params is null");
            return;
        }
        RecoveryProcessor indexProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, afterProcessor);
        if (indexProcessor == null) {
            return;
        }
        this.addRecoveryProcessors(recoveryProcessDef, indexProcessor, indexProcessor.getNextProcessor(), recoveryProcessor, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public void insertRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> afterProcCls, List<Class<? extends RecoveryProcessor>> procClsList, boolean isEnable, boolean isNeedUpdateDb) {
        if (recoveryProcessDef == null || recoveryProcessDef.getRecoveryProcessors().isEmpty()) {
            logger.debug((Object)"Param recoveryProcessDef is null");
            return;
        }
        if (afterProcCls == null || procClsList == null || procClsList.isEmpty()) {
            logger.debug((Object)"Param is null");
            return;
        }
        RecoveryProcessor indexProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, afterProcCls);
        if (indexProcessor == null) {
            return;
        }
        this.addRecoveryProcessors(recoveryProcessDef, indexProcessor, indexProcessor.getNextProcessor(), procClsList, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public void deleteRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, final String procId, boolean isNeedUpdateDb) {
        if (recoveryProcessDef == null || procId == null || procId.isEmpty()) {
            logger.debug((Object)"The param is null");
            throw new LegoCheckedException(1073947393L);
        }
        IComparator<RecoveryProcessor> comparator = new IComparator<RecoveryProcessor>(){

            @Override
            public boolean isEqual(RecoveryProcessor processor) {
                return processor != null && processor.getProcId().equals(procId);
            }
        };
        this.removeRecoveryProcessors(recoveryProcessDef, comparator, isNeedUpdateDb);
    }

    public void deleteRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, List<Class<? extends RecoveryProcessor>> procClsList, boolean isNeedUpdateDb) {
        if (recoveryProcessDef == null || procClsList == null || procClsList.isEmpty()) {
            logger.debug((Object)"Param is null");
            return;
        }
        for (Class<? extends RecoveryProcessor> rprocCls : procClsList) {
            DeleteProcessorByNameComparator comparator = new DeleteProcessorByNameComparator(rprocCls);
            this.removeRecoveryProcessors(recoveryProcessDef, comparator, isNeedUpdateDb);
        }
    }

    public void replaceRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> startProcCls, Class<? extends RecoveryProcessor> endProcCls, List<Class<? extends RecoveryProcessor>> procClsList, boolean isEnable, boolean isNeedUpdateDb) {
        if (this.isReplaceProcessorParamEmpty(recoveryProcessDef, startProcCls, endProcCls, procClsList)) {
            return;
        }
        RecoveryProcessor startProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, startProcCls);
        if (startProcessor == null) {
            logger.error((Object)"Does not find the start processor. ClassName:%s.", new Object[]{startProcCls.getName()});
            throw new LegoCheckedException(1073947394L);
        }
        RecoveryProcessor endProcessor = null;
        ArrayList<Class<? extends RecoveryProcessor>> processors = new ArrayList<Class<? extends RecoveryProcessor>>();
        RecoveryProcessor indexProcessor = startProcessor;
        do {
            processors.add(indexProcessor.getClass());
            indexProcessor = indexProcessor.getNextProcessor();
            if (indexProcessor == null || !indexProcessor.getClass().getName().equals(endProcCls.getName())) continue;
            endProcessor = indexProcessor;
            processors.add(endProcessor.getClass());
            break;
        } while (indexProcessor != null);
        this.deleteRecoveryProcessors(recoveryProcessDef, processors, isNeedUpdateDb);
        if (endProcessor == null) {
            logger.error((Object)"Invalid end processor");
            throw new LegoCheckedException(-1L);
        }
        this.addRecoveryProcessors(recoveryProcessDef, startProcessor.getPreviousProcessor(), endProcessor.getNextProcessor(), procClsList, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public boolean isSuitableProtectGroup(DrmEnumDefine.RecoveryPlanTypeE planType, ProtectGroup protectGroup) {
        Integer policyTemplateType = protectGroup.getTemplate().getType();
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.equals((Object)planType)) {
            return this.isSuitablePtTypesForLocal(policyTemplateType);
        }
        return this.isSuitablePtTypesForRemote(policyTemplateType);
    }

    protected abstract boolean isSuitablePtTypesForLocal(Integer var1);

    protected abstract boolean isSuitablePtTypesForRemote(Integer var1);

    public Map<String, Object> checkRecoveryContext(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, User operator) {
        logger.debug((Object)"return new HashMap<String, Object>()");
        return new HashMap<String, Object>();
    }

    public boolean checkIfAllowDelete(RecoveryProcessor recoveryProcessor) {
        logger.debug((Object)"enter checkIfAllowDelete");
        if (recoveryProcessor == null) {
            logger.debug((Object)"param is null");
            return true;
        }
        return recoveryProcessor.getIsPreset() == false;
    }

    public String getRecoverySiteId(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext) {
        logger.debug((Object)"return null");
        return "";
    }

    public String getRecoverySiteId(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext) {
        return "";
    }

    public void encryptProperties(RecoveryPlan recoveryPlan) {
        logger.debug((Object)"enter encryptProperties");
    }

    public void decryptPropreties(RecoveryPlan recoveryPlan) {
        logger.debug((Object)"enter decryptPropreties");
    }

    protected boolean isSameRecoveryProcess(RecoveryProcessor recoveryProcessor, List<Class<? extends RecoveryProcessor>> classes) {
        if (recoveryProcessor == null || VerifyUtil.isEmpty(classes)) {
            logger.debug((Object)"param is null");
            return false;
        }
        for (Class<? extends RecoveryProcessor> cls : classes) {
            if (!recoveryProcessor.getClass().getName().equals(cls.getName())) continue;
            return true;
        }
        return false;
    }

    protected String getDisterSiteId(String defaultSiteId, ProtectGroup pg) {
        logger.debug((Object)"enter getDisterSiteId");
        IRecoveryProcessBaseService processBaseService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        ProtectGroupReplica rep = processBaseService.getProtectGroupReplicaBySiteId(pg, defaultSiteId);
        if (rep != null) {
            return rep.getRecoverySite();
        }
        return defaultSiteId;
    }

    private void removeRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, IComparator<RecoveryProcessor> comparator, boolean isNeedUpdateDb) {
        RecoveryProcessor delProcessor = this.getDeletedRecoveryProcessor(recoveryProcessDef, comparator);
        if (delProcessor == null) {
            logger.error((Object)"The processor does not exist.");
            return;
        }
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        RecoveryProcessor preProcessor = delProcessor.getPreviousProcessor();
        RecoveryProcessor nextProcessor = delProcessor.getNextProcessor();
        if (preProcessor != null) {
            preProcessor.setNextProcessor(nextProcessor);
        }
        if (nextProcessor != null) {
            nextProcessor.setPreviousProcessor(preProcessor);
        }
        delProcessor.setPreviousProcessor(null);
        delProcessor.setNextProcessor(null);
        if (isNeedUpdateDb) {
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
            recoveryProcessService.deleteRecoveryProcessor(delProcessor);
        }
        recoveryProcessDef.getRecoveryProcessors().remove(delProcessor);
    }

    protected RecoveryProcessor getDeletedRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, IComparator<RecoveryProcessor> comparator) {
        RecoveryProcessor delProcessor = null;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (RecoveryProcessor rprocessor : recoveryProcessors) {
            if (!comparator.isEqual(rprocessor)) {
                logger.debug((Object)"The tow is not same.");
                continue;
            }
            delProcessor = rprocessor;
            break;
        }
        return delProcessor;
    }

    private RecoveryProcessor getStartRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> startProcCls) {
        RecoveryProcessor startProcessor = null;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (RecoveryProcessor recoveryProcessor : recoveryProcessors) {
            if (!recoveryProcessor.getClass().getName().equals(startProcCls.getName())) {
                logger.debug((Object)"The two not same");
                continue;
            }
            startProcessor = recoveryProcessor;
            break;
        }
        return startProcessor;
    }

    private RecoveryProcessor getStartRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor startProcessor) {
        RecoveryProcessor newStartProcessor = null;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (RecoveryProcessor recoveryProcessor : recoveryProcessors) {
            if (!recoveryProcessor.getProcId().equals(startProcessor.getProcId())) {
                logger.debug((Object)"The two not same");
                continue;
            }
            newStartProcessor = recoveryProcessor;
            break;
        }
        return newStartProcessor;
    }

    private void addRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor startProcessor, RecoveryProcessor endProcessor, RecoveryProcessor processor, boolean isEnable) {
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        recoveryProcessors.add(processor);
        processor.setProcType(recoveryProcessDef.getProcType());
        processor.setIsEnabled(Boolean.valueOf(isEnable));
        RecoveryProcessor indexStartProcessor = startProcessor;
        indexStartProcessor.setNextProcessor(processor);
        processor.setPreviousProcessor(indexStartProcessor);
        RecoveryProcessor indexEndProcessor = endProcessor;
        if (indexEndProcessor == null) {
            logger.debug((Object)"The param is null.");
            return;
        }
        processor.setNextProcessor(indexEndProcessor);
        indexEndProcessor.setPreviousProcessor(processor);
    }

    private void addRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor startProcessor, RecoveryProcessor endProcessor, List<Class<? extends RecoveryProcessor>> procClsList, boolean isEnable) {
        RecoveryProcessor indexStartProcessor = startProcessor;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (Class<? extends RecoveryProcessor> processorCls : procClsList) {
            RecoveryProcessor processor = this.createRecoveryProcessor(processorCls);
            processor.setProcName(processor.getName());
            processor.setProcType(recoveryProcessDef.getProcType());
            processor.setIsEnabled(Boolean.valueOf(isEnable));
            if (startProcessor == null) {
                indexStartProcessor = processor;
                logger.debug((Object)"The param is null");
                continue;
            }
            indexStartProcessor.setNextProcessor(processor);
            processor.setPreviousProcessor(indexStartProcessor);
            recoveryProcessors.add(processor);
            indexStartProcessor = processor;
        }
        RecoveryProcessor indexEndProcessor = endProcessor;
        if (indexEndProcessor != null) {
            indexStartProcessor.setNextProcessor(indexEndProcessor);
            indexEndProcessor.setPreviousProcessor(indexStartProcessor);
        }
    }

    private RecoveryProcessor createRecoveryProcessor(Class<? extends RecoveryProcessor> processorCls) {
        RecoveryProcessor processor = null;
        try {
            processor = processorCls.newInstance();
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Creating recovery processor failed. ClsName:" + processorCls.getName()), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return processor;
    }

    private RecoveryProcessDefinition createRecoveryProcess(String planId, String disasterSiteId, DrmEnumDefine.AppType appType, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, DrmEnumDefine.RecoveryTargetType recoveryTargetType, Integer replicaType, ProtectGroup protectGroup) {
        int protectionType = replicaType != null ? replicaType.intValue() : this.getProtectionType(protectGroup);
        RecoveryProcessDefTemplateMgr templateMgr = RecoveryProcessDefTemplateMgr.getInstance();
        Set<RecoveryProcessor> recoveryProcessors = templateMgr.createRecoveryProcessors(appType, execType, recoveryTargetType, protectionType);
        if (recoveryProcessors == null || recoveryProcessors.isEmpty()) {
            logger.debug((Object)"The param is null.");
            return null;
        }
        RecoveryProcessDefinition rpDefinition = new RecoveryProcessDefinition();
        this.initRecoveryProcessors(recoveryProcessors, planId, rpDefinition.getProcessId());
        rpDefinition.setPlanId(planId);
        rpDefinition.setDisasterSiteId(disasterSiteId);
        rpDefinition.setProcType(execType.getValue());
        rpDefinition.setAppType(appType.getValue());
        rpDefinition.setProtectionType(protectionType);
        rpDefinition.setVersion(templateMgr.getVersion(appType, execType, recoveryTargetType, protectionType));
        rpDefinition.setRecoveryProcessors(recoveryProcessors);
        return rpDefinition;
    }

    private void initRecoveryProcessors(Set<RecoveryProcessor> recoveryProcessors, String planId, String processId) {
        for (RecoveryProcessor processor : recoveryProcessors) {
            processor.setProcessId(processId);
            processor.setPlanId(planId);
            if (VerifyUtil.isEmpty((Collection)processor.getChildProc())) continue;
            logger.debug((Object)"the param is not null");
            this.initRecoveryProcessors(processor.getChildProc(), planId, processId);
        }
    }

    protected boolean isRecoveryToRemoteDisasterSite(ProtectGroupReplica pgReplica) {
        logger.debug((Object)"Enter isRecoveryToRemoteDisasterSite.");
        return DrmEnumDefine.ProtectLocation.A_C.getValue() == pgReplica.getProtectLocation() || DrmEnumDefine.ProtectLocation.B_C.getValue() == pgReplica.getProtectLocation() || DrmEnumDefine.ProtectLocation.C_C.getValue() == pgReplica.getProtectLocation();
    }

    private boolean isReplaceProcessorParamEmpty(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> startProcCls, Class<? extends RecoveryProcessor> endProcCls, List<Class<? extends RecoveryProcessor>> procClsList) {
        logger.debug((Object)"check param is null");
        return recoveryProcessDef == null || VerifyUtil.isEmpty((Collection)recoveryProcessDef.getRecoveryProcessors()) || startProcCls == null || endProcCls == null || VerifyUtil.isEmpty(procClsList);
    }

    public void checkRecoverySettings(List<RecoverySetting> recoverySettingList) {
        logger.debug((Object)"enter checkRecoverySettings");
    }

    public void setRecoveryProcessorEnableStatus(RecoveryProcessDefinition recoveryProcessDef, List<Class<? extends RecoveryProcessor>> processores, boolean isEnable) {
        if (VerifyUtil.isEmpty((Collection)recoveryProcessDef.getRecoveryProcessors())) {
            logger.debug((Object)"The param recoveryProcessDef is null");
            return;
        }
        for (RecoveryProcessor processor : recoveryProcessDef.getRecoveryProcessors()) {
            if (!this.isSameRecoveryProcess(processor, processores)) continue;
            processor.setIsEnabled(Boolean.valueOf(isEnable));
        }
    }

    public void checkIfAllowRollBack(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || CollectionUtils.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"RecoveryPlan is null or protectGroup is illegal.");
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        int policyTemplateType = protectGroup.getTemplate().getType();
        if (!needCheckTplForRollBack.contains(policyTemplateType)) {
            logger.debug((Object)"No need to check when rollback, policyTemplateType: %s", new Object[]{String.valueOf(policyTemplateType)});
            return;
        }
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        Set hyperMetroSiteSet = protectGroup.getHyperMetroSiteIdSet();
        if (policyTemplateType == 40 || policyTemplateType == 42) {
            this.checkCascadeTpl(protectGroup, hyperMetroSiteSet, disasterSiteId);
        }
        if (policyTemplateType == 41 || policyTemplateType == 43) {
            this.checkConcurrentTpl(protectGroup, hyperMetroSiteSet, disasterSiteId);
        }
    }

    private void checkCascadeTpl(ProtectGroup protectGroup, Set<String> hmSiteSet, String disasterSiteId) {
        String productSite = protectGroup.getProductSiteId();
        if (hmSiteSet.contains(productSite)) {
            return;
        }
        if (Objects.equals(protectGroup.getProductSiteId(), disasterSiteId)) {
            return;
        }
        String tmpRecoverySite = null;
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || replica.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_B.getValue()) continue;
            tmpRecoverySite = replica.getRecoverySite();
            break;
        }
        if (!VerifyUtil.isEmpty(tmpRecoverySite) && tmpRecoverySite.equals(disasterSiteId)) {
            return;
        }
        String siteName = AbstractBaseRecoveryProcessProvider.getSiteNameById(disasterSiteId);
        logger.error((Object)"DisasterSiteId: %s is not allowed to rollback when cascade mode", new Object[]{siteName});
        throw new LegoCheckedException(1073948763L, new String[]{siteName});
    }

    private void checkConcurrentTpl(ProtectGroup protectGroup, Set<String> hmSiteSet, String disasterSiteId) {
        String productSite = protectGroup.getProductSiteId();
        if (hmSiteSet.contains(productSite)) {
            return;
        }
        HashSet<String> recoverySites = new HashSet<String>();
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica)) continue;
            recoverySites.add(replica.getRecoverySite());
        }
        if (hmSiteSet.contains(disasterSiteId) && !recoverySites.contains(disasterSiteId)) {
            String siteName = AbstractBaseRecoveryProcessProvider.getSiteNameById(disasterSiteId);
            logger.error((Object)"DisasterSiteId: %s is not allowed to rollback when current mode", new Object[]{siteName});
            throw new LegoCheckedException(1073948763L, new String[]{siteName});
        }
    }

    private static String getSiteNameById(String siteId) {
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        Site srcSite = siteService.getSiteById(siteId);
        return srcSite != null ? srcSite.getName() : "";
    }

    static {
        needCheckTplForRollBack.add(40);
        needCheckTplForRollBack.add(41);
        needCheckTplForRollBack.add(42);
        needCheckTplForRollBack.add(43);
    }
}

