/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class RecoveryPlanUtil {
    public static ProtectGroup getProtectGroupFromRecovery(RecoveryPlan recoveryPlan) {
        if (VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator protectGroupIterator = recoveryPlan.getProtectGroups().iterator();
        return (ProtectGroup)protectGroupIterator.next();
    }

    public static String getProtectPlanNameFromRecovery(RecoveryPlan recoveryPlan) {
        return RecoveryPlanUtil.getProtectGroupFromRecovery(recoveryPlan).getName();
    }

    public static int getPoTypeFromRecovery(RecoveryPlan recoveryPlan) {
        return RecoveryPlanUtil.getProtectGroupFromRecovery(recoveryPlan).getPoType();
    }

    public static PolicyTemplate getPolicyTemplateFromRecovery(RecoveryPlan recoveryPlan) {
        ProtectGroup firstGroup = RecoveryPlanUtil.getProtectGroupFromRecovery(recoveryPlan);
        return firstGroup.getTemplate();
    }

    public static String[] getDeviceSnFromRecovery(RecoveryPlan recoveryPlan) {
        PolicyTemplate policyTemplate = RecoveryPlanUtil.getPolicyTemplateFromRecovery(recoveryPlan);
        Set schedules = policyTemplate.getSchedules();
        Iterator schedulesIterator = schedules.iterator();
        Schedule firstSchedule = (Schedule)schedulesIterator.next();
        String productSn = firstSchedule.getSourceSn();
        String disasterSn = firstSchedule.getTargetSn();
        return new String[]{productSn, disasterSn};
    }

    public static String[] getDeviceSiteFromRecovery(RecoveryPlan recoveryPlan) {
        PolicyTemplate policyTemplate = RecoveryPlanUtil.getPolicyTemplateFromRecovery(recoveryPlan);
        Set schedules = policyTemplate.getSchedules();
        Iterator schedulesIterator = schedules.iterator();
        Schedule firstSchedule = (Schedule)schedulesIterator.next();
        String productSite = firstSchedule.getSourceSiteId();
        String disasterSite = firstSchedule.getTargetSiteId();
        return new String[]{productSite, disasterSite};
    }
}

