/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.DeviceOperationLock;
import com.huawei.ism.cbb.discover.commons.OperationLock;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.site.sdk.service.ISiteCheckService;
import com.huawei.ism.drm.site.service.impl.BatchResultUtil;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

public abstract class AbstractSiteService
extends IsmBaseService
implements ISiteBaseService {
    private static final Log logger = LogFactory.getInstance(AbstractSiteService.class);
    private static final long USER_ADMIN = 1L;
    protected List<ISiteCheckService> siteCheckServices = new ArrayList<ISiteCheckService>();

    protected void grandSiteScope(Long userId, String siteId) {
        if (userId == null) {
            ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).addObject(Long.valueOf(1L), new String[]{siteId});
        } else {
            ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).addObject(userId, new String[]{siteId});
        }
    }

    protected void isExceedMaxSiteNum(int siteType) {
        long count = CommonDAOLocator.getBaseDao().getTotalCount("select count(*) from Site as site where site.siteType = ?", new Object[]{siteType});
        if (32L <= count) {
            logger.error((Object)"current site num:%s.", new Object[]{String.valueOf(count)});
            throw new LegoCheckedException(1073947658L);
        }
    }

    protected void validateSiteName(String name) {
        if (!CommUtil.checkDrmNameParam((String)name)) {
            logger.error((Object)"name is illegal: %s", new Object[]{name});
            throw new LegoCheckedException(1073947393L);
        }
        if (this.isSiteExist(name)) {
            logger.error((Object)"name is repeated,name :%s ", new Object[]{name});
            throw new LegoCheckedException(1073947392L);
        }
    }

    protected void validateSiteDesc(String desc) {
        if (!CommUtil.checkDrmDescParam((String)desc)) {
            logger.error((Object)"desc is illegal,desc:%s ", new Object[]{desc});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void deleteSite(String siteId) {
        Site site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        if (site == null) {
            throw new LegoCheckedException(201L);
        }
        OperationLock opLock = DeviceOperationLock.getLock((String)siteId);
        if (!opLock.tryLock()) {
            logger.warn((Object)"Someone[%s] has locked site, siteId=%s.", new Object[]{opLock.getOwnerName(), siteId});
            throw new LegoCheckedException(102401L);
        }
        logger.info((Object)"Get site operation lock ... siteId=%s", new Object[]{siteId});
        try {
            this.checkSiteCanDelete(site);
            this.deleteSiteFromDB(site);
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"delete site set error, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                opLock.unTryLock();
                logger.info((Object)"Release site operation lock ... siteId=%s", new Object[]{siteId});
                throw throwable;
            }
        }
        opLock.unTryLock();
        logger.info((Object)"Release site operation lock ... siteId=%s", new Object[]{siteId});
    }

    protected abstract void deleteSiteFromDB(Site var1);

    protected Site getSite(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)"siteId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = null;
        try {
            site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("unable to get site:" + siteId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return site;
    }

    private Site getSite(String siteId, String spiltLabel) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)"siteId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = null;
        ArrayList<String> siteIdSet = new ArrayList<String>();
        if (!VerifyUtil.isEmpty((String)spiltLabel)) {
            String[] sites = siteId.split(spiltLabel);
            if (sites.length >= 2) {
                for (String siteid : sites) {
                    siteIdSet.add(siteid);
                }
                site = this.getCombainSite(siteIdSet, spiltLabel);
            } else {
                site = this.getSite(siteId);
            }
            return site;
        }
        try {
            site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("unable to get site:" + siteId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return site;
    }

    private Site getCombainSite(List<String> siteIdSet, String spiltLabel) {
        Site site = null;
        StringBuffer name = new StringBuffer();
        for (String siteId : siteIdSet) {
            if (name.length() > 0) {
                name.append(spiltLabel);
            }
            if ((site = this.getSite(siteId)) == null) continue;
            name.append(site.getName());
        }
        if (null != site) {
            site.setName(name.toString());
        }
        return site;
    }

    protected boolean isSiteExist(String name) {
        try {
            List siteList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from Site as st where st.name = ? and st.siteType = ?", new Object[]{name, 0});
            return !VerifyUtil.isEmpty((Collection)siteList);
        }
        catch (DataAccessException e) {
            logger.error((Object)("failed to get siteList:" + name), (Throwable)e, 90160758786876L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public Site getSiteById(String siteId, Long userId) {
        logger.debug((Object)"siteId=%s", new Object[]{siteId});
        Site site = this.getSite(siteId);
        if (site == null) {
            return null;
        }
        List filterSites = new ArrayList<Site>(1);
        filterSites.add(site);
        filterSites = ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, filterSites);
        if (VerifyUtil.isEmpty(filterSites)) {
            return null;
        }
        return (Site)filterSites.get(0);
    }

    public Site getSiteById(String siteId) {
        logger.debug((Object)"siteId=%s", new Object[]{siteId});
        Site site = this.getSite(siteId);
        return site;
    }

    public Site getCombinaSiteById(String siteId, String spiltLabel) {
        Site site = this.getSite(siteId, spiltLabel);
        return site;
    }

    public BatchOperationResult checkResourceUsed(Long userId, List<Long> moIds) {
        logger.debug((Object)"moids=%s", new Object[]{moIds});
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        if (moIds == null || moIds.isEmpty()) {
            return batchOperationResult;
        }
        batchOperationResult.setTotalCount(moIds.size());
        BatchResultUtil.setBatchResult(batchOperationResult, moIds, userId);
        return batchOperationResult;
    }

    public void onBind(ISiteCheckService checkService, Map<?, ?> properties) {
        logger.debug((Object)"onBind");
        if (checkService != null) {
            this.siteCheckServices.add(checkService);
        }
    }

    public void onUnbind(ISiteCheckService checkService, Map<?, ?> properties) {
        logger.debug((Object)"onUnbind");
        if (checkService != null) {
            this.siteCheckServices.remove(checkService);
        }
    }

    public List<Site> getAllLocalSites() {
        logger.debug((Object)"getAllLocalSites");
        String hql = "from Site as st where st.siteType = 0 order by st.name asc";
        return this.executeQuery(hql);
    }

    private List<Site> getAllSites() {
        logger.debug((Object)"getAllSites");
        String hql = "from Site as st order by st.name asc";
        return this.executeQuery(hql);
    }

    public List<Site> getAllSites(Long userId) {
        logger.debug((Object)"getAllSites");
        List<Site> siteList = this.getAllSites();
        if (VerifyUtil.isEmpty(siteList)) {
            return new ArrayList<Site>(0);
        }
        return ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, siteList);
    }

    private List<Site> executeQuery(String hql) {
        try {
            return CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[0]);
        }
        catch (DataAccessException ex) {
            logger.error((Object)"unable to get sites", (Throwable)ex, 90160758786873L);
            return new ArrayList<Site>();
        }
    }

    public List<? extends DrResource> getAllResourceBySite(String siteId, String resType) {
        logger.debug((Object)"siteId=%s, resType=%s", new Object[]{siteId, resType});
        if (siteId == null) {
            return new ArrayList();
        }
        return SiteResourceServiceProxy.getInstance().getSiteResourceService(resType).getDrResourceBySite(siteId);
    }

    public List<Site> getSites(String serverUuid) {
        if (VerifyUtil.isEmpty((String)serverUuid)) {
            logger.error((Object)"serverUuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        List<Site> sites = null;
        try {
            List find = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from Site where serverUuid = ? order by name asc", (Object[])new String[]{serverUuid});
            sites = Arrays.asList(find.toArray(new Site[find.size()]));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Query site fail, serverUuid=" + serverUuid), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return sites;
    }

    public Site getSiteByDeviceSn(String devSn) {
        String hql = "from DrResource where deviceSn=?";
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        List resourceList = baseDao.getHibernateTemplate().find(hql, new Object[]{devSn});
        if (resourceList == null || resourceList.isEmpty()) {
            logger.error((Object)"DrResource is null, sn=%s", new Object[]{devSn});
            throw new LegoCheckedException(2117645L);
        }
        DrResource drResource = (DrResource)resourceList.get(0);
        Site site = this.getSiteById(drResource.getSiteId());
        if (site == null) {
            logger.error((Object)"Site is null, siteId=%s", new Object[]{drResource.getSiteId()});
            throw new LegoCheckedException(2117645L);
        }
        return site;
    }

    protected Boolean isDistinctParam(Object param1, Object param2) {
        return param1 != null && !param1.equals(param2);
    }
}

