/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.processor;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.system.cfgdata.AlarmGenerator;
import com.huawei.ism.drm.system.cfgdata.ConfigDataCommon;
import com.huawei.ism.drm.system.cfgdata.DrvSshPara;
import com.huawei.ism.drm.system.cfgdata.SshdUtil;
import com.huawei.ism.drm.system.cfgdata.database.GuassDBdumpImpl;
import com.huawei.ism.drm.system.cfgdata.sdk.model.FtpServerInfo;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.File;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ConfigDataAutoBackupTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(ConfigDataAutoBackupTask.class);
    private FtpServerInfo ftpServerInfo = null;
    private SshdUtil sftp = null;

    public ConfigDataAutoBackupTask(FtpServerInfo ftpInfo, BackTask backTask) {
        super(ftpInfo.getFtpServerId(), backTask, true);
        this.ftpServerInfo = ftpInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        logger.info((Object)"Start to excute ConfigDataAutoBackupTask.");
        File file = null;
        try {
            String encryptPwd;
            this.sftp = new SshdUtil();
            String hostKey = SshdUtil.getFtpHostKey(this.ftpServerInfo.getIp(), this.ftpServerInfo.getPort());
            String oldHostKey = WccEncryptor.decrypt((String)this.ftpServerInfo.getHostKey());
            if (VerifyUtil.isEmpty((String)oldHostKey) || !oldHostKey.equals(hostKey)) {
                logger.error((Object)"SFTP server hostKey is changed.");
                this.sendUploadConfigdataFailAlarm();
                throw new LegoCheckedException(-1L);
            }
            DrvSshPara para = new DrvSshPara(this.ftpServerInfo);
            if (!this.sftp.login(para)) {
                logger.error((Object)"Failed to login ftp server: %s", new Object[]{para.getIp()});
                this.sendUploadConfigdataFailAlarm();
                throw new LegoCheckedException(-1L);
            }
            if (!this.processStoredConfigDataMaxDayLimit(this.ftpServerInfo.getMaxStoredDay())) {
                logger.error((Object)"Failed to process old config data file. ip: %s", new Object[]{para.getIp()});
            }
            if ((file = this.excuteGaussDbBackup(encryptPwd = WccEncryptor.decrypt((String)this.ftpServerInfo.getDataPassword()))) == null) {
                this.sendUploadConfigdataFailAlarm();
                throw new LegoCheckedException(-1L);
            }
            if (!this.processBackupFile(file)) {
                this.sendUploadConfigdataFailAlarm();
                throw new LegoCheckedException(-1L);
            }
            this.restoreUploadConfigdataFailAlarm();
            this.sftp.logout();
            this.closeConfigDataFile(file);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"auto backup task of config data failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            this.sftp.logout();
            this.closeConfigDataFile(file);
        }
    }

    protected void resetBackTaskAfterSuccess() {
        String uploadDir = this.generateUploadDirectoryName() + "ConfigData.zip";
        this.getBackTask().setTaskLink(uploadDir);
    }

    private void closeConfigDataFile(File file) {
        if (file != null) {
            try {
                if (!file.delete()) {
                    logger.error((Object)"Failed to delete file:%s ", new Object[]{file.getName()});
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to delete file: %s, error: %s", new Object[]{file.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    private File excuteGaussDbBackup(String encryptPwd) {
        try {
            return new GuassDBdumpImpl().backup(encryptPwd, false);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to excute backup command of mysql. ");
            return null;
        }
    }

    private boolean processBackupFile(File file) {
        String uploadDir = this.generateUploadDirectoryName();
        if (!this.sftp.createDirectory(uploadDir)) {
            logger.error((Object)"Failed to create directory");
            return false;
        }
        if (!this.sftp.upLoadFile(file, uploadDir, "ConfigData.zip")) {
            logger.error((Object)"Failed to upload file to ftp server: %s", new Object[]{file.getName()});
            return false;
        }
        return true;
    }

    private void sendUploadConfigdataFailAlarm() {
        TopoObject manageSystemMo = ConfigDataCommon.getManagementSystemMO();
        if (VerifyUtil.isEmpty((Object)manageSystemMo)) {
            logger.error((Object)"Failed to get mangement system mo.");
            return;
        }
        AlarmGenerator.generateUploadConfigDataFailAlarm(manageSystemMo, this.getSystemIP(), manageSystemMo.getUuid());
    }

    private void restoreUploadConfigdataFailAlarm() {
        TopoObject manageSystemMo = ConfigDataCommon.getManagementSystemMO();
        if (VerifyUtil.isEmpty((Object)manageSystemMo)) {
            logger.error((Object)"Failed to get mangement system mo.");
            return;
        }
        AlarmGenerator.restoreUploadConfigDataFailAlarm(manageSystemMo, this.getSystemIP());
    }

    private String getCurrentDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(new Date());
    }

    private String getSystemIPAndSN() {
        return this.getSystemIP();
    }

    private String generateUploadDirectoryName() {
        String uploadDir = this.ftpServerInfo.getBaseDir() + this.getSystemIPAndSN() + "/" + this.getCurrentDate() + "/Auto/";
        return uploadDir;
    }

    private String getSystemIP() {
        return new LegoMoGenerator().getInstallServerIp();
    }

    public boolean processStoredConfigDataMaxDayLimit(int maxDay) {
        Date currentDate = new Date();
        String dir = this.ftpServerInfo.getBaseDir() + this.getSystemIP();
        try {
            List<Path> dirVec = this.sftp.getChildDirectory(dir);
            for (Path entry : dirVec) {
                Date dirDate;
                Path fileName = entry.getFileName();
                if (fileName == null) continue;
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    dirDate = sdf.parse(fileName.toString());
                }
                catch (ParseException e) {
                    continue;
                }
                if (ConfigDataCommon.daysBetween(currentDate, dirDate) < maxDay) continue;
                this.sftp.deleteDirectory(dir, fileName.toString());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ProcessStoredConfigDataMaxDayLimit exception,errorMsg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            return false;
        }
        return true;
    }
}

