/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.task;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ScanDatabaseLargeTableTask
extends TimerTask {
    private static final Log LOGGER = LogFactory.getInstance(ScanDatabaseLargeTableTask.class);
    private static final String MAX_TABLE_ROW_SIZE_KEY = "max.table.row.size";
    private static final ScanDatabaseLargeTableTask TASK = new ScanDatabaseLargeTableTask();
    private static final long DEFAULT_MAX_TABLE_ROW_SIZE = 300000L;
    private static final String MONITOR_TABLES = "monitor.tables";
    private static final String QUERY_ALL_TABLES_SQL = "select RELNAME from PG_STAT_USER_TABLES";
    private static final Set<String> ALL_TABLES = new HashSet<String>();

    private ScanDatabaseLargeTableTask() {
    }

    public static ScanDatabaseLargeTableTask getInstance() {
        return TASK;
    }

    @Override
    public void run() {
        LOGGER.info((Object)"Start scanning large database tables.");
        try {
            long maxRows = LegoBaseConfig.getInstance().getNumber(MAX_TABLE_ROW_SIZE_KEY, 300000L);
            if (maxRows <= 0L) {
                LOGGER.error((Object)String.format(Locale.ROOT, "The MAX_TABLE_ROW_SIZE configuration is incorrect, MAX_TABLE_ROW_SIZE is %s", maxRows));
                return;
            }
            String[] monitorTables = LegoBaseConfig.getInstance().getKeyValue(MONITOR_TABLES, "").split(",");
            if (monitorTables.length == 0 || !this.monitorTableIsValid(monitorTables)) {
                LOGGER.error((Object)"The MONITOR_TABLES configuration is incorrect");
                return;
            }
            String sql = this.combineSql(maxRows, monitorTables);
            if (this.queryScanResult(sql) == 0L) {
                LOGGER.info((Object)"No database table is too large.");
                AlarmReporter.restoreAlarm(52625524L, String.valueOf(maxRows));
                return;
            }
            AlarmReporter.sendAlarm(52625524L, null, FaultEnum.AlarmResourceType.UNDEFINED.getValue(), FaultEnum.AlarmSeverity.MAJOR, String.valueOf(maxRows));
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Scan database large table task run failed, error msg=", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private void queryAllTables(String sql) {
        Session session = null;
        try {
            HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(sql);
            ALL_TABLES.clear();
            ALL_TABLES.addAll(query.list());
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"Execute all tables failed, message=%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException("Execute all tables failed!");
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
    }

    private long queryScanResult(String sql) {
        long l;
        Session session = null;
        try {
            HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(sql);
            l = Long.valueOf(query.getSingleResult().toString());
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"Execute scan result failed, message=%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException("Execute scan result failed!");
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return l;
    }

    private String combineSql(long maxRows, String[] monitorTables) {
        StringBuffer sql = new StringBuffer("select count(1) from (");
        sql.append(Arrays.stream(monitorTables).map(table -> "SELECT count(1) FROM " + table).collect(Collectors.joining(" UNION ALL ")));
        sql.append(") t where count > ");
        sql.append(maxRows);
        return sql.toString();
    }

    private boolean monitorTableIsValid(String[] monitorTables) {
        this.queryAllTables(QUERY_ALL_TABLES_SQL);
        if (monitorTables.length > ALL_TABLES.size()) {
            return false;
        }
        for (String monitorTable : monitorTables) {
            if (ALL_TABLES.contains(monitorTable)) continue;
            return false;
        }
        return true;
    }
}

