/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.thirdservice.impl;

import com.huawei.ism.drm.cert.checker.HttpsConnectChecker;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CertSwitch;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICertConfigService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import java.util.List;

@Service(name="com.huawei.ism.drm.system.thirdservice.sdk.service.ICertConfigService", desc="", interfaceClass=ICertConfigService.class)
public class CertConfigServiceImpl
extends BaseService
implements ICertConfigService {
    private static final Log LOGGER = LogFactory.getInstance(CertConfigServiceImpl.class);

    public CertSwitch getCertSwitch() {
        boolean certAuthSwitch = LegoBaseConfig.getInstance().getBoolean("cert.auth.switch", Boolean.FALSE);
        CertSwitch certSwitch = new CertSwitch();
        certSwitch.setCertAuthSwitch(Boolean.valueOf(certAuthSwitch));
        return certSwitch;
    }

    public void modifyCertSwitch(CertSwitch certSwitch) {
        if (certSwitch == null || certSwitch.getCertAuthSwitch() == null) {
            LOGGER.error((Object)"ModifyCertSwitch failed, cause param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        LegoBaseConfig.getInstance().setConfigValue("cert.auth.switch", certSwitch.getCertAuthSwitch().toString());
    }

    public List<String> getConnectFailedServices() {
        HttpsConnectChecker httpsConnectChecker = (HttpsConnectChecker)ServiceLocator.getInstance().getService(HttpsConnectChecker.class);
        try {
            return httpsConnectChecker.getConnectFailedServices(Boolean.TRUE);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to getConnectFailedServices, msg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L);
        }
    }
}

