/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.thirdservice.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AddressUtils;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.coreenum.SyslogEncryptionModeEnum;
import com.huawei.ism.drm.system.thirdservice.sdk.model.LogNotifyServer;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ILogNotifierService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.syslog.proxy.OperateLogProxy;
import com.huawei.lego.core.system.syslog.service.IOperatelogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.system.thirdservice.sdk.service.ILogNotifierService", desc="", interfaceClass=ILogNotifierService.class)
public class LogNotifierService
extends BaseService
implements ILogNotifierService {
    private static final Log logger = LogFactory.getInstance(LogNotifierService.class);
    private OperateLogProxy optLogProxy = OperateLogProxy.getInstance();

    public List<LogNotifyServer> getNotifyServerListBy(String logType) {
        Session session;
        List serverList;
        ArrayList<LogNotifyServer> result;
        block5: {
            List list;
            result = new ArrayList<LogNotifyServer>();
            serverList = null;
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                Criteria crit = session.createCriteria(LogNotifyServer.class);
                serverList = crit.list();
                if (!VerifyUtil.isEmpty((String)logType) && !"all".equalsIgnoreCase(logType) && !VerifyUtil.isEmpty((Collection)serverList)) break block5;
                this.addDefaultEncrptyMode(serverList);
                list = serverList;
            }
            catch (DataAccessException ex) {
                try {
                    logger.error((Object)"Failed to query domainInfo,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                    throw ex;
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
            }
            DBOperationUtil.closeSession(session);
            return list;
        }
        DBOperationUtil.closeSession(session);
        for (LogNotifyServer one : serverList) {
            if (!one.getLogType().equalsIgnoreCase(logType)) continue;
            result.add(one);
            break;
        }
        this.addDefaultEncrptyMode(result);
        return result;
    }

    public void saveOrUpdateNofityServer(LogNotifyServer server) {
        String protocalType;
        JSONObject props = JSONObject.fromObject((Object)server.getProtocalProps());
        String encrytionMode = null;
        if (props.containsKey((Object)"encryptionMode")) {
            encrytionMode = props.getString("encryptionMode");
        }
        if (!"CTS".equalsIgnoreCase(protocalType = server.getProtocalType()) ? !SyslogEncryptionModeEnum.checkMode((String)encrytionMode) : !VerifyUtil.isEmpty((String)encrytionMode)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (server.getIsEnabled()) {
            String ip = props.getString("ip");
            AddressUtils.checkInnerNetworkDetection(ip);
            String port = props.getString("port");
            this.checkLogSeverConnection(ip, port, encrytionMode, server.getLogType());
        } else {
            server.setProtocalProps("");
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)server);
        this.refreshLogClient(server.getLogType());
        if (!server.getIsEnabled()) {
            AlarmReporter.restoreAlarm(52625474L, server.getLogType());
        }
    }

    private void refreshLogClient(String logType) {
        IOperatelogService logService = this.optLogProxy.getLogReportService(logType);
        if (VerifyUtil.isEmpty((Object)logService)) {
            logger.error((Object)"get log service failed , log type is %s.", new Object[]{logType});
            throw new LegoCheckedException(1073947395L);
        }
        logService.refactorServiceConfig();
    }

    private void checkLogSeverConnection(String ip, String port, String encrytionMode, String logType) {
        IOperatelogService logService = this.optLogProxy.getLogReportService(logType);
        if (VerifyUtil.isEmpty((Object)logService)) {
            logger.error((Object)"get log service failed , log type is %s.", new Object[]{logType});
            throw new LegoCheckedException(1073947395L);
        }
        logService.checkConnection(ip, port, encrytionMode);
    }

    private void addDefaultEncrptyMode(List<LogNotifyServer> list) {
        if (!VerifyUtil.isEmpty(list)) {
            for (LogNotifyServer one : list) {
                JSONObject props = JSONObject.fromObject((Object)one.getProtocalProps());
                if ("CTS".equalsIgnoreCase(one.getProtocalType()) || props.containsKey((Object)"encryptionMode")) continue;
                props.put((Object)"encryptionMode", (Object)SyslogEncryptionModeEnum.TCP.name());
                one.setProtocalProps(props.toString());
            }
        }
    }
}

