/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.model.site;

import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.topo.model.IMultiView;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.twaver.Node;

public class SiteNode
implements IMultiView {
    public static final String IMAGE_PATH = "/theme/recoverydirector/images/topo/site.png";
    private static final String TOPO_MODEL = "SiteNode";
    private static final String GROUP_LAYOUT = "leftright";
    private static final int GROUP_LOCAL_OUTLINE_CORLOR = 0xDCDCDC;
    private static final int GROUP_LOCAL_OUTLINE_WIDTH = 1;
    private static final int GROUP_LOCAL_FILL_COLOR = 0xFAFAFA;
    private static final int GROUP_REMOTE_OUTLINE_CORLOR = 0xDCDCDC;
    private static final int GROUP_REMOTE_OUTLINE_WIDTH = 1;
    private static final int GROUP_REMOTE_FILL_COLOR = 0xFAFAFA;
    private static final String GROUP_SHAPE = "roundrect";
    private static final double INNER_TOP_GAP = 20.0;
    private static final double INNER_LEFT_GAP = 28.0;
    private static final double INNER_SONS_GAP = 50.0;
    private static final double LABEL_YOFFSET = 15.0;
    private static final int VECTOR_FONT_COLOR = 0x222222;
    private String label;
    private Site site = null;
    private Node group = null;
    private ITopoResourceManager resourceManager;

    public SiteNode(Site site, ITopoResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.setSite(site);
        this.initNode();
    }

    public SiteNode(ITopoResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    private void initNode() {
        this.group = new Node((Object)this.site.getSiteId());
        if (!TopoServiceUtil.isNullStr(this.site.getSiteAlias())) {
            this.group.setName(this.site.getSiteAlias() + "(" + this.site.getSiteAlias() + ")");
        } else {
            this.group.setName(this.site.getName());
        }
        this.group.setName(TopoServiceUtil.getNodeShowName(this.group.getName()));
        this.group.setToolTip(this.createSiteTooltip(this.site));
        this.group.setStyle("label.bold", false);
        this.group.setStyle("label.font", (Object)this.resourceManager.getText("ism.drm.topo.label.font"));
        this.group.setClient("layout", (Object)GROUP_LAYOUT);
        this.group.setClient("TopoModel", (Object)TOPO_MODEL);
        this.group.setClient("leftGap", 28.0);
        this.group.setClient("topGap", 20.0);
        this.group.setClient("sonsGap", 50.0);
        this.group.setStyle("content.type", (Object)"vector");
        this.group.setStyle("vector.shape", (Object)GROUP_SHAPE);
        this.group.setStyle("vector.roundrect.radius", 12);
        this.group.setStyle("label.color", 0x222222);
        this.group.setStyle("label.yoffset", 15.0);
        this.group.setStyle("label.size", 14.0);
        this.group.setStyle("select.alpha", 1.0);
        this.group.setStyle("select.style", (Object)"none");
    }

    public Node getNode() {
        return this.group;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Node getLocalView() {
        this.group.setStyle("vector.fill.color", 0xFAFAFA);
        this.group.setStyle("vector.outline.width", 1);
        this.group.setStyle("vector.outline.color", 0xDCDCDC);
        this.group.setName(this.group.getName());
        return this.group;
    }

    public Node getSnapView() {
        this.group.setStyle("vector.fill.color", 0xFAFAFA);
        this.group.setStyle("vector.outline.width", 1);
        this.group.setStyle("vector.outline.color", 0xDCDCDC);
        return this.group;
    }

    public Node getRemoteView() {
        this.group.setStyle("vector.fill.color", 0xFAFAFA);
        this.group.setStyle("vector.outline.width", 1);
        this.group.setStyle("vector.outline.color", 0xDCDCDC);
        if (0 == this.site.getSiteType()) {
            this.group.setName(this.group.getName());
        }
        return this.group;
    }

    public String createSiteTooltip(Site siteData) {
        StringBuilder tooltipBuilder = new StringBuilder();
        if (siteData == null) {
            return tooltipBuilder.toString();
        }
        if (!TopoServiceUtil.isNullStr(siteData.getName())) {
            tooltipBuilder.append(this.resourceManager.getText("ism.drm.topo.site.name") + " " + StringEscapeUtil.escape((String)siteData.getName()) + "\n");
        } else {
            tooltipBuilder.append(this.resourceManager.getText("ism.drm.topo.site.name") + " " + "--" + "\n");
        }
        if (!TopoServiceUtil.isNullStr(siteData.getDescription())) {
            tooltipBuilder.append(this.resourceManager.getText("ism.drm.topo.site.des") + " " + StringEscapeUtil.escape((String)siteData.getDescription()) + "\n");
        } else {
            tooltipBuilder.append(this.resourceManager.getText("ism.drm.topo.site.des") + " " + "--" + "\n");
        }
        return tooltipBuilder.toString();
    }

    public void setSite(Site site) {
        this.site = site;
    }

    public Site getSite() {
        return this.site;
    }
}

