/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.skin;

import com.huawei.ism.drm.topo.sdk.twaver.RGB;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.twaver.IElement;

public class Theme
extends Skin {
    public static final int MASK = 0xFFFFFF;
    public static final int MIN_ALPHA = 0;
    public static final int MAX_ALPHA = 100;
    public static final double DEFAULT_RATIO = 0.85;
    public static final Theme GRAY = new Theme(1, 0xDCDCDC, 1, 0xFAFAFA);
    public static final Theme BLUE = new Theme(1, 0xDCDCDC, 1, 0xFCFCFC);
    public static final Theme BLUE100 = new Theme(0, 0xDCDCDC, 0, 0xFCFCFC);
    private int width;
    private int color;
    private int alpha;
    private int fill;
    private double ratio = 0.85;

    public Theme() {
        this(1, 0, 100);
    }

    public Theme(int width) {
        this(width, 0, 100);
    }

    public Theme(int width, int color) {
        this(width, color, 100);
    }

    public Theme(int width, int color, int alpha) {
        this(width, color, alpha, 0.85);
    }

    public Theme(int width, int color, int alpha, double ratio) {
        this.setWidth(width);
        this.setColor(color);
        this.setAlpha(alpha);
        this.setRatio(ratio);
    }

    public Theme(int width, int color, int alpha, int fill) {
        this.setWidth(width);
        this.setColor(color);
        this.setAlpha(alpha);
        this.setFill(fill);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color & 0xFFFFFF;
    }

    public void setAlpha(int alpha) {
        this.alpha = Math.min(Math.max(alpha, 0), 100);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setFill(int fill) {
        int a = this.color & 0xFF;
        int b = fill & 0xFF;
        if (a >= b) {
            this.fill = this.color;
            this.ratio = 0.0;
        } else {
            this.setRatio((double)(b - a) / (double)(255 - a));
        }
    }

    public int getFill() {
        return this.fill;
    }

    public void setRatio(double ratio) {
        this.ratio = Math.min(Math.max(ratio, 0.0), 1.0);
        this.fill = new RGB(this.color).light(ratio).color();
    }

    public double getRatio() {
        return this.ratio;
    }

    public void apply(IElement element) {
        element.setStyle("vector.outline.width", (Object)this.width);
        element.setStyle("vector.outline.color", (Object)this.color);
        element.setStyle("vector.outline.alpha", (Object)this.alpha);
        element.setStyle("vector.fill.color", (Object)this.fill);
        element.setStyle("select.alpha", (Object)1.0);
        element.setStyle("select.style", (Object)"none");
    }
}

