/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc;

import com.huawei.ism.drm.cert.sdk.service.command.CommandReaction;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import com.huawei.nodeagent.thrift.PathGlob;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class WccSyncHandler
implements SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(WccSyncHandler.class);
    private static final WccSyncHandler INSTANCE = new WccSyncHandler();
    private static final long INTERVAL = TimeUnit.SECONDS.toMillis(5L);
    private CompletableFuture<NodeAgentLocalService.Iface> clientCompletableFuture = new CompletableFuture();
    private NodeAgentLocalService.Iface client;
    private final Object lock = new Object();
    private ConcurrentLinkedDeque<Long> deque = new ConcurrentLinkedDeque();

    private WccSyncHandler() {
    }

    public static WccSyncHandler getInstance() {
        return INSTANCE;
    }

    public NodeAgentLocalService.Iface getClient() {
        return this.client;
    }

    public void setClient(NodeAgentLocalService.Iface client) {
        this.client = client;
    }

    private void initialize() {
        this.clientCompletableFuture.complete(this.client);
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        logger.info((Object)"prepare to sync wcc config");
        Object object = this.lock;
        synchronized (object) {
            boolean submit;
            long currentTriggerTime = System.currentTimeMillis() + INTERVAL;
            if (!this.deque.isEmpty()) {
                long last = this.deque.getLast();
                if (currentTriggerTime - last < INTERVAL) {
                    this.deque.removeLast();
                    submit = false;
                    logger.info((Object)"sync task already submitted");
                } else {
                    submit = true;
                }
            } else {
                submit = true;
            }
            this.deque.add(currentTriggerTime);
            if (submit) {
                logger.info((Object)"begin submit sync task");
                ExecutionService.submit(this::handle);
                logger.info((Object)"end submit sync task");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await() {
        while (true) {
            this.sleep();
            Object object = this.lock;
            synchronized (object) {
                if (this.deque.isEmpty()) {
                    logger.info((Object)"it may be handled");
                    return false;
                }
                long deadline = this.deque.getFirst();
                if (System.currentTimeMillis() < deadline) {
                    continue;
                }
                this.deque.poll();
                logger.info((Object)"time up: %s", new Object[]{Long.toString(deadline)});
                if (this.deque.isEmpty() || System.currentTimeMillis() < this.deque.getFirst()) {
                    break;
                }
            }
        }
        return true;
    }

    private void handle() {
        NodeAgentLocalService.Iface service;
        try {
            service = this.clientCompletableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error((Object)"get node agent client failed", (Throwable)e);
            return;
        }
        if (!this.await()) {
            return;
        }
        PathGlob pathGlob = new PathGlob("LegoRuntime/conf/wcc/crypt");
        boolean transmit = true;
        AtomicLong count = new AtomicLong();
        while (transmit) {
            boolean failed;
            logger.info((Object)"begin async transmit");
            CommandReaction commandReaction = CommandReaction.get(() -> service.asyncTransmit(pathGlob, null), (boolean)false, (long)-1L);
            boolean bl = failed = commandReaction == null || commandReaction.failed();
            if (!failed) {
                boolean success = Boolean.TRUE.equals(commandReaction.getResult());
                logger.info((Object)"submit async transmit task %s", new Object[]{success ? "success" : "failed"});
                break;
            }
            logger.error((Object)"async transmit failed");
            transmit = this.deque.isEmpty();
            if (!transmit) continue;
            if (count.incrementAndGet() > 1000L) {
                logger.error((Object)"async transmit timeout");
                break;
            }
            this.sleep();
        }
    }

    private void sleep() {
        CommonUtil.sleep((long)INTERVAL);
    }
}

