/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.detect.resolvers;

import com.huawei.ism.drm.detect.EventRelatedResourceResolver;
import com.huawei.ism.drm.detect.ResourceDetectedEvent;
import com.huawei.ism.drm.storage.hvs.detect.converter.HvsStorageAlterationResourceConverter;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceEvent;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class HvsStorageAlterationRelatedResourceResolver
implements EventRelatedResourceResolver<DrStorage, HvsDeviceEvent> {
    private final String objectType;
    private final List<String> eventIdList;
    private final int index;
    private final HvsStorageAlterationResourceConverter converter;

    public HvsStorageAlterationRelatedResourceResolver(String objectType, List<String> eventIdList, int index, HvsStorageAlterationResourceConverter converter) {
        this.objectType = Objects.requireNonNull(objectType);
        this.eventIdList = Objects.requireNonNull(eventIdList);
        this.index = index;
        this.converter = Objects.requireNonNull(converter);
    }

    public boolean check(ResourceDetectedEvent<DrStorage, HvsDeviceEvent> event) {
        HvsDeviceEvent hvsDeviceEvent = (HvsDeviceEvent)event.getData();
        return this.objectType.equals(hvsDeviceEvent.getAlarmObjType()) && this.eventIdList.contains(hvsDeviceEvent.getStrEventID());
    }

    public Object resolve(ResourceDetectedEvent<DrStorage, HvsDeviceEvent> event) {
        HvsDeviceEvent hvsDeviceEvent = (HvsDeviceEvent)event.getData();
        String param = Optional.ofNullable(hvsDeviceEvent.getEventParam()).orElseThrow(() -> new LegoCheckedException(1073947393L));
        String[] items = param.split(",");
        if (items.length > this.index) {
            DrStorage storage = (DrStorage)event.getResource();
            String deviceSn = storage.getDeviceSn();
            String id = this.resolveParameter(items[this.index]);
            return this.converter.convert(deviceSn, id);
        }
        throw new LegoCheckedException(1073947393L);
    }

    protected String resolveParameter(String parameter) {
        return parameter.trim().replaceFirst("^0x", "");
    }
}

