/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRestStorageHandler {
    protected static final Log logger = LogFactory.getInstance(AbstractRestStorageHandler.class);
    private final RestConnectionManager connMgr = RestConnectionManager.getInstance();

    protected RestConnection getConnection(String devSn) {
        RestConnection connection = this.connMgr.getConnection(devSn);
        if (null == connection) {
            logger.error((Object)("The connection does not exist. sn=" + devSn));
            throw new LegoCheckedException(1073947649L);
        }
        return connection;
    }

    protected Map<String, String> transform(Map<String, Object> info) {
        HashMap<String, String> strStrMap = new HashMap<String, String>();
        if (VerifyUtil.isEmpty(info)) {
            return strStrMap;
        }
        for (Map.Entry<String, Object> next : info.entrySet()) {
            String key = next.getKey();
            Object value = next.getValue();
            String str = this.toStr(value);
            strStrMap.put(key, str);
        }
        return strStrMap;
    }

    private String toStr(Object obj) {
        if (null == obj) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Number) {
            return obj.toString();
        }
        if (obj instanceof Enum) {
            logger.error((Object)("Enum type can not be transformed, value=" + obj));
            throw new LegoCheckedException(1073947393L);
        }
        return "";
    }
}

