/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.drm.backup.model.BackupProxy;
import com.huawei.ism.drm.backup.service.IBackupProxyService;
import com.huawei.ism.drm.storage.handler.IStorageBackupProxyHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageBackupProxyHandlerImpl
extends AbstractRestStorageHandler
implements IStorageBackupProxyHandler {
    @Override
    protected RestConnection getConnection(String devSn) {
        return super.getConnection(devSn);
    }

    @Override
    protected Map<String, String> transform(Map<String, Object> info) {
        return super.transform(info);
    }

    private Map<String, String> constructCreateProxyParameter(BackupProxy proxy) {
        if (VerifyUtil.isEmpty((Object)proxy) || VerifyUtil.isEmpty((String)proxy.getName())) {
            logger.error((Object)"The input parameter proxy is null.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> responseMap = new HashMap<String, String>();
        responseMap.put("NAME", proxy.getName());
        responseMap.put("DESCRIPTION", proxy.getDescription());
        responseMap.put("url", proxy.getAddress());
        responseMap.put("port", proxy.getPort());
        if (!proxy.getAnonymous().booleanValue()) {
            responseMap.put("userName", proxy.getUserName());
            if (!VerifyUtil.isEmpty((String)proxy.getPassword())) {
                String password = WccEncryptor.decrypt((String)proxy.getPassword());
                responseMap.put("password", password);
            }
        }
        return responseMap;
    }

    private BackupProxy transitionResponseProxy(Map<String, String> map) {
        if (VerifyUtil.isEmpty(map)) {
            logger.error((Object)"parameter error.");
            throw new LegoCheckedException(1073947393L);
        }
        BackupProxy proxy = new BackupProxy();
        proxy.setBackupProxyId(map.get("ID"));
        proxy.setName(map.get("NAME"));
        proxy.setDescription(map.get("DESCRIPTION"));
        proxy.setPassword(map.get("url"));
        proxy.setPort(map.get("port"));
        proxy.setUserName(map.get("userName"));
        return proxy;
    }

    public BackupProxy createBackupProxy(BackupProxy proxy, String backupEngineId, String verifyAddr) {
        if (null == proxy) {
            logger.error((Object)"create proxy error param, pool is null.");
            throw new LegoCheckedException(1073947393L);
        }
        VerifyUtil.checkStrs((String[])new String[]{proxy.getProxyId(), backupEngineId});
        String url = "/rest/${deviceID}/cloudbackup_proxy";
        logger.debug((Object)"start create backupProxy, url: %s, devSn: %s, proxyId: %s, verifyAddr: %s .", new Object[]{url, backupEngineId, proxy.getProxyId(), verifyAddr});
        Map<String, String> paramMap = this.constructCreateProxyParameter(proxy);
        Map result = null;
        BackupProxy backupProxy = null;
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            result = connection.post(url, paramMap);
            logger.debug((Object)"end create backup storage proxy, result: %s", new Object[]{result.toString()});
            BackupProxy backupProxy2 = backupProxy = this.transitionResponseProxy(result);
            return backupProxy2;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("create backup proxy failed,url: " + url + "proxy: " + proxy), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("create backup proxy failed,url: " + url + "proxy: " + proxy.toString()), (Throwable)e);
            throw new LegoCheckedException("create backup  proxy failed." + proxy.toString(), (Throwable)e);
        }
        finally {
            if (!VerifyUtil.isEmpty(backupProxy) && !VerifyUtil.isEmpty((String)backupProxy.getBackupProxyId())) {
                try {
                    this.verifyBackupProxy(backupProxy.getBackupProxyId(), backupEngineId, verifyAddr);
                }
                catch (LegoCheckedException e) {
                    this.deleteBackupProxy(backupProxy.getBackupProxyId(), backupEngineId);
                    throw e;
                }
            }
        }
    }

    public void verifyBackupProxy(String backupProxyId, String backupEngineId, String verifyAddr) {
        VerifyUtil.checkStrs((String[])new String[]{backupEngineId, backupProxyId});
        String url = "/rest/${deviceID}/cloudbackup_proxy/verify";
        logger.debug((Object)"start verify backupProxy, url: %s, devSn: %s, proxyId: %s, verifyAddr: %s .", new Object[]{url, backupEngineId, backupProxyId, verifyAddr});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", backupProxyId);
        paramMap.put("verifyAddr", verifyAddr);
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            connection.put(url, paramMap);
            logger.debug((Object)"end verify backup storage proxy, backupProxyId: %s", new Object[]{backupProxyId});
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("verify backup proxy failed, url: " + url + "backupProxyId: " + backupProxyId), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("verify backup proxy failed, url: " + url + "backupProxyId: " + backupProxyId), (Throwable)e);
            throw new LegoCheckedException("verify backup  proxy failed." + backupProxyId, (Throwable)e);
        }
    }

    public void updateBackupProxy(BackupProxy proxy, String backupEngineId) {
        if (null == proxy) {
            logger.error((Object)"update proxy error param, proxy is null.");
            throw new LegoCheckedException(1073947393L);
        }
        VerifyUtil.checkStrs((String[])new String[]{backupEngineId, proxy.getBackupProxyId()});
        String url = "/rest/${deviceID}/cloudbackup_proxy/" + proxy.getBackupProxyId();
        logger.debug((Object)"start update backupProxy, url : %s, devSn: %s, proxyId: %s.", new Object[]{url, backupEngineId, proxy.getBackupProxyId()});
        Map<String, String> map = this.constructCreateProxyParameter(proxy);
        BackupProxy localProxy = ((IBackupProxyService)ServiceLocator.getInstance().getService(IBackupProxyService.class)).getBackupProxy(proxy.getProxyId());
        if (localProxy.getName().equals(proxy.getName())) {
            map.remove("NAME");
        }
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            connection.put(url, map);
            logger.debug((Object)"end update backup storage pool, result: %s", new Object[]{proxy.toString()});
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("update backup proxy failed, url: " + url + "proxy: " + proxy), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("update backup proxy failed, url: " + url + "proxy: " + proxy.toString()), (Throwable)e);
            throw new LegoCheckedException("update backup proxy failed." + proxy.toString(), (Throwable)e);
        }
    }

    public void deleteBackupProxy(String proxyId, String backupEngineId) {
        VerifyUtil.checkStrs((String[])new String[]{backupEngineId, proxyId});
        String url = "/rest/${deviceID}/cloudbackup_proxy/" + proxyId;
        logger.debug((Object)"start delete backupProxy, url: %s, devSn: %s, proxyId: %s.", new Object[]{url, backupEngineId, proxyId});
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            connection.delete(url, null);
            logger.debug((Object)"end delete backup proxy, devsn: %s, proxy: %s", new Object[]{backupEngineId, proxyId});
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("delete backup proxy failed, url: " + url + "devsn: " + backupEngineId + "proxyId: " + proxyId), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("delete backup proxy failed, url: " + url + "devsn: " + backupEngineId + "proxyId: " + proxyId), (Throwable)e);
            throw new LegoCheckedException("delete backup proxy failed." + backupEngineId + proxyId, (Throwable)e);
        }
    }

    public List<BackupProxy> listBackupProxy(String backupEngineId, Map<String, String> filter) {
        if (VerifyUtil.isEmpty((String)backupEngineId)) {
            throw new LegoCheckedException(1073947393L);
        }
        String name = filter.get("name");
        StringBuilder url = new StringBuilder("/rest/${deviceID}/cloudbackup_proxy");
        if (!VerifyUtil.isEmpty((String)name)) {
            url.append("&filter=").append("NAME:" + name);
        }
        logger.debug((Object)"start query backupProxy list, url: %s, devSn: %s, filter name: %s.", new Object[]{url.toString(), backupEngineId, name});
        try {
            ArrayList<BackupProxy> proxys = new ArrayList<BackupProxy>();
            RestConnection connection = this.getConnection(backupEngineId);
            List records = connection.getBatch(url.toString(), null, false);
            logger.debug((Object)"end query backupProxy list.");
            if (!VerifyUtil.isEmpty((Collection)records)) {
                for (Map record : records) {
                    BackupProxy proxy = this.transitionResponseProxy(record);
                    proxys.add(proxy);
                }
            }
            return proxys;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query repositories error, url: " + url), (Throwable)le);
            if (1077948996L == le.getErrorCode()) {
                return null;
            }
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"query repositories failed.", (Throwable)e);
            throw new LegoCheckedException("query repositories failed.", (Throwable)e);
        }
    }

    public BackupProxy getBackupProxy(String proxyId, String backupEngineId) {
        VerifyUtil.checkStrs((String[])new String[]{backupEngineId, proxyId});
        String url = "/rest/${deviceID}/cloudbackup_proxy/" + proxyId;
        logger.debug((Object)"query backupProxy, url: %s, devSn: %s, proxyId: %s.", new Object[]{url, backupEngineId, proxyId});
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            Map responseMap = connection.get(url, null);
            logger.debug((Object)"end query backupProxy");
            if (!VerifyUtil.isEmpty((Map)responseMap)) {
                return this.transitionResponseProxy(responseMap);
            }
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query BackupProxy error, url: " + url), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query BackupProxy failed, url: " + url), (Throwable)e);
            throw new LegoCheckedException("query BackupProxy failed.", (Throwable)e);
        }
        return null;
    }
}

