/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.manager.sdk.model.NFSShareAuthClientVO;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.sdk.model.NFSShare;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.ubase.adaptor.hvs.discovery.util.HVSRestTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HvsStorageFileSystemManager
implements IStorageFileSystemManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageFileSystemManager.class);

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public List<NasFileSystem> queryFileSystems(String devSn, List<String> fsIds, String vstoreId) {
        ArrayList<NasFileSystem> list = new ArrayList<NasFileSystem>();
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        for (String fsId : fsIds) {
            String url = "/rest/${deviceID}/filesystem/" + fsId;
            if (!VerifyUtil.isEmpty((String)vstoreId)) {
                url = url + "?vstoreId=" + vstoreId;
            }
            logger.debug((Object)"Get fileSystems: url = %s", new Object[]{url});
            Map record = connection.get(url, null);
            logger.debug((Object)"Get fileSystems: url = %s, result = %s", new Object[]{url, record});
            NasFileSystem fileSystem = HVSRestTransition.transitionFileSystem((String)devSn, (Map)record);
            list.add(fileSystem);
        }
        return list;
    }

    public NFSShare createNFSShare(String devSn, String fsId, String sharePath, String vstoreId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("FSID", fsId);
        paramMap.put("SHAREPATH", sharePath);
        paramMap.put("DESCRIPTION", "");
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/NFSHARE";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "?vstoreId=" + vstoreId;
        }
        logger.debug((Object)"Post createNFSShare: url = %s, paramMap = %s", new Object[]{url, paramMap});
        Map result = connection.post(url, paramMap);
        logger.debug((Object)"createNFSShare: result = %s", new Object[]{result});
        String id = (String)result.get("ID");
        NFSShare nfsShare = new NFSShare();
        nfsShare.setDevSn(devSn);
        nfsShare.setFileSystemId(fsId);
        nfsShare.setSharePath(sharePath);
        nfsShare.setId(id);
        return nfsShare;
    }

    public OperationResult deleteNFSShare(String devSn, String nfsShareId, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        try {
            String url = "/rest/${deviceID}/NFSHARE/" + nfsShareId;
            if (!VerifyUtil.isEmpty((String)vstoreId)) {
                url = url + "?vstoreId=" + vstoreId;
            }
            logger.debug((Object)"Delete NFSShare: url = %s", new Object[]{url});
            connection.delete(url, null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("delete nfsshare failed. DevSn:" + devSn + ",Id:" + nfsShareId), (Throwable)e, 90160758784001L);
            return new OperationResult("ism.drm.delete.nfsshare.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return new OperationResult("ism.drm.delete.nfsshare.operation", true, true, new String[]{nfsShareId});
    }

    public OperationResult createNFSShareAuthClient(String deviceSn, String nfsShareId, NFSShareAuthClientVO nfsShareAuthClientVO, String vstoreId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("PARENTID", nfsShareId);
        paramMap.put("NAME", nfsShareAuthClientVO.getName());
        paramMap.put("ACCESSVAL", String.valueOf(nfsShareAuthClientVO.getAccessVal()));
        paramMap.put("SYNC", String.valueOf(nfsShareAuthClientVO.getSync()));
        paramMap.put("ALLSQUASH", String.valueOf(nfsShareAuthClientVO.getAllSquash()));
        paramMap.put("ROOTSQUASH", String.valueOf(nfsShareAuthClientVO.getRootSquash()));
        paramMap.put("TYPE", String.valueOf(XveMOType.NFS_SHARE_AUTH_CLIENT.getValue()));
        RestConnection connection = RestConnectionManager.getInstance().getConnection(deviceSn);
        try {
            String url = "/rest/${deviceID}/NFS_SHARE_AUTH_CLIENT";
            if (!VerifyUtil.isEmpty((String)vstoreId)) {
                url = url + "?vstoreId=" + vstoreId;
            }
            logger.debug((Object)"Post createNFSShareAuthClient: url = %s, params = %s", new Object[]{url, paramMap});
            connection.post(url, paramMap);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("create nfsShareAuthClient failed. DevSn:" + deviceSn + ",Id:" + nfsShareId + ",Name:" + nfsShareAuthClientVO.getName()), (Throwable)e, 90160758784001L);
            return new OperationResult("ism.drm.create.nfsshareauthclient.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return new OperationResult("ism.drm.create.nfsshareauthclient.operation", true, true, new String[0]);
    }

    public NFSShare getNFSShare(String devSn, String fsId, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/NFSHARE?range=[0-100]";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&vstoreId=" + vstoreId;
        }
        logger.debug((Object)"Get nfsshare: url = %s", new Object[]{url});
        List results = connection.getBatch(url, null);
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.debug((Object)"GetNFSShare result is null");
            return null;
        }
        NFSShare nfsShare = null;
        for (Map result : results) {
            String fsIdValue = (String)result.get("FSID");
            if (null == fsIdValue) {
                logger.error((Object)("get 'FSID' is null, devSn: " + devSn + ", fsId:" + fsId));
                continue;
            }
            if (!fsIdValue.equals(fsId)) continue;
            nfsShare = new NFSShare();
            nfsShare.setId((String)result.get("ID"));
            nfsShare.setSharePath((String)result.get("SHAREPATH"));
            nfsShare.setDevSn(devSn);
            nfsShare.setFileSystemId(fsId);
            break;
        }
        return nfsShare;
    }

    public List<NasFileSystem> queryFileSystems(String devSn, String vstoreId) {
        logger.debug((Object)("Enter batchQueryNasFileSystem, sn=" + devSn));
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/filesystem?range=[0-65536]";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&vstoreId=" + vstoreId;
        }
        logger.debug((Object)"Get fileSystems: url = %s", new Object[]{url});
        List records = connection.getBatch(url, null);
        ArrayList<NasFileSystem> list = new ArrayList<NasFileSystem>();
        for (Map record : records) {
            logger.debug((Object)record);
            NasFileSystem fileSystem = HVSRestTransition.transitionFileSystem((String)devSn, (Map)record);
            list.add(fileSystem);
        }
        logger.debug((Object)"Exit batchQueryNasFileSystem");
        return list;
    }
}

