/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HvsStorageFileSystemSnapshotManager
implements IStorageFileSystemSnapshotManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageFileSystemSnapshotManager.class);
    private static final String HYPERCDP_SNAPSHOT = "2";

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public List<Snapshot> querySnapshot(String devSn, String fsId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/FSSNAPSHOT");
        url.append("?TYPE=").append(XveMOType.FSSNAPSHOT.getValue());
        url.append("&PARENTID=").append(fsId);
        url.append("&sortby=TIMESTAMP,d");
        logger.debug((Object)"Get snapshots: url = %s", new Object[]{url.toString()});
        List records = connection.getBatch(url.toString(), null);
        ArrayList<Snapshot> snapshotIdList = new ArrayList<Snapshot>();
        for (Map map : records) {
            Snapshot snapshot = new Snapshot();
            snapshot.setId((String)map.get("ID"));
            snapshot.setName((String)map.get("NAME"));
            snapshot.setRollbackStatus((String)map.get("rollbackStatus"));
            snapshot.setRollbackEndTime(VerifyUtil.isEmpty((String)((String)map.get("rollbackEndtime"))) ? -1L : Long.parseLong((String)map.get("rollbackEndtime")) * 1000L);
            snapshot.setUtcTimeStamp(VerifyUtil.isEmpty((String)((String)map.get("utcTimeStamp"))) ? -1L : Long.parseLong((String)map.get("utcTimeStamp")) * 1000L);
            snapshot.setRestoreProgress(Integer.valueOf(VerifyUtil.isEmpty((String)((String)map.get("rollbackRate"))) ? -1 : Integer.parseInt((String)map.get("rollbackRate"))));
            snapshotIdList.add(snapshot);
        }
        return snapshotIdList;
    }

    public String createSnapshot(String devSn, String fsId, String name) {
        JSONObject basicParamMap = this.getBasicCreatingParams(devSn, fsId, name);
        return this.createNormalSnapshot(basicParamMap, false, 0, 0);
    }

    public String createSecureSnapshot(String devSn, String fsId, String name, int expiredTime, int expiredTimeUnit) {
        JSONObject basicParamMap = this.getBasicCreatingParams(devSn, fsId, name);
        return this.createNormalSnapshot(basicParamMap, true, expiredTime, expiredTimeUnit);
    }

    public String createHyperCDPSnapshot(String devSn, String fsId, String name) {
        JSONObject basicParamMap = this.getBasicCreatingParams(devSn, fsId, name);
        return this.createHyperCDPSnapshot(basicParamMap, false, 0, 0);
    }

    public String createHyperCDPSecureSnapshot(String devSn, String fsId, String name, int expiredTime, int expiredTimeUnit) {
        JSONObject basicParamMap = this.getBasicCreatingParams(devSn, fsId, name);
        return this.createHyperCDPSnapshot(basicParamMap, true, expiredTime, expiredTimeUnit);
    }

    public OperationResult deleteSnapshot(String devSn, String snapshotId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/fssnapshot";
        try {
            logger.debug((Object)"Delete snapshot: url = %s", new Object[]{url + "/" + snapshotId});
            connection.delete(url + "/" + snapshotId, null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Delete snapshot failed: url = %s", new Object[]{url + "/" + snapshotId});
            if (1073754118L == e.getErrorCode()) {
                return new OperationResult("ism.drm.create.fssnapshot.operation", true, true, new String[]{snapshotId});
            }
            return new OperationResult("ism.drm.create.fssnapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return new OperationResult("ism.drm.create.fssnapshot.operation", true, true, new String[]{snapshotId});
    }

    public OperationResult rollBackSnapshot(String devSn, String snapshotId, String rollbackSpeed) {
        OperationResult operationResult;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", snapshotId);
        paramMap.put("TYPE", String.valueOf(XveMOType.FSSNAPSHOT.getValue()));
        paramMap.put("rollbackSpeed", rollbackSpeed);
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/FSSNAPSHOT/ROLLBACK_FSSNAPSHOT";
        try {
            logger.debug((Object)"Put rollBackSnapshot: url = %s, param = %s", new Object[]{url, paramMap});
            connection.put(url, paramMap);
            operationResult = new OperationResult("ism.drm.restore.snapshot.operation", true, true, new String[]{snapshotId});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)String.format("Rollback snapshot failed. DevSN:%s, Id:%s, url:%s.", devSn, snapshotId, url), (Throwable)e);
            operationResult = new OperationResult("ism.drm.restore.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        catch (Exception e) {
            logger.error((Object)String.format("Rollback snapshot failed. DevSN:%s, Id:%s, url:%s, error Msg:%s", devSn, snapshotId, url, ExceptionUtil.getErrorMessage((Throwable)e)));
            operationResult = new OperationResult("ism.drm.restore.snapshot.operation", true, false, String.valueOf(1073948712L), new String[0]);
        }
        return operationResult;
    }

    public Snapshot querySpecificSnapshot(String devSn, String fsId, String snapshotId) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)fsId) || VerifyUtil.isEmpty((String)snapshotId)) {
            logger.error((Object)"The program requires the following parameters: devSn, fsId, snapshotId, which cannot be empty.");
            throw new LegoCheckedException(1073947393L);
        }
        List<Snapshot> snapshots = this.querySnapshot(devSn, fsId);
        for (Snapshot snapshot : snapshots) {
            if (!snapshotId.equals(snapshot.getSnapshotId())) continue;
            return snapshot;
        }
        return null;
    }

    public Optional<Snapshot> querySpecificSnapshot(String devSn, String vstoreId, String fsId, String snapshotId) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)vstoreId) || VerifyUtil.isEmpty((String)fsId) || VerifyUtil.isEmpty((String)snapshotId)) {
            logger.error((Object)"Requires the following parameters: devSn, vstoreId, fsId, snapshotId, which cannot be empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/fssnapshot");
        url.append("?vstoreId=").append(vstoreId);
        url.append("&range=[0-100]");
        url.append("&filter=PARENTID::").append(fsId);
        url.append("+and+NAME:").append(snapshotId);
        logger.debug((Object)"Get snapshots: url = %s", new Object[]{url.toString()});
        List records = connection.getBatch(url.toString(), null);
        if (records.size() == 0) {
            return Optional.empty();
        }
        Map map = (Map)records.get(0);
        Snapshot snapshot = new Snapshot();
        snapshot.setId((String)map.get("ID"));
        snapshot.setName((String)map.get("NAME"));
        snapshot.setRollbackStatus((String)map.get("rollbackStatus"));
        snapshot.setRollbackEndTime(VerifyUtil.isEmpty((String)((String)map.get("rollbackEndtime"))) ? -1L : Long.parseLong((String)map.get("rollbackEndtime")) * 1000L);
        snapshot.setUtcTimeStamp(VerifyUtil.isEmpty((String)((String)map.get("utcTimeStamp"))) ? -1L : Long.parseLong((String)map.get("utcTimeStamp")) * 1000L);
        snapshot.setRestoreProgress(Integer.valueOf(VerifyUtil.isEmpty((String)((String)map.get("rollbackRate"))) ? -1 : Integer.parseInt((String)map.get("rollbackRate"))));
        return Optional.of(snapshot);
    }

    public boolean isSecureSnapshotInProtectionPeriod(String devSn, String vstoreId, String fsId, String snapshotId) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)vstoreId) || VerifyUtil.isEmpty((String)fsId) || VerifyUtil.isEmpty((String)snapshotId)) {
            logger.error((Object)"Requires the following parameters: devSn, vstoreId, fsId, snapshotId, which cannot be empty.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
            StringBuilder url = new StringBuilder("/rest/${deviceID}/fssnapshot");
            url.append("?vstoreId=").append(vstoreId);
            url.append("&range=[0-100]");
            url.append("&filter=PARENTID::").append(fsId);
            url.append("+and+NAME:").append(snapshotId);
            logger.debug((Object)"Get snapshots: url = %s", new Object[]{url.toString()});
            List records = connection.getBatch(url.toString(), null);
            if (records.size() == 0) {
                return false;
            }
            String isInProtectionPeriod = (String)((Map)records.get(0)).get("isInProtectionPeriod");
            if (VerifyUtil.isEmpty((String)isInProtectionPeriod)) {
                logger.error((Object)"Snapshot do not have isInProtectionPeriod, may not be a secure snapshot");
                return false;
            }
            return new Boolean(isInProtectionPeriod);
        }
        catch (Exception e) {
            logger.error((Object)"Query secure snapshot error, make current snapshot isInProtectionPeriod");
            return true;
        }
    }

    public OperationResult transSnapshotToSecureSnapshot(String devSn, Map<String, String> paramMap) {
        OperationResult operationResult;
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/fssnapshot?t=" + System.currentTimeMillis();
        String snapshotId = paramMap.get("NAME");
        try {
            connection.put(url, paramMap);
            operationResult = new OperationResult("ism.drm.trans.snapshot.operation", true, true, new String[]{snapshotId});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)String.format("Trans snapshot failed. DevSN:%s, snapshotId:%s, url:%s.", devSn, snapshotId, url), (Throwable)e);
            operationResult = new OperationResult("ism.drm.trans.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        catch (Exception e) {
            logger.error((Object)String.format("Trans snapshot failed. DevSN:%s, snapshotId:%s, url:%s, error Msg:%s", devSn, snapshotId, url, ExceptionUtil.getErrorMessage((Throwable)e)));
            operationResult = new OperationResult("ism.drm.trans.snapshot.operation", true, false, String.valueOf(0x300001L), new String[0]);
        }
        return operationResult;
    }

    private String createNormalSnapshot(JSONObject paramMap, boolean isSecure, int expiredTime, int expiredTimeUnit) {
        if (isSecure) {
            this.encapsulateSafetyParams(paramMap, expiredTime, expiredTimeUnit);
        }
        return this.createSnapshot(paramMap);
    }

    private String createHyperCDPSnapshot(JSONObject paramMap, boolean isSecure, int expiredTime, int expiredTimeUnit) {
        paramMap.put((Object)"snapType", (Object)HYPERCDP_SNAPSHOT);
        if (isSecure) {
            this.encapsulateSafetyParams(paramMap, expiredTime, expiredTimeUnit);
        }
        return this.createSnapshot(paramMap);
    }

    private String createSnapshot(JSONObject paramMap) {
        RestConnection connection;
        Object obj = paramMap.remove((Object)"devSn");
        String devSn = "";
        if (obj instanceof String) {
            devSn = (String)obj;
        }
        if (VerifyUtil.isEmpty((Object)(connection = RestConnectionManager.getInstance().getConnection(devSn)))) {
            logger.error((Object)"Snapshot creation failed because connection could not be obtained.");
            throw new LegoCheckedException("Snapshot creation failed because connection could not be obtained.");
        }
        StringBuilder url = new StringBuilder("/rest/${deviceID}/FSSNAPSHOT");
        logger.debug((Object)"Post createSnapshot: url = %s, params = %s", new Object[]{url, paramMap});
        Map record = connection.post(url.toString(), (Map)paramMap);
        return (String)record.get("ID");
    }

    private JSONObject getBasicCreatingParams(String devSn, String fsId, String name) {
        JSONObject paramMap = new JSONObject();
        paramMap.put((Object)"TYPE", (Object)XveMOType.FSSNAPSHOT.getValue());
        paramMap.put((Object)"NAME", (Object)name);
        paramMap.put((Object)"PARENTTYPE", (Object)XveMOType.FILESYSTEM.getValue());
        paramMap.put((Object)"PARENTID", (Object)fsId);
        paramMap.put((Object)"devSn", (Object)devSn);
        return paramMap;
    }

    private void encapsulateSafetyParams(JSONObject paramMap, int expiredTime, int expiredTimeUnit) {
        paramMap.put((Object)"isSecuritySnap", (Object)"true");
        paramMap.put((Object)"isAutoDelete", (Object)"true");
        paramMap.put((Object)"expiredTime", (Object)expiredTime);
        paramMap.put((Object)"expiredTimeUnit", (Object)expiredTimeUnit);
    }
}

