/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.handler.IStorageReplicationHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReplicationManager;
import com.huawei.ism.drm.storage.replication.service.impl.AbstractReplicationService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.fusion.IStorageReplicationFusionService;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HvsStorageReplicationManagerAdapter
extends AbstractReplicationService
implements IStorageReplicationManager,
IStorageReplicationFusionService {
    private static final Log logger = LogFactory.getInstance(HvsStorageReplicationManagerAdapter.class);
    private final RestConnectionManager connMgr = RestConnectionManager.getInstance();
    private IStorageReplicationHandler replicationHandler;

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public List<ReplicationTargetLun> querySyncStatus(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        HashMap paramMap = new HashMap();
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        if (null == relation) {
            logger.error((Object)("Replication does not exist. SrcDevId:" + sourceArrayId + ",TgtDevId:" + targetArrayId + ",replicationId:" + replicationId + ",isConsistentGroup:" + isConsistentGroup), 90160758784001L);
            if (isConsistentGroup) {
                throw new LegoCheckedException(1073948767L, new String[]{replicationId});
            }
            throw new LegoCheckedException(1073948677L, new String[]{replicationId});
        }
        ArrayList<ReplicationTargetLun> tgtLunList = new ArrayList<ReplicationTargetLun>();
        RestConnection conn = this.connMgr.getConnection(relation.getDevSn());
        if (relation instanceof ReplicationGroup) {
            String url = "/rest/${deviceID}/replicationpair?filter=CGID::" + relation.getReplicationId() + "&range=[0-65536]";
            logger.debug((Object)"querySyncStatus url = %s, params = %s", new Object[]{url, paramMap});
            List resultMapList = conn.getBatch(url, paramMap);
            if (!VerifyUtil.isEmpty((Collection)resultMapList)) {
                for (Map repResult : resultMapList) {
                    ReplicationTargetLun tgtLun = HVSRestTransitionExtend.transitionReplicationTargetLun(repResult, relation.getDevSn());
                    tgtLunList.add(tgtLun);
                }
            }
        } else {
            String url = "/rest/${deviceID}/replicationpair/" + replicationId;
            logger.debug((Object)"querySyncStatus url = %s, params = %s", new Object[]{url, paramMap});
            Map repResult = conn.get(url, paramMap);
            ReplicationTargetLun tgtLun = HVSRestTransitionExtend.transitionReplicationTargetLun(repResult, relation.getDevSn());
            tgtLunList.add(tgtLun);
        }
        this.updateSyncInfo(tgtLunList);
        return tgtLunList;
    }

    public List<String> supportedDeviceList() {
        return null;
    }

    public OperationResult processCommand(String deviceId, String operationName, String url, JSONObject bodyJson) {
        url = "/rest/${deviceID}/" + url.replaceFirst("^/", "");
        return super.processCommand(deviceId, operationName, url, bodyJson);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, String resourceId, Integer resourceType) {
        logger.debug((Object)("sn=" + deviceSn + ", resourceId=" + resourceId));
        List<Object> replications = new ArrayList<ReplicationPair>();
        Integer type = this.getXveMoTypeFromResourceType(resourceType);
        if (type != null) {
            try {
                logger.debug((Object)"queryReplications deviceSn=%s, resourceId=%s ,resourceType=%s", new Object[]{deviceSn, resourceId, type});
                replications = this.replicationHandler.queryReplicationByAssociation(deviceSn, type.intValue(), resourceId);
            }
            catch (LegoCheckedException ex) {
                logger.error((Object)ex);
                String code = "50331651";
                if (code.equals(Long.toString(ex.getErrorCode()))) {
                    logger.error((Object)"Current device may not support FileSystem.");
                }
                throw ex;
            }
            catch (Exception e) {
                logger.error((Object)("queryReplications error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        } else {
            try {
                logger.debug((Object)"queryReplications resourceType is null deviceSn=%s, resourceId=%s", new Object[]{deviceSn, resourceId});
                replications = this.replicationHandler.queryReplicationByAssociation(deviceSn, XveMOType.LUN.getValue(), resourceId);
            }
            catch (Exception e) {
                logger.error((Object)("queryReplications error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            if (VerifyUtil.isEmpty(replications)) {
                try {
                    replications = this.replicationHandler.queryReplicationByAssociation(deviceSn, XveMOType.FILESYSTEM.getValue(), resourceId);
                }
                catch (LegoCheckedException ex) {
                    logger.error((Object)ex);
                    String code = "50331651";
                    if (code.equals(Long.toString(ex.getErrorCode()))) {
                        logger.error((Object)"Current device may not support FileSystem.");
                    }
                    throw ex;
                }
            }
        }
        return replications;
    }

    private Integer getXveMoTypeFromResourceType(Integer resourceType) {
        if (resourceType != null && resourceType.intValue() == DrmEnumDefine.ResourceTypeE.NAS.getValue()) {
            return XveMOType.FILESYSTEM.getValue();
        }
        if (resourceType != null && resourceType.intValue() == DrmEnumDefine.ResourceTypeE.LUN.getValue()) {
            return XveMOType.LUN.getValue();
        }
        return null;
    }

    public void changeRate(String sn, String id, boolean isCg, DmEnumDefine.SpeedLevelE rate) {
        logger.info((Object)("Enter change repliations rate, sn=" + sn + ", id=" + id + ", isCg=" + isCg + ", rate=" + rate));
        VerifyUtil.checkStrs((String[])new String[]{sn, id});
        DmEnumDefine.SpeedLevelE sl = null == rate ? DmEnumDefine.SpeedLevelE.SPEED_LEVEL_MIDDLE : rate;
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("SPEED", sl.getValue());
        this.getReplicationHandler().modify(sn, id, isCg, params);
        logger.info((Object)"Exit change repliations rate.");
    }

    public void modify(String sn, String id, boolean isCg, Map<String, Object> params) {
        this.getReplicationHandler().modify(sn, id, isCg, params);
    }

    public ReplicationRelation queryReplicationRelation(String sn, String id, boolean isCG) {
        return this.replicationHandler.queryReplication(sn, id, isCG);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, Collection<String> resources, Integer resourceType) {
        RestConnection conn = RestConnectionManager.getInstance().getConnection(deviceSn);
        if (null == conn) {
            throw new LegoCheckedException(104401L);
        }
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            return new ArrayList<ReplicationPair>();
        }
        List list = ExecutionService.map(resources, resoureId -> this.queryReplications(deviceSn, (String)resoureId, resourceType));
        ArrayList<ReplicationPair> pairs = new ArrayList<ReplicationPair>();
        list.stream().filter(pairList -> !VerifyUtil.isEmpty((Collection)pairList)).forEach(pairList -> pairs.addAll((Collection<ReplicationPair>)pairList));
        this.setRepTargettLuns(deviceSn, pairs);
        return pairs;
    }

    public IStorageReplicationHandler getReplicationHandler() {
        return this.replicationHandler;
    }

    public void setReplicationHandler(IStorageReplicationHandler replicationHandler) {
        this.replicationHandler = replicationHandler;
    }

    public void dispatchCommand(String deviceId, String url, Object data) {
        RestConnectionManager.getInstance().getConnection(deviceId).putForObject(url, data);
    }

    public List<ReplicationPair> getAllReplicationPairs(String deviceSN, String vstoreId) {
        RestConnection conn = RestConnectionManager.getInstance().getConnection(deviceSN);
        if (null == conn) {
            throw new LegoCheckedException(104401L);
        }
        if (VerifyUtil.isEmpty((String)deviceSN)) {
            return new ArrayList<ReplicationPair>();
        }
        String url = "/rest/${deviceID}/REPLICATIONPAIR?range=[0-65536]";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&vstoreId=" + vstoreId;
        }
        logger.debug((Object)"Get replicationPairs: url = %s", new Object[]{url});
        List resultMapList = conn.getBatch(url, null);
        ArrayList<ReplicationPair> replicationPairList = new ArrayList<ReplicationPair>();
        for (Map record : resultMapList) {
            try {
                ReplicationPair replicationPair = HVSRestTransitionExtend.transitionReplicationPair(record, deviceSN);
                replicationPairList.add(replicationPair);
            }
            catch (Exception e) {
                logger.warn((Object)("Storage[" + deviceSN + "] transition to replication pair failed"), 90160777658373L);
            }
        }
        this.setRepTargettLuns(deviceSN, replicationPairList);
        return replicationPairList;
    }

    private void checkAndBuildReplicationPairDRRing(List<ReplicationPair> relations, List<ReplicationGroup> replicationGroups) {
        if (VerifyUtil.isEmpty(relations) || VerifyUtil.isEmpty(replicationGroups)) {
            return;
        }
        HashMap<String, String> replicationGroupMap = new HashMap<String, String>();
        for (ReplicationGroup replicationGroup : replicationGroups) {
            replicationGroupMap.put(replicationGroup.getReplicationId(), replicationGroup.getDrRingId());
        }
        for (ReplicationPair replicationPair : relations) {
            if (!VerifyUtil.isEmpty((String)replicationPair.getDrRingId())) continue;
            replicationPair.setDrRingId((String)replicationGroupMap.get(replicationPair.getConsistentGroupId()));
        }
    }

    public List<ReplicationGroup> getAllReplicationGroups(String deviceSN) {
        RestConnection conn = RestConnectionManager.getInstance().getConnection(deviceSN);
        if (conn == null) {
            throw new LegoCheckedException(104401L);
        }
        if (VerifyUtil.isEmpty((String)deviceSN)) {
            return new ArrayList<ReplicationGroup>();
        }
        String url = "/rest/${deviceID}/CONSISTENTGROUP?range=[0-65536]";
        logger.debug((Object)"Get replicationGroups: url = %s", new Object[]{url});
        List resultMapList = conn.getBatch(url, null);
        ArrayList<ReplicationGroup> replicationGroupList = new ArrayList<ReplicationGroup>();
        for (Map record : resultMapList) {
            try {
                ReplicationGroup replication = HVSRestTransitionExtend.transitionReplicationGroup(record, deviceSN);
                replicationGroupList.add(replication);
            }
            catch (Exception e) {
                logger.warn((Object)("Storage[" + deviceSN + "] transition to replication group failed"), 90160777658373L);
            }
        }
        return replicationGroupList;
    }

    private void setRepTargettLuns(String deviceSn, List<ReplicationPair> pairs) {
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (!isVasa) {
            List<ReplicationGroup> replicationGroups = this.getAllReplicationGroups(deviceSn);
            this.checkAndBuildReplicationPairDRRing(pairs, replicationGroups);
        }
        for (ReplicationPair pair : pairs) {
            if (VerifyUtil.isEmpty((Object)pair) || VerifyUtil.isEmpty((Collection)pair.getChildMos())) continue;
            ReplicationTargetLun tgtLuns = (ReplicationTargetLun)pair.getChildMos().iterator().next();
            pair.setRepTgtLuns(Arrays.asList(tgtLuns));
        }
    }

    public ReplicationGroup getReplicationGroup(String devSN, String groupId) {
        if (null == devSN || null == groupId) {
            logger.error((Object)"input param is null.");
            return null;
        }
        return (ReplicationGroup)this.replicationHandler.queryReplication(devSN, groupId, true);
    }

    public List<ReplicationPair> queryReplicationPairByCgId(String devSN, String cgId) {
        logger.debug((Object)"query replication pair by CG start. devSn=%s, cgId=%s", new Object[]{devSN, cgId});
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSN);
        List resultMapList = connection.getBatch("/rest/${deviceID}/REPLICATIONPAIR?filter=CGID::" + cgId, null);
        ArrayList<ReplicationPair> replicationPairList = new ArrayList<ReplicationPair>();
        for (Map record : resultMapList) {
            try {
                ReplicationPair replicationPair = HVSRestTransitionExtend.transitionReplicationPair(record, devSN);
                replicationPairList.add(replicationPair);
            }
            catch (LegoCheckedException e) {
                logger.warn((Object)("Storage[" + devSN + "] transition to replication pair failed"), 90160777658373L);
                return null;
            }
        }
        for (ReplicationPair pair : replicationPairList) {
            if (VerifyUtil.isEmpty((Object)pair) || VerifyUtil.isEmpty((Collection)pair.getChildMos())) continue;
            ReplicationTargetLun tgtLuns = (ReplicationTargetLun)pair.getChildMos().iterator().next();
            pair.setRepTgtLuns(Arrays.asList(tgtLuns));
        }
        return replicationPairList;
    }

    public ReplicationPair getReplicationPair(String devSN, String pairId) {
        if (VerifyUtil.isEmpty((String)devSN)) {
            return null;
        }
        RestConnection conn = RestConnectionManager.getInstance().getConnection(devSN);
        if (conn == null) {
            throw new LegoCheckedException(104401L);
        }
        String url = "/rest/${deviceID}/REPLICATIONPAIR/" + pairId;
        List resultMapList = conn.getBatch(url, null);
        ArrayList<ReplicationPair> replicationPairList = new ArrayList<ReplicationPair>();
        for (Map record : resultMapList) {
            try {
                ReplicationPair replicationPair = HVSRestTransitionExtend.transitionReplicationPair(record, devSN);
                replicationPairList.add(replicationPair);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Storage[%s] transition to replication pair failed", new Object[]{devSN, 90160777658373L});
            }
        }
        this.setRepTargettLuns(devSN, replicationPairList);
        return (ReplicationPair)replicationPairList.get(0);
    }
}

