/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.google.common.base.Objects;
import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.storage.hvs.manager.HvsStorageHyperMetroManager;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;

public class HvsStorageV6HyperMetroManager
extends HvsStorageHyperMetroManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageV6HyperMetroManager.class);

    public String getVersion() {
        return "V600R000C00";
    }

    @Override
    protected void parsePair(String devSn, String id, DrmEnumDefine.RoleType role, String vstoreId) {
        RestConnection conn = this.getConn(devSn);
        HashMap<String, String> paras = new HashMap<String, String>();
        HyperMetroPair hyperMetroPair = this.getHyperMetroPairById(id);
        if (hyperMetroPair.getResourceType().intValue() != XveEnumDefine.HC_ResourceTypeE.ST_FILE_SYSTEM.getValue()) {
            super.parsePair(devSn, id, role, vstoreId);
            return;
        }
        String url = "/rest/${deviceID}/SplitFsHyperMetroDomain";
        paras.put("ID", hyperMetroPair.getDomainId());
        if (role != null) {
            if (DrmEnumDefine.RoleType.PRIORITY.equals((Object)role)) {
                paras.put("STOPROLE", "0");
            } else {
                paras.put("STOPROLE", "1");
            }
        }
        conn.post(url, paras);
    }

    private HyperMetroPair getHyperMetroPairById(String id) {
        return ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getHyperMetroPairById(id);
    }

    @Override
    protected void syncPair(String devSn, String pairId, String vstoreId) {
        block3: {
            RestConnection conn = this.getConn(devSn);
            HyperMetroPair hyperMetroPair = this.getHyperMetroPairById(pairId);
            if (hyperMetroPair.getResourceType().intValue() != XveEnumDefine.HC_ResourceTypeE.ST_FILE_SYSTEM.getValue()) {
                super.syncPair(devSn, pairId, vstoreId);
                return;
            }
            HashMap<String, String> paras = new HashMap<String, String>();
            paras.put("ID", hyperMetroPair.getDomainId());
            String url = "/rest/${deviceID}/JoinFsHyperMetroDomain";
            try {
                conn.post(url, paras);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"sync domain error: %s", new Object[]{e.getMessage()});
                if (Objects.equal((Object)1077674565L, (Object)e.getErrorCode())) break block3;
                throw e;
            }
        }
    }

    public boolean isHyperMetroDomainPrimary(HyperMetroDomain hyperMetroDomain) {
        VerifyUtil.checkObject((Object)hyperMetroDomain);
        switch (hyperMetroDomain.getRole()) {
            case "1": {
                return true;
            }
            case "0": {
                return false;
            }
        }
        logger.error((Object)"Wrong role value for domain: %s, domainId=%s", new Object[]{hyperMetroDomain.getRole(), hyperMetroDomain.getId()});
        throw new LegoCheckedException(1073947393L);
    }
}

