/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.template.filter;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationUtil;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayHyperMetroAsynReplicationFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class ArrayHyperMetroAsyncDRRingFilter
extends ArrayHyperMetroAsynReplicationFilter {
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroAsyncDRRingFilter.class);

    public int getType() {
        return 26;
    }

    protected void checkMultiCgMatch(List<ProtectObject> protectObjects) {
        this.getFilterContext().put("is_multi_hyper_metro_cg_key", Boolean.FALSE);
        HashMap<String, ProtectObject> poByWwn = new HashMap<String, ProtectObject>();
        ProtectObject po = (ProtectObject)protectObjects.stream().findFirst().orElseThrow(() -> new LegoCheckedException(1073947393L));
        if (po.getPoType() != 11) {
            return;
        }
        String mainDevSn = po.getProviderSN();
        ArrayList<String> lunWwnList = new ArrayList<String>();
        this.constructPoAndWwn(protectObjects, poByWwn, lunWwnList);
        List repPairs = this.getAsyncReplicationFilter().getStorageService().queryReplicationPairsByMasterLunWWN(lunWwnList);
        HashMap poByCgMap = new HashMap();
        HashMap<String, Integer> siteCount = new HashMap<String, Integer>();
        int paisCountWithCG = 0;
        for (ReplicationPair repPair : repPairs) {
            String consistentGroupId = repPair.getConsistentGroupId();
            if (VerifyUtil.isEmpty((String)consistentGroupId) || consistentGroupId.equals("--")) continue;
            siteCount.compute(repPair.getSrcDevSN(), (cgId, cnt) -> {
                int n;
                if (cnt == null) {
                    n = 1;
                } else {
                    cnt = cnt + 1;
                    n = cnt;
                }
                return n;
            });
            if (!Objects.equals(mainDevSn, repPair.getSrcDevSN())) continue;
            ++paisCountWithCG;
            ArrayList<ProtectObject> poListByGroup = (ArrayList<ProtectObject>)poByCgMap.get(consistentGroupId);
            if (Objects.isNull(poListByGroup)) {
                poListByGroup = new ArrayList<ProtectObject>();
                poByCgMap.put(consistentGroupId, poListByGroup);
            }
            ProtectObject protectObject = (ProtectObject)poByWwn.get(repPair.getSrcLunWWN());
            poListByGroup.add(protectObject);
        }
        logger.info((Object)"Count result: paisCountWithCG=%s, siteCount=%s, poByCgMap.size=%s", new Object[]{paisCountWithCG, siteCount.size(), poByCgMap.size()});
        if (paisCountWithCG == protectObjects.size() && siteCount.size() == 2 && poByCgMap.size() > 1) {
            DRRingUtil.checkDRRingCgLimit(poByCgMap.size());
            this.getFilterContext().put("is_multi_hyper_metro_cg_key", Boolean.TRUE);
        }
    }

    private void constructPoAndWwn(List<ProtectObject> protectObjects, Map<String, ProtectObject> poByWwn, List<String> lunWwnList) {
        for (ProtectObject protectObject : protectObjects) {
            Set usedStorageResourceSet = protectObject.getUsedStorageResourceSet();
            usedStorageResourceSet = Optional.ofNullable(usedStorageResourceSet).orElseGet(HashSet::new);
            for (ProtectObjectStorageInfo protectObjectStorageInfo : usedStorageResourceSet) {
                poByWwn.put(protectObjectStorageInfo.getLunWWN(), protectObject);
                lunWwnList.add(protectObjectStorageInfo.getLunWWN());
            }
        }
    }

    protected void cascadeFilterOperation(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        super.cascadeFilterOperation(protectObjects, context);
        this.cascadeFilterOperationForDRRing(protectObjects, context);
    }

    private void cascadeFilterOperationForDRRing(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        List allRelatedReplicationPairs = (List)context.getObject("DR_RING_ALL_RELATED_PAIR_LIST");
        Map<String, Collection<ReplicationPair>> productStoragePairMap = ReplicationUtil.classifyReplicationPairByProductStorageSn(allRelatedReplicationPairs);
        if (productStoragePairMap.size() != 2) {
            logger.error((Object)("the number of product storage should be 2, but actual is " + productStoragePairMap.size()));
            throw new LegoCheckedException(1073948191L);
        }
        Map<String, Collection<ReplicationPair>> recoveryStoragePairMap = ReplicationUtil.classifyReplicationPairBySecondaryStorageSN(allRelatedReplicationPairs);
        if (recoveryStoragePairMap.size() != 1) {
            logger.error((Object)("the number of secodary storage should be 1, but actual is " + recoveryStoragePairMap.size()));
            throw new LegoCheckedException(1073948191L);
        }
        List storageInfos = this.getAllStorageInfo(protectObjects);
        Map<String, Collection<ReplicationPair>> pairMap = ReplicationUtil.classifyReplicationPairByStorage(storageInfos, allRelatedReplicationPairs);
        StringBuilder pairCountNotMatched = CommonUtil.checkValueCountNotMatched(pairMap, 2);
        if (pairCountNotMatched.length() > 0) {
            logger.error((Object)("number of replication pair for each lun should be 2, but actual is " + pairCountNotMatched));
            throw new LegoCheckedException(1073948191L);
        }
        this.checkStorageConsistencyForDRRing(productStoragePairMap, recoveryStoragePairMap, pairMap);
        StringBuilder targetLunInconsistency = ReplicationUtil.checkTargetLunConsistency(pairMap);
        if (targetLunInconsistency.length() > 0) {
            logger.error((Object)("target luns of replication pairs is inconsistent. " + targetLunInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder drRingIdInconsistency = DRRingUtil.checkDRRingConsistency(pairMap);
        if (drRingIdInconsistency.length() > 0) {
            logger.error((Object)("DR Ring ID of replication pairs is inconsistent. " + drRingIdInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        this.checkSidePairConsistency(context, productStoragePairMap);
        this.checkDRRingForCascadeFilter(protectObjects, allRelatedReplicationPairs, productStoragePairMap);
    }

    private void checkSidePairConsistency(PolicyTemplateContext context, Map<String, Collection<ReplicationPair>> productStoragePairMap) {
        Collection<ReplicationPair> normalSideReplicationPairs = DRRingUtil.getNormalPair(productStoragePairMap.values(), this.isHyperMetroMultiCg());
        Collection<ReplicationPair> standbySideReplicationPairs = DRRingUtil.getStandbyPair(productStoragePairMap.values(), this.isHyperMetroMultiCg());
        if (normalSideReplicationPairs.isEmpty() || normalSideReplicationPairs.size() != standbySideReplicationPairs.size()) {
            logger.error((Object)"replication pair number of normal side should not zero and as many as standby side, but actual is not. normal pair size:%s, standby pair size:%s", new Object[]{normalSideReplicationPairs.size(), standbySideReplicationPairs.size()});
            throw new LegoCheckedException(1073948191L);
        }
        List hyperMetroPairs = (List)context.getObject("PAIR_LIST");
        if (normalSideReplicationPairs.size() * 2 != hyperMetroPairs.size()) {
            logger.error((Object)"number of hyper metro pairs is not double of number of valid dr ring replication pairs.");
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder normalSideInconsistent = DRRingUtil.checkGroupConsistent(hyperMetroPairs, normalSideReplicationPairs);
        if (normalSideInconsistent.length() > 0) {
            logger.error((Object)new StringBuilder("consistent group member of normal side is not same.").append((CharSequence)normalSideInconsistent));
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder standbySideInconsistent = DRRingUtil.checkGroupConsistent(hyperMetroPairs, standbySideReplicationPairs);
        if (standbySideInconsistent.length() > 0) {
            logger.error((Object)new StringBuilder("consistent group member of standby side is not same.").append((CharSequence)standbySideInconsistent));
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void checkStorageConsistencyForDRRing(Map<String, Collection<ReplicationPair>> productStoragePairMap, Map<String, Collection<ReplicationPair>> recoveryStoragePairMap, Map<String, Collection<ReplicationPair>> pairMap) {
        Set<String> productStorageSNList = productStoragePairMap.keySet();
        StringBuilder productStorageInconsistency = ReplicationUtil.checkProductStorageConsistency(pairMap, productStorageSNList);
        if (productStorageInconsistency.length() > 0) {
            logger.error((Object)("product storage of replication pair is inconsistent. " + productStorageInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        Set<String> recoveryStorageSNList = recoveryStoragePairMap.keySet();
        StringBuilder recoveryStorageInconsistency = ReplicationUtil.checkRecoveryStorageConsistency(pairMap, recoveryStorageSNList);
        if (recoveryStorageInconsistency.length() > 0) {
            logger.error((Object)("recovery storage of replication pair is inconsistent. " + recoveryStorageInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void checkDRRingForCascadeFilter(List<ProtectObject> protectObjects, Collection<ReplicationPair> allRelatedReplicationPairs, Map<String, Collection<ReplicationPair>> productStoragePairMap) {
        String message = DRRingUtil.checkDRRingLimitsForProtectObjects(protectObjects, allRelatedReplicationPairs);
        if (message.length() > 0) {
            logger.error((Object)message);
            throw new LegoCheckedException(1073948191L);
        }
        Map<String, Collection<ReplicationPair>> drRingIdPairMap = DRRingUtil.classifyReplicationPairByDRRingId(allRelatedReplicationPairs);
        Set<String> usedDrRingIds = drRingIdPairMap.keySet();
        Set<String> productStorages = productStoragePairMap.keySet();
        StringBuilder notMatchedDRRings = DRRingUtil.checkRunningStatusNotMatchedRings(productStorages, usedDrRingIds, "1");
        if (notMatchedDRRings.length() != 0) {
            logger.error((Object)("running status of dr-ring list, must be enable. but actual:" + notMatchedDRRings));
            throw new LegoCheckedException(1073948191L);
        }
        DRRingUtil.checkDRRingsUsedByOtherProtectGroup(protectObjects, usedDrRingIds, productStorages);
    }

    protected void checkConsistentGroup(PolicyTemplateContext context, List<HyperMetroPair> pairs, Set<String> cgs) {
        Collection protectObjects = (Collection)context.getObject("PO_LIST");
        this.getFilterContext().put("cgIdSet", new HashSet());
        for (ProtectObject protectObject : protectObjects) {
            this.checkConsistentGroup(context, pairs, protectObject);
        }
        Set cgIdSet = (Set)this.getFilterContext().get("cgIdSet");
        ExecutionService.map((Collection)cgIdSet, cgId -> {
            this.checkConsistentGroupHealthStatus(context, Collections.singleton(cgId));
            return null;
        });
    }

    private void checkConsistentGroup(PolicyTemplateContext context, List<HyperMetroPair> pairs, ProtectObject protectObject) {
        pairs = DRRingUtil.getHyperMetroPairsByProtectObject(pairs, protectObject);
        Collection<String> cgs = DRRingUtil.getCgidOfHyperMetroPair(pairs);
        int drRingLimits = DRRingUtil.getDRRingLimits(protectObject);
        if (drRingLimits == 0) {
            logger.error((Object)"May encounter tampering attacks, because drRingLimits should be 1 or 2, not 0");
            throw new LegoCheckedException(1073948191L);
        }
        int limits = drRingLimits * 2;
        if (VerifyUtil.isEmpty(cgs) && pairs.size() != limits) {
            logger.error((Object)new StringBuilder("size of pairs list, must be ").append(limits).append(". but actual: ").append(pairs.size()));
            throw new LegoCheckedException(1073948191L);
        }
        limits = drRingLimits;
        if (!VerifyUtil.isEmpty(cgs) && cgs.size() != limits) {
            logger.error((Object)new StringBuilder("size of cgs list, must be ").append(limits).append(". but actual: ").append(cgs.size()));
            throw new LegoCheckedException(1073948191L);
        }
        ((Set)this.getFilterContext().get("cgIdSet")).addAll(cgs);
    }

    protected boolean shouldCheckHyperMetroRunningStatus() {
        return true;
    }

    protected List<ReplicationPair> getAllReplicationPair(List<StorageResource> allStorageResources, Integer resourceType) {
        List pairs = super.getAllReplicationPair(allStorageResources, resourceType);
        return DRRingUtil.processDRRingReplicationPairs(pairs, allStorageResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        String pgId;
        boolean flag = false;
        if (VerifyUtil.isEmpty(protectObjects)) {
            return null;
        }
        ProtectGroup pg = protectObjects.get(0).getProtectGroup();
        String string = pgId = null == pg ? null : pg.getUuid();
        if (!VerifyUtil.isEmpty((String)pgId)) {
            Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            try {
                NativeQuery query = session.createSQLQuery("select t.PLANSTATUS from ti_recoveryplan as t where t.PLANID = (select p.PLANID from ti_drp_r_pg as p where p.PGID = :pgId)");
                query.setString("pgId", pgId);
                List status = query.list();
                if (!VerifyUtil.isEmpty((Collection)status) && status.get(0).equals(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING.getValue())) {
                    flag = true;
                }
            }
            finally {
                DBOperationUtil.closeSession((Session)session);
            }
        }
        if (!flag) {
            this.isMatch(protectObjects);
        }
        List storageInfos = this.getAllStorageInfo(protectObjects);
        return DRRingUtil.getProtectLocationPaths(protectObjects, storageInfos);
    }

    protected List<ProtectGroupReplica> queryProtectGroupReplicaByGroup(String pgId, List<ReplicationPair> allPairs) {
        List replicas = super.queryProtectGroupReplicaByGroup(pgId, allPairs);
        StringBuilder message = DRRingUtil.updateProtectGroupReplica(replicas, allPairs);
        if (message.length() > 0) {
            logger.error((Object)message);
            throw new LegoCheckedException(1073948191L);
        }
        return replicas;
    }

    protected String checkBothLunExistReplicationPair(PolicyTemplateContext context, String devSn, ReplicationPair pair) {
        if (!this.isHyperMetroMultiCg()) {
            return super.checkBothLunExistReplicationPair(context, devSn, pair);
        }
        String tmpDevSn = devSn;
        String srcDevSN = pair.getSrcDevSN();
        if (Objects.isNull(tmpDevSn)) {
            tmpDevSn = srcDevSN;
        }
        Set hyperMetroDevSnSet = (Set)context.getObject("DEVICE_SN_SET");
        VerifyUtil.checkObject((Object)hyperMetroDevSnSet);
        if (!hyperMetroDevSnSet.contains(srcDevSN)) {
            logger.error((Object)"Src DevSn of replication pair don't match hyper-metro devSn! hyperMetroDevSn: %s, srcDevSN:", new Object[]{hyperMetroDevSnSet, srcDevSN});
            throw new LegoCheckedException(1073948191L);
        }
        return tmpDevSn;
    }

    protected void checkLunNotExistReplicationPair(List<StorageResource> allStorageResources, Map<String, ReplicationPair> lunId2Pair, String devSn) {
        if (!this.isHyperMetroMultiCg()) {
            super.checkLunNotExistReplicationPair(allStorageResources, lunId2Pair, devSn);
            return;
        }
        List relatedPairs = (List)this.getFilterContext().get("DR_RING_ALL_RELATED_PAIR_LIST");
        HashMap allLunId2Pair = new HashMap();
        relatedPairs.forEach(pair -> allLunId2Pair.put(pair.getSrcLunId(), pair));
        super.checkLunNotExistReplicationPair(allStorageResources, allLunId2Pair, devSn);
    }
}

