/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.calculator;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.calculator.BaseRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobExtendUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindowRange;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public abstract class AbstractHyperCloneSnapshotRPOCalculator
extends BaseRecoveryPointObjectiveCalculator {
    public static final Log logger = LogFactory.getInstance(AbstractHyperCloneSnapshotRPOCalculator.class);

    protected Map<String, Object> calcConfiguredRPO(RPOContext context) {
        HashMap<String, Object> cfgRPO = new HashMap<String, Object>();
        Optional optional = context.getObject("PG_ENTITY", ProtectGroup.class);
        if (!optional.isPresent()) {
            logger.error((Object)"ProtectGroup is empty.");
            return cfgRPO;
        }
        ProtectGroup protectGroup = (ProtectGroup)optional.get();
        String productSiteId = protectGroup.getProductSiteId();
        Set schedules = Optional.ofNullable(protectGroup.getTemplate()).map(PolicyTemplate::getSchedules).orElse(Collections.emptySet());
        if (VerifyUtil.isEmpty(schedules)) {
            cfgRPO.put(productSiteId, -2);
            return cfgRPO;
        }
        for (Schedule schedule : schedules) {
            int scheduleMode = schedule.getScheduleMode();
            if (scheduleMode == 1 || VerifyUtil.isEmpty((Object)schedule.isEnableRpoCheck())) {
                cfgRPO.put(productSiteId + "," + schedule.getProtectedType(), -1);
                continue;
            }
            if (!schedule.isEnableRpoCheck().booleanValue()) {
                cfgRPO.put(productSiteId + "," + schedule.getProtectedType(), -3);
                continue;
            }
            if (!ProtectionJobUtil.getInstance().isTimeInRange((ISchedule)schedule, new Date())) {
                cfgRPO.put(productSiteId + "," + schedule.getProtectedType(), -1);
                continue;
            }
            cfgRPO.put(productSiteId + "," + schedule.getProtectedType(), this.getConfigRPO(schedule.getExpectedRPO()));
        }
        return cfgRPO;
    }

    protected Map<String, Object> calcActualRPO(RPOContext context) {
        HashMap<String, Object> actualRPO = new HashMap<String, Object>();
        Optional protectGroupOptional = context.getObject("PG_ENTITY", ProtectGroup.class);
        if (!protectGroupOptional.isPresent()) {
            return actualRPO;
        }
        ProtectGroup protectGroup = (ProtectGroup)protectGroupOptional.get();
        String productSiteId = protectGroup.getProductSiteId();
        Iterator poIterator = protectGroup.getPolist().iterator();
        if (!poIterator.hasNext()) {
            logger.error((Object)"Protect object list is empty!");
            actualRPO.put(productSiteId, -2);
            return actualRPO;
        }
        ProtectObject po = (ProtectObject)poIterator.next();
        Optional<ProtectObjectStorageInfo> optional = Optional.of(po).map(ProtectObject::getUsedStorageResourceSet).map(Set::iterator).map(Iterator::next);
        if (!optional.isPresent()) {
            logger.error((Object)"No storage infos was found about the protectObjects.");
            actualRPO.put(productSiteId, -2);
            return actualRPO;
        }
        String sn = optional.get().getResourceProviderSN();
        int storageStatus = this.getStorageStatus(sn);
        if (storageStatus != 0) {
            actualRPO.put(productSiteId, -2);
            return actualRPO;
        }
        return this.calcActualRPO(protectGroup);
    }

    private Map<String, Object> calcActualRPO(ProtectGroup protectGroup) {
        Set schedules = protectGroup.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            logger.info((Object)"No need to calculate actual RPO.ProtectGroup(name:%s) has no schedules", new Object[]{protectGroup.getName()});
            HashMap<String, Object> actualRPO = new HashMap<String, Object>();
            actualRPO.put(protectGroup.getProductSiteId(), -2);
            return actualRPO;
        }
        if (protectGroup.isAirGapType()) {
            logger.info((Object)"Calculate the actual RPO for the AirGap protection group.");
            return this.calcActualRPOForAirGap(protectGroup, schedules);
        }
        logger.info((Object)"Calculate the actual RPO in a general way.");
        return this.calcGeneralActualRPO(protectGroup, schedules);
    }

    private Map<String, Object> calcGeneralActualRPO(ProtectGroup protectGroup, Set<Schedule> schedules) {
        HashMap<String, Object> actualRPO = new HashMap<String, Object>();
        String productSiteId = protectGroup.getProductSiteId();
        for (Schedule schedule : schedules) {
            OptionalLong lastSucExecTime = this.getPgLastSucExecTime(protectGroup, schedule);
            if (lastSucExecTime.isPresent()) {
                actualRPO.put(productSiteId + "," + schedule.getProtectedType(), System.currentTimeMillis() - lastSucExecTime.getAsLong());
                continue;
            }
            actualRPO.put(productSiteId + "," + schedule.getProtectedType(), -3);
        }
        return actualRPO;
    }

    private Map<String, Object> calcActualRPOForAirGap(ProtectGroup protectGroup, Set<Schedule> schedules) {
        long currentTimeMillis;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String productSiteId = protectGroup.getProductSiteId();
        List timeRanges = ProtectionJobExtendUtil.getTimeRangesByPg((ProtectGroup)protectGroup);
        Optional currentTimeWindow = ProtectionJobExtendUtil.findSpecificTimeWindow((List)timeRanges, (long)(currentTimeMillis = System.currentTimeMillis()));
        if (!currentTimeWindow.isPresent()) {
            logger.info((Object)"The current time is not within the time window of the protectGroup(name: %s)", new Object[]{protectGroup.getName()});
            resultMap.put(productSiteId, -2);
            return resultMap;
        }
        long currentTimeWindowStartTime = ((ResourceTimeWindowRange)currentTimeWindow.get()).getStartTime().getTime();
        for (Schedule schedule : schedules) {
            String rpoKey = productSiteId + "," + schedule.getProtectedType();
            if (schedule.getScheduleMode() == 1) {
                resultMap.put(productSiteId, -1);
                continue;
            }
            OptionalLong pgLastSucExecTime = this.getPgLastSucExecTime(protectGroup, schedule);
            if (pgLastSucExecTime.isPresent()) {
                Long actualRPO = this.calculateRPO(timeRanges, (ResourceTimeWindowRange)currentTimeWindow.get(), schedule, pgLastSucExecTime.getAsLong());
                resultMap.put(rpoKey, actualRPO);
                continue;
            }
            if (schedule.getShouldSkipFirstRPOCheck().booleanValue()) {
                resultMap.put(productSiteId, -2);
                continue;
            }
            long configuredRPO = this.getConfiguredRPO(protectGroup, rpoKey);
            if (configuredRPO > 0L && currentTimeMillis - currentTimeWindowStartTime > configuredRPO) {
                resultMap.put(rpoKey, -2);
                continue;
            }
            resultMap.put(rpoKey, -3);
        }
        return resultMap;
    }

    private long getConfiguredRPO(ProtectGroup protectGroup, String rpoKey) {
        RPOContext rpoContext = new RPOContext();
        rpoContext.addObject("PG_ENTITY", (Object)protectGroup);
        Map<String, Object> configuredRPOMap = this.calcConfiguredRPO(rpoContext);
        Object obj = configuredRPOMap.get(rpoKey);
        if (VerifyUtil.isEmpty((Object)obj)) {
            return -1L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Integer) {
            return Long.parseLong(String.valueOf(obj));
        }
        return -1L;
    }

    private OptionalLong getPgLastSucExecTime(ProtectGroup protectGroup, Schedule schedule) {
        ProtectGroupReplica latestActiveReplica = this.getLatestActivatedReplica(new ArrayList(protectGroup.getReplicaList()), schedule.getProtectedType());
        if (VerifyUtil.isEmpty((Object)latestActiveReplica)) {
            return OptionalLong.empty();
        }
        Long lastSuccessExecutedTime = this.getLastSuccessExcTime(protectGroup, this.isSnapShotPolicy() ? latestActiveReplica.getId() : null);
        return VerifyUtil.isEmpty((Object)lastSuccessExecutedTime) ? OptionalLong.empty() : OptionalLong.of(lastSuccessExecutedTime);
    }

    private Long calculateRPO(List<ResourceTimeWindowRange> timeRanges, ResourceTimeWindowRange currentTimeWindow, Schedule schedule, Long pgLastSucExecTime) {
        Optional lastSucTimeWindow = ProtectionJobExtendUtil.findSpecificTimeWindow(timeRanges, (long)pgLastSucExecTime);
        if (!lastSucTimeWindow.isPresent()) {
            logger.info((Object)"The last successful execution time(%s) is not within the time window.", pgLastSucExecTime.longValue());
            return -2L;
        }
        if (currentTimeWindow.equals(lastSucTimeWindow.get())) {
            return System.currentTimeMillis() - pgLastSucExecTime;
        }
        if (schedule.getShouldSkipFirstRPOCheck().booleanValue()) {
            return -2L;
        }
        return System.currentTimeMillis() - currentTimeWindow.getStartTime().getTime();
    }

    public Boolean isNeedRpoEarlyAlarm(RPOContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        PolicyTemplate template = protectGroup.getTemplate();
        Set schedules = template.getSchedules();
        Schedule schedule = this.getSchedule(schedules);
        int scheduleMode = schedule.getScheduleMode();
        if (0 == scheduleMode) {
            return this.checkRpoEarlyAlarm(protectGroup, null) == false;
        }
        return true;
    }

    private boolean isSnapShotPolicy() {
        List types = this.getTypes();
        return types.contains("2") || types.contains("14");
    }

    private Schedule getSchedule(Set<Schedule> schedules) {
        if (VerifyUtil.isEmpty(schedules)) {
            logger.error((Object)"schedules is empty.", 90160758784001L);
            throw new LegoCheckedException(2117645L);
        }
        Schedule schedule = null;
        for (Schedule sch : schedules) {
            if (1 == sch.getScheduleMode()) continue;
            schedule = sch;
        }
        if (schedule == null) {
            schedule = schedules.iterator().next();
        }
        return schedule;
    }

    protected String getSiteId(String str) {
        if (VerifyUtil.isEmpty((String)str)) {
            return "--";
        }
        String[] siteIdArray = str.split(",");
        if (siteIdArray.length != 2) {
            logger.error((Object)("getSiteId error! str:" + str), 90160758787071L);
            return "";
        }
        return siteIdArray[0];
    }

    protected Object getProductSiteId(String str) {
        if (VerifyUtil.isEmpty((String)str)) {
            return "--";
        }
        String[] siteIdArray = str.split(",");
        if (siteIdArray.length != 2) {
            logger.error((Object)("getProductSiteId error! str:" + str), 90160758787071L);
            return "";
        }
        return siteIdArray[0];
    }

    protected Object getProtectedType(String str) {
        if (VerifyUtil.isEmpty((String)str)) {
            return "--";
        }
        String[] siteIdArray = str.split(",");
        if (siteIdArray.length != 2) {
            logger.error((Object)("getPortectedType error! str:" + str), 90160758787071L);
            return "";
        }
        return siteIdArray[1];
    }
}

