/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.calculator;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.calculator.BaseRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.storage.protection.calculator.ArrayHyperMetroRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperMetroSnapshotRPOCalculator
extends BaseRecoveryPointObjectiveCalculator {
    public static final Log logger = LogFactory.getInstance(ArrayHyperMetroSnapshotRPOCalculator.class);
    private static final String SCHEDULE = "SCHEDULE_";
    private final String comma = ",";
    private ArrayHyperMetroRecoveryPointObjectiveCalculator calculator;

    public ArrayHyperMetroRecoveryPointObjectiveCalculator getCalculator() {
        return this.calculator;
    }

    public void setCalculator(ArrayHyperMetroRecoveryPointObjectiveCalculator calculator) {
        this.calculator = calculator;
    }

    public List<String> getTypes() {
        return Arrays.asList("19");
    }

    protected Map<String, Object> calcConfiguredRPO(RPOContext context) {
        this.init(context);
        LinkedHashMap<String, Object> cfgRPO = new LinkedHashMap<String, Object>();
        this.calculateSnapshotCfgRPO(context, DrmEnumDefine.ProtectLocation.A_A.getValue(), cfgRPO);
        this.calculateSnapshotCfgRPO(context, DrmEnumDefine.ProtectLocation.B_B.getValue(), cfgRPO);
        return cfgRPO;
    }

    protected Map<String, Object> calcActualRPO(RPOContext context) {
        LinkedHashMap<String, Object> actualRPO = new LinkedHashMap<String, Object>();
        this.calculateSnapshotActualRpo(context, actualRPO, DrmEnumDefine.ProtectLocation.A_A.getValue());
        this.calculateSnapshotActualRpo(context, actualRPO, DrmEnumDefine.ProtectLocation.B_B.getValue());
        return actualRPO;
    }

    protected String getSiteId(String str) {
        String[] array = str.split(",");
        if (array.length != 4) {
            logger.error((Object)"getSiteId error!", 90160758787071L);
            return "";
        }
        return array[2];
    }

    protected Object getProductSiteId(String key) {
        String[] array = key.split(",");
        if (array.length != 4) {
            logger.error((Object)"getProductSiteId error!", 90160758787071L);
            return "";
        }
        return array[1];
    }

    protected Object getProtectedType(String key) {
        String[] siteIdArray = key.split(",");
        if (siteIdArray.length != 4) {
            logger.error((Object)("getProtectType error! key: " + key), 90160758787071L);
            return "";
        }
        return siteIdArray[3];
    }

    private void init(RPOContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Set replicaList = protectGroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)replicaList)) {
            logger.error((Object)"replicaList is empty!", 90160758787071L);
            return;
        }
        for (ProtectGroupReplica protectGroupReplica : replicaList) {
            ArrayList<ProtectGroupReplica> pgReplicas;
            String key = protectGroupReplica.getProtectLocation() + "";
            Object object = context.getObject(key);
            if (object == null) {
                pgReplicas = new ArrayList<ProtectGroupReplica>();
                pgReplicas.add(protectGroupReplica);
                context.addObject(key, pgReplicas);
                continue;
            }
            pgReplicas = (ArrayList<ProtectGroupReplica>)object;
            pgReplicas.add(protectGroupReplica);
        }
    }

    private void calculateSnapshotCfgRPO(RPOContext context, int protectLocation, Map<String, Object> cfgRPO) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Set schedules = protectGroup.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            logger.error((Object)"schedules is empty!", 90160758787071L);
            return;
        }
        ArrayList<Schedule> scheduleList = new ArrayList<Schedule>();
        for (Schedule sch : schedules) {
            if (sch.getProtectLocation() != protectLocation) continue;
            scheduleList.add(sch);
        }
        if (VerifyUtil.isEmpty(scheduleList)) {
            logger.error((Object)("the schedule of protectLocation(" + protectLocation + ") is empty!"), 90160758787071L);
            return;
        }
        Schedule manuSchedule = null;
        for (Schedule schedule : scheduleList) {
            String recoverySite;
            String productSiteId = recoverySite = this.getRecoverySite(context, protectLocation);
            recoverySite = protectLocation + "," + productSiteId + "," + recoverySite + "," + schedule.getProtectedType();
            if (schedule.getScheduleMode() == 1) {
                manuSchedule = schedule;
                cfgRPO.put(recoverySite, -1);
                context.addObject(SCHEDULE + protectLocation, (Object)manuSchedule);
                continue;
            }
            if (VerifyUtil.isEmpty((Object)schedule.isEnableRpoCheck())) {
                cfgRPO.put(recoverySite, -1);
                continue;
            }
            if (!schedule.isEnableRpoCheck().booleanValue()) {
                cfgRPO.put(recoverySite, -3);
                continue;
            }
            if (!ProtectionJobUtil.getInstance().isTimeInRange((ISchedule)schedule, new Date())) {
                cfgRPO.put(recoverySite, -1);
                continue;
            }
            cfgRPO.put(recoverySite, this.getConfigRPO(schedule.getExpectedRPO()));
        }
    }

    private String getRecoverySite(RPOContext context, int protectLocation) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Set schedules = protectGroup.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            logger.error((Object)"schedules is empty!", 90160758787071L);
            return "";
        }
        Schedule schedule = null;
        for (Schedule sch : schedules) {
            if (sch.getProtectLocation() != protectLocation) continue;
            schedule = sch;
            break;
        }
        if (null == schedule) {
            logger.error((Object)"schedule is null!");
            return "";
        }
        return schedule.getSourceSiteId();
    }

    private void calculateSnapshotActualRpo(RPOContext context, Map<String, Object> actualRPO, int protectLocation) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Set schedules = protectGroup.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            logger.error((Object)"schedules is empty!");
            return;
        }
        for (Schedule schedule : schedules) {
            String recoverySiteId;
            if (VerifyUtil.isEmpty((Object)schedule) || schedule.getProtectLocation() != protectLocation) continue;
            String productSiteId = recoverySiteId = this.getRecoverySite(context, protectLocation);
            recoverySiteId = protectLocation + "," + productSiteId + "," + recoverySiteId + "," + schedule.getProtectedType();
            ProtectGroupReplica latestActiveReplica = this.getLatestActiveSnapshotReplica(context, protectLocation, schedule.getProtectedType());
            if (latestActiveReplica == null) {
                actualRPO.put(recoverySiteId, -3);
                continue;
            }
            Long lastSuccessExecutedTime = this.getLastSuccessExcTime(protectGroup, latestActiveReplica.getId());
            if (lastSuccessExecutedTime != null) {
                actualRPO.put(recoverySiteId, System.currentTimeMillis() - lastSuccessExecutedTime);
                continue;
            }
            actualRPO.put(recoverySiteId, -3);
        }
    }

    private ProtectGroupReplica getLatestActiveSnapshotReplica(RPOContext context, int protectLocation) {
        List pgReplicas = (List)context.getObject(protectLocation + "");
        return this.getLatestActivatedReplica(pgReplicas);
    }

    private ProtectGroupReplica getLatestActiveSnapshotReplica(RPOContext context, int protectLocation, int protectedType) {
        List pgReplicas = (List)context.getObject(protectLocation + "");
        return this.getLatestActivatedReplica(pgReplicas, protectedType);
    }

    private String getDoubleActiveSiteKey(RPOContext context) {
        String productSiteAB = this.getRecoverySite(context, DrmEnumDefine.ProtectLocation.A_A.getValue());
        String recoverySiteAB = this.getRecoverySite(context, DrmEnumDefine.ProtectLocation.B_B.getValue());
        String key = DrmEnumDefine.ProtectLocation.A_B.getValue() + "," + productSiteAB + "," + recoverySiteAB + "," + 63;
        return key;
    }
}

