/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.interceptor;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.storage.protection.interceptor.HandlerContext;
import com.huawei.ism.drm.storage.protection.interceptor.IReplicaBuildInterceptorHandler;
import com.huawei.ism.drm.storage.protection.replica.builder.Array4DCCascadeAsyncAsyncVaultBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.Array4DCCascadeSyncAsyncVaultBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.Array4DCConcurrentAsyncAsyncVaultBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.Array4DCConcurrentSyncAsyncVaultBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArrayHyperMetroSnapShotBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySanAirGapSnapshotBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySanHyperMetroAsyncAirGapSnapshotBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySanHyperMetroVaultBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySanHyperVaultBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySanVaultHyperMetroBuidler;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySnapshotBuilder;
import com.huawei.lego.cbb.resource.rollback.DefaultResourceRollbackTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ReplicaBuilderInterceptor {
    private static final Log logger = LogFactory.getInstance(ReplicaBuilderInterceptor.class);
    private final List<IReplicaBuildInterceptorHandler> handlers = new ArrayList<IReplicaBuildInterceptorHandler>();

    @After(value="execution(public void com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder.buildReplica(com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup))")
    public void afterMethod(JoinPoint joinPoint) {
        if (VerifyUtil.isEmpty((Object)joinPoint)) {
            throw new LegoCheckedException(1073947393L, "joinPoint not exists.");
        }
        if (!this.isNeedBuildSnapshot(joinPoint)) {
            return;
        }
        List<Object> args = Arrays.asList(joinPoint.getArgs());
        if (VerifyUtil.isEmpty(args)) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)args.get(0);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            throw new LegoCheckedException(1073947393L);
        }
        HandlerContext context = new HandlerContext(protectGroup, new DefaultResourceRollbackTask());
        try {
            for (IReplicaBuildInterceptorHandler handler : this.handlers) {
                handler.handle(context);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"ReplicaBuilder error!", (Throwable)e);
            context.getTask().execute();
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"ReplicaBuilder error!", (Throwable)e);
            context.getTask().execute();
            ExceptionUtil.rethrowException((Throwable)e, (String)"ReplicaBuilder error.", (long)-1L, null, (Log)logger);
        }
    }

    public void onBind(IReplicaBuildInterceptorHandler handler, Map<String, Object> properties) {
        this.handlers.add(handler);
    }

    private boolean isNeedBuildSnapshot(JoinPoint point) {
        HashSet<Class<Array4DCConcurrentAsyncAsyncVaultBuilder>> classSet = new HashSet<Class<Array4DCConcurrentAsyncAsyncVaultBuilder>>();
        classSet.add(ArraySanHyperVaultBuilder.class);
        classSet.add(ArraySnapshotBuilder.class);
        classSet.add(ArraySanAirGapSnapshotBuilder.class);
        classSet.add(ArraySanHyperMetroAsyncAirGapSnapshotBuilder.class);
        classSet.add(ArrayHyperMetroSnapShotBuilder.class);
        classSet.add(ArraySanHyperMetroVaultBuilder.class);
        classSet.add(ArraySanVaultHyperMetroBuidler.class);
        classSet.add(Array4DCCascadeSyncAsyncVaultBuilder.class);
        classSet.add(Array4DCConcurrentSyncAsyncVaultBuilder.class);
        classSet.add(Array4DCCascadeAsyncAsyncVaultBuilder.class);
        classSet.add(Array4DCConcurrentAsyncAsyncVaultBuilder.class);
        return classSet.contains(point.getTarget().getClass());
    }
}

