/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.interceptor.snapshotschedule;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotScheduleManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.protection.interceptor.HandlerContext;
import com.huawei.ism.drm.storage.protection.interceptor.IReplicaBuildInterceptorHandler;
import com.huawei.ism.drm.storage.protection.interceptor.lun.group.LunRollbackItem;
import com.huawei.ism.drm.storage.protection.interceptor.snapshotschedule.LunOfScheduleRollbackItem;
import com.huawei.ism.drm.storage.protection.interceptor.snapshotschedule.SnapScheduleRollbackItem;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SnapshotScheduleHandler
implements IReplicaBuildInterceptorHandler {
    private final ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();
    private final StorageSnapshotScheduleManagerProxy proxy = StorageSnapshotScheduleManagerProxy.getInstance();

    @Override
    public void handle(HandlerContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Object)protectGroup.getTemplate())) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)protectGroup.getTemplate().getSchedules())) {
            return;
        }
        IReplicaBuilder builder = this.factory.getTemplateByType(protectGroup.getTemplate().getType());
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            if (schedule.getScheduleMode() != 0 || schedule.getPeriodType() != 5) continue;
            String devSn = (String)devSns.get(schedule.getProtectLocation());
            if (this.existsReplica(protectGroup, devSn)) {
                this.refreshSchedule(context, protectGroup, schedule, devSn);
                continue;
            }
            SnapshotSchedule snapshotSchedule = SnapshotScheduleUtil.createSnapshotSchedule((ProtectGroup)protectGroup, (Schedule)schedule, (String)devSn);
            context.getTask().addItem((IRollbackItem)new SnapScheduleRollbackItem(snapshotSchedule));
        }
    }

    @Override
    public void addSchedule(ProtectGroup protectGroup, Schedule schedule) {
        if (schedule.getPeriodType() != 5) {
            return;
        }
        IReplicaBuilder builder = this.factory.getTemplateByType(protectGroup.getTemplate().getType());
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        String devSn = (String)devSns.get(schedule.getProtectLocation());
        SnapshotScheduleUtil.createSnapshotSchedule((ProtectGroup)protectGroup, (Schedule)schedule, (String)devSn);
    }

    private void refreshSchedule(HandlerContext context, ProtectGroup protectGroup, Schedule schedule, String devSn) {
        ArrayList<String> lunIds = new ArrayList<String>();
        ArrayList<String> wwns = new ArrayList<String>();
        IProtectObjectBaseProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        for (ProtectObjectStorageInfo storageInfo : protectGroup.distinctStorageInfo()) {
            if (schedule.getProtectedType() == ScheduleProtectedType.HYPERCDP.getValue() && provider.isProtectArchieveLog(storageInfo)) continue;
            wwns.add(storageInfo.getLunWWN());
        }
        ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(wwns.toArray(new String[wwns.size()])).forEach(storageResource -> {
            if (storageResource.getDevSn().equals(devSn)) {
                lunIds.add(storageResource.getResourceId());
            }
        });
        IStorageSnapshotScheduleManager snapshotScheduleManager = this.proxy.getStorageSnapshotMgrByDevId(devSn, schedule.getProtectedType());
        String snapshotScheduleOrLunCgId = snapshotScheduleManager.getSnapshotType() == SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue() ? (String)protectGroup.getProps().get("PROP_KEY_LUN_CG_KEY:" + devSn) : SnapshotScheduleUtil.getScheduleIdFromProtectGroup((ProtectGroup)protectGroup, (String)devSn);
        Set existLuns = snapshotScheduleManager.getExistLunsByScheduleId(devSn, snapshotScheduleOrLunCgId);
        List<String> addLuns = this.addLunToSchedule(lunIds, existLuns, devSn, snapshotScheduleOrLunCgId, snapshotScheduleManager);
        this.removeLunFromSchedule(lunIds, existLuns, devSn, snapshotScheduleOrLunCgId, snapshotScheduleManager);
        this.setRollbackParameter(context, devSn, snapshotScheduleOrLunCgId, snapshotScheduleManager.getSnapshotType(), addLuns);
    }

    private void removeLunFromSchedule(List<String> lunIds, Set<String> existLuns, String devSn, String snapshotScheduleOrLunCgId, IStorageSnapshotScheduleManager snapshotScheduleManagermanager) {
        ArrayList<String> removeLuns = new ArrayList<String>();
        for (String lunId : existLuns) {
            if (lunIds.contains(lunId = lunId.split(":")[1])) continue;
            removeLuns.add(lunId);
        }
        if (!VerifyUtil.isEmpty(removeLuns)) {
            snapshotScheduleManagermanager.removeLun(devSn, snapshotScheduleOrLunCgId, removeLuns);
        }
    }

    private List<String> addLunToSchedule(List<String> lunIds, Set<String> existLuns, String devSn, String snapshotScheduleOrLunCgId, IStorageSnapshotScheduleManager snapshotScheduleManager) {
        ArrayList<String> addLuns = new ArrayList<String>();
        for (String lunId : lunIds) {
            if (existLuns.contains(devSn + ":" + lunId)) continue;
            addLuns.add(lunId);
        }
        if (!VerifyUtil.isEmpty(addLuns)) {
            snapshotScheduleManager.addLun(devSn, snapshotScheduleOrLunCgId, addLuns);
        }
        return addLuns;
    }

    private boolean existsReplica(ProtectGroup protectGroup, String devSn) {
        String scheduleId = SnapshotScheduleUtil.getScheduleIdFromProtectGroup((ProtectGroup)protectGroup, (String)devSn);
        return !VerifyUtil.isEmpty((String)scheduleId);
    }

    private void setRollbackParameter(HandlerContext context, String devSn, String id, int type, List<String> addLuns) {
        if (SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue() == type) {
            if (!VerifyUtil.isEmpty(addLuns)) {
                addLuns.forEach(lun -> context.getTask().addItem((IRollbackItem)new LunRollbackItem(devSn, id, (String)lun)));
            }
        } else {
            IStorageSnapshotScheduleManager manager = this.proxy.getStorageSnapshotMgrByDevId(devSn, type);
            SnapshotSchedule snapshotSchedule = manager.query(devSn, id);
            context.getTask().addItem((IRollbackItem)new LunOfScheduleRollbackItem(snapshotSchedule, addLuns));
        }
    }

    @Override
    public void updateSchedule(ProtectGroup protectGroup, Schedule schedule) {
        SnapshotScheduleUtil.dealSecondPolicyRefineModify((ProtectGroup)protectGroup, (Schedule)schedule);
    }
}

