/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.storage.protection.path.builder.SyncReplicaProtectionPath;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;

public class AbstractKubeProtectionPath
extends SyncReplicaProtectionPath {
    private static final Log LOGGER = LogFactory.getInstance(AbstractKubeProtectionPath.class);

    @Override
    protected String getSiteRelation(ProtectGroup protectgroup) {
        if (VerifyUtil.isEmpty((Object)protectgroup)) {
            LOGGER.error((Object)"ProtectGroup is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        return PolicyTemplateType.KUBE_BACKUP_TYPES.contains(protectgroup.getTemplate().getType()) ? protectgroup.getProductSiteName() : protectgroup.getProductSiteName() + " --> " + this.getSiteService().getSiteById(((ProtectGroupReplica)protectgroup.getReplicaList().iterator().next()).getRecoverySite()).getName() + System.lineSeparator();
    }

    @Override
    protected String getRDPath(ProtectGroup protectgroup, ExecutionContext context) {
        int type = protectgroup.getTemplate().getType();
        boolean isReplication = PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(type);
        String sourceK8sCluster = protectgroup.getProperty("sourceKubeClusterIp");
        String targetK8sCluster = protectgroup.getProperty("targetKubeClusterIp");
        StringBuilder rdPathBuilder = new StringBuilder();
        for (ProtectObject protectObject : protectgroup.getPolist()) {
            String sourceResourceStr = this.getSingleResourceStr(protectObject, sourceK8sCluster);
            rdPathBuilder.append(sourceResourceStr);
            if (isReplication) {
                String targetResourceStr = this.getSingleResourceStr(protectObject, targetK8sCluster);
                rdPathBuilder.append(" --> ").append(targetResourceStr);
            }
            rdPathBuilder.append(System.lineSeparator());
        }
        rdPathBuilder.append(System.lineSeparator());
        return rdPathBuilder.toString();
    }

    private String getSingleResourceStr(ProtectObject protectObject, String owningK8sCluster) {
        String resource = protectObject.getName();
        String namespace = (String)protectObject.getProperty("namespace", String.class);
        return resource + "(" + namespace + ":" + owningK8sCluster + ")";
    }
}

