/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.path.builder.ArrayHyperMetroProtectionPath;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperMetroAsyncProtectionPath
extends ArrayHyperMetroProtectionPath {
    private static final String SRC_DEVICE_SN = "SRC_DEVICE_SN";
    private static final String OTHER_SITE_DEV_SN = "OTHER_SITE_DEV_SN";
    private static final String HYPER_METRO_LIST = "HYPER_METRO_LIST";
    private static final String DR_REOURCE = "DR_REOURCE";
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroAsyncProtectionPath.class);

    @Override
    public int getPolicyTemplateType() {
        logger.debug((Object)"PolicyTemplateType:ARRAY_HYPER_METRO_ASYNC_REPLICATION");
        return 18;
    }

    @Override
    public ProtectionPathData buildPath(ProtectGroup protectgroup, Map<String, ? extends StorageResource> luns, BatchOperation batchOperation) {
        logger.debug((Object)"to buildPath[ArrayHyperMetroAsyncProtectionPath] start..");
        ExecutionContext context = this.init(luns, batchOperation);
        ProtectionPath siteProtectionPath = this.buildSiteProtectionPath(protectgroup, context);
        ProtectionPath storageResProtectionPath = this.buildStorageResProtectionPath(protectgroup, context);
        return this.buildProtectionPathData(siteProtectionPath, storageResProtectionPath, context, protectgroup);
    }

    private ProtectionPath buildSiteProtectionPath(ProtectGroup protectgroup, ExecutionContext context) {
        logger.debug((Object)"start build site protection path...", 90160758784000L);
        ProtectionPath siteProtectionPath = new ProtectionPath();
        ArrayList<String> sitePathDetails = new ArrayList<String>();
        if (!this.checkIsNasType(protectgroup)) {
            sitePathDetails.add(this.getSiteRelationStr(protectgroup, context));
        } else {
            sitePathDetails.add(this.getNasSiteRelationStr(protectgroup, context));
        }
        siteProtectionPath.setPathDetails(sitePathDetails);
        logger.debug((Object)"end build site protection path...", 90160758784000L);
        return siteProtectionPath;
    }

    private ProtectionPath buildStorageResProtectionPath(ProtectGroup protectgroup, ExecutionContext context) {
        logger.debug((Object)"start build storage resource protection path...", 90160758784000L);
        ProtectionPath protectionpath = new ProtectionPath();
        ArrayList<String> rdPathDetails = new ArrayList<String>();
        if (!this.checkIsNasType(protectgroup)) {
            rdPathDetails.add(this.getRDPath(protectgroup, context));
        } else {
            rdPathDetails.add(this.getNasRDPath(protectgroup, context));
        }
        protectionpath.setPathDetails(rdPathDetails);
        logger.debug((Object)"end build storage resource protection path...", 90160758784000L);
        return protectionpath;
    }

    protected String getRDPath(ProtectGroup protectGroup, ExecutionContext context) {
        StringBuilder errorMsg = new StringBuilder();
        Set polist = protectGroup.getPolist();
        StringBuilder resourceProtectionPathStr = new StringBuilder();
        BatchOperation batchOperation = this.getBatchOperation(context);
        try {
            this.checkEmpty(polist, "polist is empty! pgName : " + protectGroup.getName(), batchOperation);
            String srcDeviceSn = (String)context.getAttribute(SRC_DEVICE_SN);
            this.checkEmpty(srcDeviceSn, "srcDeviceSn is empty!");
            HashSet<String> wwnSet = new HashSet<String>();
            for (ProtectObject po : polist) {
                this.getPoPathStr(protectGroup, errorMsg, resourceProtectionPathStr, context, wwnSet, po);
            }
        }
        catch (Exception e) {
            logger.error((Object)("getRDPath error.msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return resourceProtectionPathStr.toString();
    }

    private void getPoPathStr(ProtectGroup protectGroup, StringBuilder errorMsg, StringBuilder resourceProtectionPathStr, ExecutionContext context, Set<String> wwnSet, ProtectObject po) {
        BatchOperation batchOperation = this.getBatchOperation(context);
        String srcDeviceSn = (String)context.getAttribute(SRC_DEVICE_SN);
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        this.checkEmpty(usedStorageResourceSet, "usedStorageResourceSet is empty! pgName : " + protectGroup.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName(), batchOperation);
        for (ProtectObjectStorageInfo poStorageInfo : usedStorageResourceSet) {
            StorageResource srcStorageResource;
            errorMsg.delete(0, errorMsg.length());
            String lunWWN = poStorageInfo.getLunWWN();
            errorMsg.append("lunWWN:" + lunWWN + ", ");
            if (wwnSet.contains(lunWWN)) continue;
            List<StorageResource> storageResources = this.queryStorageResource(lunWWN);
            Iterator<StorageResource> iterator = storageResources.iterator();
            StorageResource storageResource = iterator.next();
            if (storageResource.getDevSn().equals(srcDeviceSn)) {
                srcStorageResource = storageResource;
                storageResource = iterator.next();
            } else {
                StorageResource tempStorageResource = iterator.next();
                if (tempStorageResource.getDevSn().equals(srcDeviceSn)) {
                    srcStorageResource = tempStorageResource;
                } else {
                    logger.error((Object)("getRDPath error.msg : can't find the srcStorageResource! " + errorMsg), 90160758787071L);
                    continue;
                }
            }
            this.getSinglePathStr(protectGroup, errorMsg, resourceProtectionPathStr, srcStorageResource, storageResource);
            resourceProtectionPathStr.append(";\n");
            wwnSet.add(lunWWN);
        }
    }

    private void getSinglePathStr(ProtectGroup protectGroup, StringBuilder errorMsg, StringBuilder resourceProtectionPathStr, StorageResource srcStorageResource, StorageResource storageResource) {
        this.buildDoubleActivePath(resourceProtectionPathStr, srcStorageResource, storageResource);
        this.buildAsyncronizationReplicationPath(protectGroup, errorMsg, resourceProtectionPathStr, srcStorageResource);
        logger.debug((Object)("resourceProtectionPathStr:" + resourceProtectionPathStr));
    }

    private void buildAsyncronizationReplicationPath(ProtectGroup protectGroup, StringBuilder errorMsg, StringBuilder resourceProtectionPathStr, StorageResource srcStorageResource) {
        resourceProtectionPathStr.append(" --> ");
        Lun lun = this.checkLunExsist(srcStorageResource.getDevSn(), srcStorageResource.getResourceId());
        List<ReplicationPair> pairs = this.getPairsByLun(lun, false);
        errorMsg.append("srcDevSN:" + srcStorageResource.getDevSn() + ", resourceID:" + srcStorageResource.getResourceId() + ", pairs: " + pairs);
        if (VerifyUtil.isEmpty(pairs) || pairs.size() != 1) {
            logger.error((Object)("pairs is empty! or pairs size is not one! pairs: " + pairs), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        ReplicationPair pair = pairs.iterator().next();
        List repTgtLuns = pair.getRepTgtLuns();
        this.checkEmpty(repTgtLuns, "repTgtLuns is empty! protectGroup name : " + protectGroup.getName());
        ReplicationTargetLun targetLun = (ReplicationTargetLun)repTgtLuns.iterator().next();
        String targetDevSn = targetLun.getTgtDevSN();
        this.checkEmpty(targetDevSn, "targetDevSn is empty!protectGroup name : " + protectGroup.getName());
        DrResource targetDrResource = this.getStorageBySn(targetDevSn);
        String targetIp = targetDrResource == null ? "" : targetDrResource.getIpAddress();
        resourceProtectionPathStr.append(targetLun.getTgtLunName()).append("(").append(targetIp).append(")");
    }

    private void buildDoubleActivePath(StringBuilder resourceProtectionPathStr, StorageResource srcStorageResource, StorageResource storageResource) {
        logger.debug((Object)"to buildDoubleActivePath start..");
        DrResource srcDrResource = this.getStorageBySn(srcStorageResource.getDevSn());
        DrResource drResource = this.getStorageBySn(storageResource.getDevSn());
        String srcDevIp = srcDrResource == null ? "" : srcDrResource.getIpAddress();
        String devIp = drResource == null ? "" : drResource.getIpAddress();
        resourceProtectionPathStr.append(storageResource.getName()).append("(").append(devIp).append(")");
        resourceProtectionPathStr.append(" -- ");
        resourceProtectionPathStr.append(srcStorageResource.getName()).append("(").append(srcDevIp).append(")");
    }

    private ProtectionPathData buildProtectionPathData(ProtectionPath siteProtectionPath, ProtectionPath storageResProtectionPath, ExecutionContext context, ProtectGroup protectgroup) {
        ArrayList<ProtectionPath> pathList = new ArrayList<ProtectionPath>();
        pathList.add(siteProtectionPath);
        pathList.add(storageResProtectionPath);
        ProtectionPathData ppd = new ProtectionPathData(pathList);
        BatchOperation batchOperation = this.getBatchOperation(context);
        if (batchOperation.getErrorCode() != 0L) {
            logger.error((Object)("to buildProtectionPathData error..errorcode:" + batchOperation.getErrorCode() + ", pg name:" + protectgroup.getName()));
            batchOperation.setTargetName(protectgroup.getName());
            ppd.setOperation(batchOperation);
        }
        return ppd;
    }

    protected String getNasRDPath(ProtectGroup protectGroup, ExecutionContext context) {
        List<NasFileSystem> otherNasFileList;
        List<NasFileSystem> srcNasFileList;
        ArrayList<String> wwns = new ArrayList<String>(RecoveryProcessUtil.getAllWwn((Set)protectGroup.getPolist()));
        List<ProtectObjectStorageInfo> storageResources = this.getPgNasInfos(protectGroup);
        String devSN = ((ProtectObjectStorageInfo)CommonUtil.getFirstElement(storageResources)).getResourceProviderSN();
        String srcDevSn = (String)context.getAttribute(SRC_DEVICE_SN);
        String otherDevSn = (String)context.getAttribute(OTHER_SITE_DEV_SN);
        if (devSN.equals(srcDevSn)) {
            srcNasFileList = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(devSN, wwns, NasFileSystem.class);
            otherNasFileList = this.getHyperMetroOtherSiteNasFileSystemList(srcDevSn, otherDevSn, wwns, context);
        } else if (devSN.equals(otherDevSn)) {
            otherNasFileList = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(devSN, wwns, NasFileSystem.class);
            srcNasFileList = this.getHyperMetroOtherSiteNasFileSystemList(otherDevSn, srcDevSn, wwns, context);
        } else {
            srcNasFileList = Collections.emptyList();
            otherNasFileList = Collections.emptyList();
        }
        this.checkEmpty(srcNasFileList, "srcNasFileList getAllPath");
        this.checkEmpty(otherNasFileList, "otherNasFileList getAllPath");
        StringBuilder resourceProtectionPathStr = new StringBuilder();
        for (NasFileSystem otherNas : otherNasFileList) {
            this.getNasFilePath(resourceProtectionPathStr, otherNas, context, srcNasFileList);
        }
        return resourceProtectionPathStr.toString();
    }

    private void getNasFilePath(StringBuilder resourceProtectionPathStr, NasFileSystem otherNas, ExecutionContext context, List<NasFileSystem> srcNasFileList) {
        DrResource otherDrReource = this.getDrResouceFromContext(context, otherNas.getDevSn());
        resourceProtectionPathStr.append(otherNas.getName()).append("(").append(otherDrReource == null ? "" : otherDrReource.getIpAddress()).append(")");
        resourceProtectionPathStr.append(" -- ");
        NasFileSystem srcNas = this.getVaultLoaclNas(otherNas, context, srcNasFileList);
        if (VerifyUtil.isEmpty((Object)srcNas)) {
            resourceProtectionPathStr.append(";\n");
            return;
        }
        DrResource srcDrReource = this.getDrResouceFromContext(context, srcNas.getDevSn());
        resourceProtectionPathStr.append(srcNas.getName()).append("(").append(srcDrReource == null ? "" : srcDrReource.getIpAddress()).append(")");
        resourceProtectionPathStr.append(" --> ");
        ReplicationTargetLun targetNas = this.getReplicationRemoteNas(srcNas);
        if (VerifyUtil.isEmpty((Object)targetNas)) {
            resourceProtectionPathStr.append(";\n");
            return;
        }
        DrResource targetDrReource = this.getDrResouceFromContext(context, targetNas.getTgtDevSN());
        resourceProtectionPathStr.append(targetNas.getTgtLunName()).append("(").append(targetDrReource == null ? "" : targetDrReource.getIpAddress()).append(")");
        resourceProtectionPathStr.append(";\n");
    }

    private DrResource getDrResouceFromContext(ExecutionContext context, String devSn) {
        DrResource drResource = (DrResource)context.getAttribute(DR_REOURCE + devSn, DrResource.class);
        if (VerifyUtil.isEmpty((Object)drResource)) {
            drResource = this.getStorageBySn(devSn);
            context.setAttribute(DR_REOURCE + devSn, (Object)drResource);
        }
        return drResource;
    }

    private ReplicationTargetLun getReplicationRemoteNas(NasFileSystem srcNas) {
        ArrayList<String> nasIds = new ArrayList<String>();
        nasIds.add(srcNas.getResourceId());
        List<ReplicationPair> pairList = this.queryValidReplicationPairsBy(srcNas.getDevSn(), nasIds, false, DrmEnumDefine.ResourceTypeE.NAS.getValue());
        if (!VerifyUtil.isEmpty(pairList) && pairList.size() == 1) {
            ReplicationPair replicationPair = (ReplicationPair)CommonUtil.getFirstElement(pairList);
            List repTgtLuns = replicationPair.getRepTgtLuns();
            this.checkEmpty(repTgtLuns, "repTgtLuns is empty!");
            ReplicationTargetLun targetLun = (ReplicationTargetLun)CommonUtil.getFirstElement((Collection)repTgtLuns);
            return targetLun;
        }
        return null;
    }

    private NasFileSystem getVaultLoaclNas(NasFileSystem otherNas, ExecutionContext context, List<NasFileSystem> srcNasFileList) {
        List hyperMetroPairList = (List)context.getAttribute(HYPER_METRO_LIST);
        String otherResourceID = null;
        for (HyperMetroPair pair : hyperMetroPairList) {
            if (pair.getDevSn().equals(otherNas.getDevSn())) {
                if (!otherNas.getResourceId().equals(pair.getLocalObjId())) continue;
                otherResourceID = pair.getRemoteObjId();
                break;
            }
            if (!otherNas.getResourceId().equals(pair.getRemoteObjId())) continue;
            otherResourceID = pair.getLocalObjId();
            break;
        }
        for (NasFileSystem nasFileSystem : srcNasFileList) {
            if (!nasFileSystem.getResourceId().equals(otherResourceID)) continue;
            return nasFileSystem;
        }
        return null;
    }

    private List<NasFileSystem> getHyperMetroOtherSiteNasFileSystemList(String srcDevSn, String otherDevSn, List<String> ids, ExecutionContext context) {
        Site site = this.getSiteByDeviceSN(srcDevSn);
        if (null == site) {
            logger.error((Object)("site is null, devSn: " + srcDevSn));
            throw new LegoCheckedException(1073947393L);
        }
        List hyperMetroPairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByFileSystemIds(site.getServerUuid(), srcDevSn, ids, null, false);
        this.checkEmpty(hyperMetroPairList, "hyperMetroPairList getHyperMetroOtherSiteNasFileSystemList");
        ArrayList<String> otherSiteIds = new ArrayList<String>();
        for (HyperMetroPair hyperMetroPair : hyperMetroPairList) {
            otherSiteIds.add(hyperMetroPair.getRemoteObjId());
        }
        context.setAttribute(HYPER_METRO_LIST, (Object)hyperMetroPairList);
        return StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(otherDevSn, otherSiteIds, NasFileSystem.class);
    }

    protected IStorageResourceService getIStorageResourceService() {
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        if (storageResourceService == null) {
            logger.error((Object)"to get the IStorageResourceService failed! ");
            throw new LegoCheckedException(-1L);
        }
        return storageResourceService;
    }

    protected String getSiteRelationStr(ProtectGroup protectgroup, ExecutionContext context) {
        StringBuilder siteRelationStr = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("pgname:" + protectgroup.getName());
        try {
            BatchOperation batchOperation = this.getBatchOperation(context);
            String lunWWN = this.randomSelectALunwwn(protectgroup, batchOperation);
            List<StorageResource> storageResources = this.queryStorageResource(lunWWN);
            StorageResource srcStorageResource = null;
            StorageResource otherStorageResource = null;
            List<ReplicationPair> pairs = null;
            for (StorageResource res : storageResources) {
                Lun lun = this.checkLunExsist(res.getDevSn(), res.getResourceId());
                List<ReplicationPair> pairList = this.getPairsByLun(lun, false);
                errorMsg.append("devSN:" + res.getDevSn() + ", resourceID:" + res.getResourceId() + ", pairs: " + pairList);
                if (!VerifyUtil.isEmpty(pairList) && pairList.size() == 1) {
                    this.checkEmpty(res.getDevSn(), "devSn is empty!errorMsg:" + errorMsg);
                    pairs = pairList;
                    srcStorageResource = res;
                    continue;
                }
                otherStorageResource = res;
            }
            this.checkEmpty(otherStorageResource, "otherStorageResource is null! errorMsg:" + errorMsg, batchOperation);
            Site otherSite = this.getSiteByDeviceSN(otherStorageResource.getDevSn());
            siteRelationStr.append(otherSite == null ? "" : otherSite.getName()).append(" -- ");
            context.setAttribute(SRC_DEVICE_SN, (Object)(srcStorageResource != null ? srcStorageResource.getDevSn() : ""));
            this.checkEmpty(srcStorageResource, "otherStorageResource is null! errorMsg:" + errorMsg, batchOperation);
            Site srcSite = this.getSiteByDeviceSN(srcStorageResource != null ? srcStorageResource.getDevSn() : "");
            siteRelationStr.append(srcSite == null ? "" : srcSite.getName());
            siteRelationStr.append(" --> ");
            if (VerifyUtil.isEmpty(pairs)) {
                logger.error((Object)errorMsg.toString(), 90160758784001L);
                throw new LegoCheckedException(1073947393L);
            }
            ReplicationPair replicationPair = pairs.iterator().next();
            List repTgtLuns = replicationPair.getRepTgtLuns();
            this.checkEmpty(repTgtLuns, "repTgtLuns is empty!");
            ReplicationTargetLun targetLun = (ReplicationTargetLun)repTgtLuns.iterator().next();
            Site targetSite = this.getSiteByDeviceSN(targetLun.getTgtDevSN());
            siteRelationStr.append(targetSite == null ? "" : targetSite.getName());
        }
        catch (RuntimeException e) {
            logger.error((Object)("runtimeException msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (Exception e) {
            logger.error((Object)("getSiteRelationStr error.msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return siteRelationStr.toString();
    }

    protected List<ReplicationPair> getPairsByLun(Lun lunMo, boolean fromDev) {
        if (VerifyUtil.isEmpty((Object)lunMo)) {
            logger.error((Object)"getPairsByLun error, lunMo is null.", 90160758787071L);
            return null;
        }
        Site site = this.getSiteByDeviceSN(lunMo.getDevSn());
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getPairsByLun error, site is null, deviceSN:" + lunMo.getDevSn()), 90160758787071L);
            return null;
        }
        ArrayList<String> lunIds = new ArrayList<String>();
        lunIds.add(lunMo.getLunId());
        if (fromDev) {
            return this.queryValidReplicationPairsBy(lunMo.getDevSn(), lunIds, true, DrmEnumDefine.ResourceTypeE.LUN.getValue());
        }
        return this.queryValidReplicationPairsBy(lunMo.getDevSn(), lunIds, false, DrmEnumDefine.ResourceTypeE.LUN.getValue());
    }

    protected List<ReplicationPair> getPairsByNas(String devSn, String resourceId) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)resourceId)) {
            logger.error((Object)"getPairsByNas error, fileSystem is null.", 90160758787071L);
            return null;
        }
        Site site = this.getSiteByDeviceSN(devSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getPairsByNas error, site is null, deviceSN:" + devSn), 90160758787071L);
            return null;
        }
        ArrayList<String> nasIds = new ArrayList<String>();
        nasIds.add(resourceId);
        return this.queryValidReplicationPairsBy(devSn, nasIds, false, DrmEnumDefine.ResourceTypeE.NAS.getValue());
    }

    private List<ReplicationPair> queryValidReplicationPairsBy(String devSn, List<String> lunIds, boolean isRealTime, Integer resourceType) {
        List pairList = null;
        try {
            pairList = this.getStorageService().queryReplicationPairsByMasterLunId(devSn, lunIds, isRealTime, resourceType);
        }
        catch (Exception e) {
            logger.error((Object)("query replicationpairs error." + devSn + " error is :" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            return new ArrayList<ReplicationPair>();
        }
        return pairList;
    }

    protected Lun checkLunExsist(String deviceId, String lunId) {
        Site site = this.getSiteByDeviceSN(deviceId);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("checkLunExsist error, site is null, deviceSN:" + deviceId), 90160758787071L);
            return null;
        }
        Lun lunMo = this.getStorageService().getLunBySnAndLunId(deviceId, lunId);
        if (null == lunMo) {
            logger.warn((Object)("can't get lun info(" + deviceId + "_" + lunId + ")."), 90160758786989L);
            throw new LegoCheckedException(1073948175L);
        }
        return lunMo;
    }

    protected NasFileSystem checkNasExist(String deviceId, String nasId) {
        Site site = this.getSiteByDeviceSN(deviceId);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("checkLunExsist error, site is null, deviceSN:" + deviceId), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> resourceIds = new ArrayList<String>();
        resourceIds.add(nasId);
        List fileSystemList = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(deviceId, resourceIds, NasFileSystem.class);
        if (VerifyUtil.isEmpty((Collection)fileSystemList)) {
            logger.warn((Object)("can't get fileSystem info(" + deviceId + "_" + nasId + ")."), 90160758786989L);
            throw new LegoCheckedException(1073948175L);
        }
        NasFileSystem fileSystem = (NasFileSystem)CommonUtil.getFirstElement((Collection)fileSystemList);
        return fileSystem;
    }

    protected Site getSiteByDeviceSN(String deviceSN) {
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null != drResource) {
            return this.getSiteService().getSiteById(drResource.getSiteId());
        }
        logger.error((Object)"to getSiteByDeviceSN. the drResource is null!");
        return null;
    }

    protected List<StorageResource> queryStorageResource(String lunWWN) {
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWWN});
        if (VerifyUtil.isEmpty((Collection)resources) || resources.size() != 2) {
            logger.error((Object)("method[getSrcDeviceSN()]. Resources is empty or the size is not two! resources size:" + resources), 90160758786897L);
            throw new LegoCheckedException(1073947393L);
        }
        return resources;
    }

    protected String randomSelectALunwwn(ProtectGroup protectGroup, BatchOperation batchOperation) {
        Set polist = protectGroup.getPolist();
        this.checkEmpty(polist, "polist is empty! pgName : " + protectGroup.getName(), batchOperation);
        ProtectObject po = (ProtectObject)polist.iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        this.checkEmpty(usedStorageResourceSet, "usedStorageResourceSet is empty! pgName : " + protectGroup.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName(), batchOperation);
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        String lunWWN = posi.getLunWWN();
        this.checkEmpty(lunWWN, "lunWWN is empty, po is:" + po.getUuid() + "-" + po.getName(), batchOperation);
        logger.debug((Object)("to randomSelectALunwwn end.. lunWWN:" + lunWWN));
        return lunWWN;
    }

    protected String getNasSiteRelationStr(ProtectGroup protectgroup, ExecutionContext context) {
        StringBuilder siteRelationStr = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("pgname:" + protectgroup.getName());
        try {
            BatchOperation batchOperation = this.getBatchOperation(context);
            String vStorePairId = this.getVstorePairIdByPg(protectgroup);
            if (VerifyUtil.isEmpty((String)vStorePairId)) {
                logger.error((Object)("protectGroup get vstorePairId is NULL. PGUUID:" + protectgroup.getUuid()));
                batchOperation.setErrorCode(2117645L);
                return "";
            }
            List<ProtectObjectStorageInfo> storageInfos = this.getPgNasInfos(protectgroup);
            this.checkEmpty(storageInfos, "storageInfos is empty");
            NasFileSystem fileSystem = this.getRandomNasFileSytem(storageInfos);
            this.checkEmpty(fileSystem, "fileSystem");
            HashMap<String, VstoreHyperMetroPair> vstoreHyperMetroPairMap = new HashMap<String, VstoreHyperMetroPair>();
            Map<String, String> snMap = this.getVstoreHyperPairList(vStorePairId, fileSystem.getDevSn(), vstoreHyperMetroPairMap);
            List<ReplicationPair> pairList = this.getPairsByNas(fileSystem.getDevSn(), fileSystem.getResourceId());
            String srcSn = null;
            String otherSn = null;
            ReplicationPair replicationPair = null;
            if (!VerifyUtil.isEmpty(pairList) && pairList.size() == 1) {
                srcSn = fileSystem.getDevSn();
                otherSn = snMap.get(srcSn);
                replicationPair = (ReplicationPair)CommonUtil.getFirstElement(pairList);
            } else {
                otherSn = fileSystem.getDevSn();
                srcSn = snMap.get(otherSn);
                replicationPair = this.getOtherSiteRepPair(vstoreHyperMetroPairMap, srcSn);
            }
            Site otherSite = this.getSiteByDeviceSN(otherSn);
            siteRelationStr.append(otherSite == null ? "" : otherSite.getName()).append(" -- ");
            context.setAttribute(SRC_DEVICE_SN, (Object)(srcSn != null ? srcSn : ""));
            context.setAttribute(OTHER_SITE_DEV_SN, (Object)otherSn);
            Site srcSite = this.getSiteByDeviceSN(srcSn != null ? srcSn : "");
            siteRelationStr.append(srcSite == null ? "" : srcSite.getName());
            siteRelationStr.append(" --> ");
            if (VerifyUtil.isEmpty((Object)replicationPair)) {
                logger.error((Object)errorMsg.toString(), 90160758784001L);
                throw new LegoCheckedException(1073947393L);
            }
            List repTgtLuns = replicationPair.getRepTgtLuns();
            this.checkEmpty(repTgtLuns, "repTgtLuns is empty!");
            ReplicationTargetLun targetLun = (ReplicationTargetLun)CommonUtil.getFirstElement((Collection)repTgtLuns);
            Site targetSite = this.getSiteByDeviceSN(targetLun.getTgtDevSN());
            siteRelationStr.append(targetSite == null ? "" : targetSite.getName());
        }
        catch (RuntimeException e) {
            logger.error((Object)("runtimeException msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (Exception e) {
            logger.error((Object)("getSiteRelationStr error.msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return siteRelationStr.toString();
    }

    private List<ProtectObjectStorageInfo> getPgNasInfos(ProtectGroup protectGroup) {
        ArrayList<ProtectObjectStorageInfo> nasIds = new ArrayList<ProtectObjectStorageInfo>();
        Set protectObjects = protectGroup.getPolist();
        if (!VerifyUtil.isEmpty((Collection)protectObjects)) {
            for (ProtectObject protectObject : protectObjects) {
                Set storageInfos = protectObject.getUsedStorageResourceSet();
                if (VerifyUtil.isEmpty((Collection)protectObjects)) continue;
                nasIds.addAll(storageInfos);
            }
        }
        return nasIds;
    }

    private NasFileSystem getRandomNasFileSytem(List<ProtectObjectStorageInfo> storageInfos) {
        Iterator<ProtectObjectStorageInfo> iterator = storageInfos.iterator();
        if (iterator.hasNext()) {
            ProtectObjectStorageInfo info = iterator.next();
            ArrayList<String> resourceIds = new ArrayList<String>();
            resourceIds.add(info.getResourceId());
            List fileSystemList = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(info.getResourceProviderSN(), resourceIds, NasFileSystem.class);
            this.checkEmpty(fileSystemList, "fileSystemList is empty");
            NasFileSystem fileSystem = (NasFileSystem)CommonUtil.getFirstElement((Collection)fileSystemList);
            return fileSystem;
        }
        logger.error((Object)"getRandomNasFileSytem failed");
        throw new LegoCheckedException(1073947393L);
    }

    protected boolean checkIsNasType(ProtectGroup pg) {
        ProtectObject po = (ProtectObject)CommonUtil.getFirstElement((Collection)pg.getPolist());
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            logger.error((Object)("usedStorageResourceSet is empty! pgName : " + pg.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)usedStorageResourceSet);
        if (VerifyUtil.isEmpty((Object)posi.getResourceType())) {
            logger.error((Object)("posi.getResourceType() is empty! DeviceName : " + posi.getDeviceName()));
            throw new LegoCheckedException(1073947393L);
        }
        return DrmEnumDefine.ResourceTypeE.NAS.getValue() == posi.getResourceType().intValue();
    }

    private ReplicationPair getOtherSiteRepPair(Map<String, VstoreHyperMetroPair> vstoreHyperMetroPairMap, String srcDevSn) {
        VstoreHyperMetroPair pair = vstoreHyperMetroPairMap.get(srcDevSn);
        String vstoreId = pair.getLocalVstoreId();
        StorageResourceServiceRouter router = StorageResourceServiceRouter.getInstance();
        List nasFileSystemList = router.getFileSystemByVstore(srcDevSn, vstoreId);
        this.checkEmpty(nasFileSystemList, "find other site nasfileSystem failed, srcDevSn:" + srcDevSn + " vstoreId:" + vstoreId);
        for (StorageResource storageResource : nasFileSystemList) {
            if (!storageResource.getDevSn().equals(srcDevSn)) continue;
            List<ReplicationPair> pairList = this.getPairsByNas(storageResource.getDevSn(), storageResource.getResourceId());
            return (ReplicationPair)CommonUtil.getFirstElement(pairList);
        }
        logger.error((Object)("getOtherSiteHyperVault failed.dev:" + srcDevSn + " vstoreId:" + vstoreId));
        throw new LegoCheckedException(1073947393L);
    }

    protected Map<String, String> getVstoreHyperPairList(String vStorePairId, String devSn, Map<String, VstoreHyperMetroPair> vstoreHyperMetroPairMap) {
        HashMap<String, String> snMap = new HashMap<String, String>();
        StorageResourceServiceRouter router = StorageResourceServiceRouter.getInstance();
        VstoreHyperMetroPair vstoreHmPair = router.getVstoreHyperMetroPairByVstorePairId(devSn, vStorePairId);
        this.checkEmpty(vstoreHmPair, "vstoreHmPair is null!");
        vstoreHyperMetroPairMap.put(devSn, vstoreHmPair);
        Site site = this.getSiteByDeviceSN(devSn);
        if (null == site) {
            logger.error((Object)("Site is null, devSn=" + devSn));
            throw new LegoCheckedException(1073947393L);
        }
        List list = router.getVstoreHyperPair(site.getServerUuid(), vstoreHmPair);
        this.checkEmpty(list, "List<VstoreHyperMetroPair> is empty!");
        String otherSn = this.getVestorePairDevSn((VstoreHyperMetroPair)CommonUtil.getFirstElement((Collection)list));
        vstoreHyperMetroPairMap.put(otherSn, (VstoreHyperMetroPair)CommonUtil.getFirstElement((Collection)list));
        snMap.put(devSn, otherSn);
        snMap.put(otherSn, devSn);
        return snMap;
    }

    protected void checkEmpty(Collection<?> collection, String msg) {
        if (VerifyUtil.isEmpty(collection)) {
            logger.error((Object)msg, 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void checkEmpty(Object str, String msg) {
        if (VerifyUtil.isEmpty((Object)str)) {
            logger.error((Object)msg, 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void checkEmpty(Object obj, String msg, BatchOperation batchOperation) {
        if (VerifyUtil.isEmpty((Object)obj)) {
            logger.error((Object)msg, 90160758784001L);
            batchOperation.setErrorCode(1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }
}

