/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.path.builder.ArraySanAirGapProtectionPath;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ArraySanHyperMetroAsyncAirGapProtectionPath
extends ArraySanAirGapProtectionPath {
    private static final Log LOGGER = LogFactory.getInstance(ArraySanHyperMetroAsyncAirGapProtectionPath.class);
    private static final String SRC_DEVICE_SN = "SRC_DEVICE_SN";
    private static final String TARGET_DEVICE_SN = "TARGET_DEVICE_SN";
    private static final String SRC_STANDBY_DEVICE_SN = "SRC_STANDBY_DEVICE_SN";
    private static final String PROTECT_GROUP = "PROTECT_GROUP";
    private static final String UNKNOWN = "UNKNOWN";

    @Override
    public int getPolicyTemplateType() {
        return 48;
    }

    @Override
    protected void initData(ExecutionContext context, ProtectGroup protectGroup) {
        context.setAttribute(PROTECT_GROUP, (Object)protectGroup);
        super.initData(context, protectGroup);
    }

    @Override
    protected String getSiteRelation(ExecutionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getAttribute(PROTECT_GROUP, ProtectGroup.class);
        StringBuilder siteRelationStr = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder("pgName:").append(protectGroup.getName());
        List<ProtectGroupReplica> protectGroupReplicaList = protectGroup.getReplicaList().stream().filter(e -> e.getType() == 2).collect(Collectors.toList());
        try {
            BatchOperation batchOperation = this.getBatchOperation(context);
            ArrayList rrbs = new ArrayList();
            protectGroupReplicaList.forEach(e -> rrbs.addAll(protectGroup.getReplicationRelationBos(e.getReplicas())));
            ReplicationRelationBo normalBo = rrbs.stream().filter(this::isNormalReplication).findFirst().orElseThrow(() -> this.setErrorMsg("Dr air gap's normal replication is null! errorMsg:" + errorMsg, batchOperation));
            ReplicationRelationBo standbyBo = rrbs.stream().filter(e -> !this.isNormalReplication((ReplicationRelationBo)e) && e.getTgtLuns().containsValue(normalBo.getTgtLuns().values().iterator().next())).findFirst().orElseThrow(() -> this.setErrorMsg("Dr air gap's standby replication is null! errorMsg:" + errorMsg, batchOperation));
            Site standbySrcSite = this.getSiteByStorageSn(standbyBo.getSrcDeviceSn());
            siteRelationStr.append(standbySrcSite == null ? UNKNOWN : standbySrcSite.getName()).append(" -- ");
            context.setAttribute(SRC_STANDBY_DEVICE_SN, (Object)standbyBo.getSrcDeviceSn());
            Site srcSite = this.getSiteByStorageSn(normalBo.getSrcDeviceSn());
            context.setAttribute(SRC_DEVICE_SN, (Object)normalBo.getSrcDeviceSn());
            siteRelationStr.append(srcSite == null ? UNKNOWN : srcSite.getName()).append(" -(normal)-> ");
            Site targetSite = this.getSiteByStorageSn(normalBo.getTgtDeviceSn());
            context.setAttribute(TARGET_DEVICE_SN, (Object)normalBo.getTgtDeviceSn());
            siteRelationStr.append(targetSite == null ? "" : targetSite.getName()).append("\n");
            Site standbyTargetSite = this.getSiteByStorageSn(standbyBo.getTgtDeviceSn());
            siteRelationStr.append(standbySrcSite == null ? UNKNOWN : standbySrcSite.getName()).append(" -(standby)-> ").append(standbyTargetSite == null ? "" : standbyTargetSite.getName());
        }
        catch (LegoCheckedException e2) {
            LOGGER.error((Object)"Build site relation error, msg :%s, ex :%s ", new Object[]{errorMsg, ExceptionUtil.getErrorMessage((Throwable)e2)});
        }
        catch (Exception e3) {
            LOGGER.error((Object)"Build site relation error, msg :%s, ex :%s ", new Object[]{errorMsg, ExceptionUtil.getErrorMessage((Throwable)e3), 90160758787071L});
        }
        return siteRelationStr.toString();
    }

    private LegoCheckedException setErrorMsg(String msg, BatchOperation batchOperation) {
        LOGGER.error((Object)msg, 90160758784001L);
        batchOperation.setErrorCode(1073947393L);
        return new LegoCheckedException(1073947393L);
    }

    private boolean isNormalReplication(ReplicationRelationBo bo) {
        IRecoveryProcessBaseHandler recoveryProcessBaseHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        if (!(recoveryProcessBaseHandler instanceof IRecoveryProcessHandler)) {
            LOGGER.error((Object)"Can not get the recovery process base handler.");
            throw new LegoCheckedException(1073947395L);
        }
        IRecoveryProcessHandler recoveryProcessHandler = (IRecoveryProcessHandler)recoveryProcessBaseHandler;
        List targetLuns = recoveryProcessHandler.querySyncStatus(bo.getSrcDeviceSn(), bo.getTgtDeviceSn(), bo.getReplicationId(), bo.isConsistentGroup());
        for (ReplicationTargetLun repTargetLun : targetLuns) {
            if (repTargetLun.getPairStatus().intValue() != XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue()) continue;
            LOGGER.info((Object)"This is the slave replication, replication pair id=%s.", new Object[]{bo.getReplicationId()});
            return false;
        }
        return true;
    }

    @Override
    protected List<String> getProductLunNamesAndIp(ProtectObjectReplica protectobjectreplica, Map<String, String> proLunInfo, ExecutionContext context) {
        ArrayList<String> tgtLunIds = new ArrayList<String>();
        String tgtDevSn = null;
        ProtectGroupReplica replica = protectobjectreplica.getPgReplica();
        for (ProtectObjectReplica por : replica.getReplicas()) {
            for (RelicaStorageInfo rsi : por.getStorageInfos()) {
                tgtLunIds.add(rsi.getStorageId());
                tgtDevSn = rsi.getStorageProviderSN();
            }
        }
        ArrayList<String> listRsInfoId = new ArrayList<String>();
        DrmEnumDefine.ResourceTypeE resourceType = this.getResourceTypeByPgReplica();
        String standbyDevSn = (String)context.getAttribute(SRC_STANDBY_DEVICE_SN, String.class);
        String srcDevSn = (String)context.getAttribute(SRC_DEVICE_SN, String.class);
        if (!VerifyUtil.isEmpty(tgtDevSn)) {
            List pairs = this.getStorageService().getReplicationPairsByResourceIds(tgtDevSn, tgtLunIds, false, Integer.valueOf(resourceType.getValue()));
            for (RelicaStorageInfo relicastorageinfo : protectobjectreplica.getStorageInfos()) {
                ReplicationPair standbyPair = pairs.stream().filter(e -> standbyDevSn.equals(e.getSrcDevSN()) && ((ReplicationTargetLun)e.getRepTgtLuns().get(0)).getTgtLunId().equals(relicastorageinfo.getStorageId())).findFirst().orElseThrow(() -> new LegoCheckedException(201L));
                ReplicationPair srcPair = pairs.stream().filter(e -> srcDevSn.equals(e.getSrcDevSN()) && ((ReplicationTargetLun)e.getRepTgtLuns().get(0)).getTgtLunId().equals(relicastorageinfo.getStorageId())).findFirst().orElseThrow(() -> new LegoCheckedException(201L));
                String srcLunName = srcPair.getSrcLunName();
                String standbyLunName = standbyPair.getSrcLunName();
                String result = standbyLunName + "(" + UNKNOWN + ") -- " + srcLunName + "(" + UNKNOWN + ")";
                proLunInfo.put(relicastorageinfo.getId(), result);
                listRsInfoId.add(relicastorageinfo.getId());
            }
        }
        return listRsInfoId;
    }
}

