/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class PgReplicaValidityComparator
implements Comparator<ProtectGroupReplica>,
Serializable {
    private static final long serialVersionUID = 7516102339726592274L;
    private static final Log logger = LogFactory.getInstance(PgReplicaValidityComparator.class);
    private static final Map<Integer, Integer> statusValues = new HashMap<Integer, Integer>();
    private final long curTime = System.currentTimeMillis();

    @Override
    public int compare(ProtectGroupReplica pgReplica0, ProtectGroupReplica pgReplica1) {
        long timeWeight1;
        int status1;
        int status0 = this.getReplicaStatus(pgReplica0);
        int result1 = status0 - (status1 = this.getReplicaStatus(pgReplica1));
        if (0 != result1) {
            return result1;
        }
        long timeWeight0 = this.getWeightByTime(pgReplica0);
        long result2 = timeWeight0 - (timeWeight1 = this.getWeightByTime(pgReplica1));
        if (0L < result2) {
            return -1;
        }
        if (0L > result2) {
            return 1;
        }
        return 0;
    }

    private int getReplicaStatus(ProtectGroupReplica pgReplica) {
        Integer statusInteger = statusValues.get(pgReplica.getStatus());
        if (null == statusInteger) {
            logger.error((Object)("unknown protectGroupReplica status!status:" + pgReplica.getStatus()));
            throw new LegoCheckedException(1073947393L);
        }
        int status = statusInteger;
        return status;
    }

    private long getWeightByTime(ProtectGroupReplica pgReplica) {
        if (VerifyUtil.isEmpty((String)pgReplica.getTimeStamp())) {
            return Long.MIN_VALUE;
        }
        return this.curTime - NumberUtil.convertToLong((Object)pgReplica.getTimeStamp());
    }

    static {
        statusValues.put(DrmEnumDefine.ReplicaStatus.ERROR_STATUS.getValue(), 1);
        statusValues.put(DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS.getValue(), 2);
        statusValues.put(DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue(), 3);
    }
}

