/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.Array4DCCascadeAsyncAsyncBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.Array4DCCascadeSyncAsyncBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySanHyperVaultBuilder;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class Array4DCCascadeSyncAsyncVaultBuilder
extends ArraySanHyperVaultBuilder {
    private static final Log logger = LogFactory.getInstance(Array4DCCascadeAsyncAsyncBuilder.class);
    private Array4DCCascadeSyncAsyncBuilder array4DCCascadeSyncAsyncBuilder;

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        this.buildReplica(protectGroup, (IReplicaBuilder)this.array4DCCascadeSyncAsyncBuilder);
    }

    @Override
    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        return super.beforeDeleteProtectGroup(protectGroup);
    }

    public Array4DCCascadeSyncAsyncBuilder getArray4DCCascadeSyncAsyncBuilder() {
        return this.array4DCCascadeSyncAsyncBuilder;
    }

    public void setArray4DCCascadeSyncAsyncBuilder(Array4DCCascadeSyncAsyncBuilder array4DCCascadeSyncAsyncBuilder) {
        this.array4DCCascadeSyncAsyncBuilder = array4DCCascadeSyncAsyncBuilder;
    }

    @Override
    public int getType() {
        return 40;
    }

    @Override
    public Map<Integer, String> getProtectedDeviceSn(ProtectGroup protectGroup) {
        List pgReplicaList = protectGroup.listAllReplicatonRepica();
        if (CollectionUtils.isEmpty((Collection)pgReplicaList)) {
            logger.error((Object)"Not find any replica in ProtectGroup: %s", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(1073947394L);
        }
        return this.getPgLocationMap(protectGroup);
    }

    private Map<Integer, String> getPgLocationMap(ProtectGroup protectGroup) {
        ProtectGroupReplica replicaAToB = Array4DCCascadeSyncAsyncVaultBuilder.getPgReplicaByLocation(protectGroup, DrmEnumDefine.ProtectLocation.A_B.getValue());
        ProtectGroupReplica replicaBToC = Array4DCCascadeSyncAsyncVaultBuilder.getPgReplicaByLocation(protectGroup, DrmEnumDefine.ProtectLocation.B_C.getValue());
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(DrmEnumDefine.ProtectLocation.A_A.getValue(), replicaAToB.getProductArray());
        result.put(DrmEnumDefine.ProtectLocation.A_B.getValue(), replicaAToB.getRecoveryArray());
        result.put(DrmEnumDefine.ProtectLocation.B_C.getValue(), replicaBToC.getRecoveryArray());
        Set<String> devSnSet = this.get4DCSitesDevSnSet(protectGroup);
        if (CollectionUtils.isEmpty(devSnSet)) {
            logger.error((Object)"Get devSn set is empty!");
            throw new LegoCheckedException(2117645L, "devSn set is empty.");
        }
        for (String tmpSn : devSnSet) {
            if (result.containsValue(tmpSn)) continue;
            result.put(DrmEnumDefine.ProtectLocation.B_B.getValue(), tmpSn);
            break;
        }
        return result;
    }

    private Set<String> get4DCSitesDevSnSet(ProtectGroup protectGroup) {
        HashSet<String> devSnSet = new HashSet<String>();
        if (this.checkIfProductSiteIsHyperMetroSite(protectGroup)) {
            List<StorageResource> resources = this.get4DCStorageResource(protectGroup);
            if (!CollectionUtils.isEmpty(resources)) {
                resources.forEach(resource -> devSnSet.add(resource.getDevSn()));
            }
            return devSnSet;
        }
        List<StorageResource> allStorageResources = this.getStorageResourcesNotInHmSite(protectGroup);
        if (!CollectionUtils.isEmpty(allStorageResources)) {
            allStorageResources.forEach(resource -> devSnSet.add(resource.getDevSn()));
        }
        return devSnSet;
    }

    private List<StorageResource> getStorageResourcesNotInHmSite(ProtectGroup protectGroup) {
        RelicaStorageInfo storageInfo = this.getReplicaStorageInfo(protectGroup);
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        Lun lun = storageService.getLunBySnAndLunId(storageInfo.getStorageProviderSN(), storageInfo.getStorageId());
        if (VerifyUtil.isEmpty((Object)lun)) {
            logger.error((Object)"Not find remote replica lun of pgName: %s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(2117645L, "Lun does not exist.");
        }
        return storageService.getStorageResourceByWwn(new String[]{lun.getWwn()});
    }

    private RelicaStorageInfo getReplicaStorageInfo(ProtectGroup protectGroup) {
        List remoteReplicas = protectGroup.listAllReplicatonRepica();
        Optional<ProtectGroupReplica> opt = remoteReplicas.stream().filter(replica -> replica.getProtectLocation() == DrmEnumDefine.ProtectLocation.A_B.getValue()).findFirst();
        if (!opt.isPresent()) {
            throw new LegoCheckedException(2117645L, "Not find replica.");
        }
        return this.getReplicaStorageInfo(opt.get());
    }

    private RelicaStorageInfo getReplicaStorageInfo(ProtectGroupReplica remoteReplica) {
        ProtectObjectReplica protectObjectReplica = (ProtectObjectReplica)remoteReplica.getReplicas().iterator().next();
        return (RelicaStorageInfo)protectObjectReplica.getStorageInfos().iterator().next();
    }

    protected boolean checkIfProductSiteIsHyperMetroSite(ProtectGroup protectGroup) {
        Set hmSites = protectGroup.getHyperMetroSiteIdSet();
        String productSiteId = protectGroup.getProductSiteId();
        return hmSites.contains(productSiteId);
    }

    private List<StorageResource> get4DCStorageResource(ProtectGroup protectGroup) {
        HashSet wwnSet = new HashSet();
        protectGroup.distinctStorageInfo().forEach(storage -> wwnSet.add(storage.getLunWWN()));
        return ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(wwnSet.toArray(new String[0]));
    }

    @Override
    public Map<String, List<ProtectObjectStorageInfo>> getAllStroageInfo(ProtectGroup protectGroup) {
        List<StorageResource> allStorageResources = this.get4DCStorageResource(protectGroup);
        HashMap<String, List<ProtectObjectStorageInfo>> storageMap = new HashMap<String, List<ProtectObjectStorageInfo>>();
        HashMap<String, ProtectObjectStorageInfo> storageInfoMap = new HashMap<String, ProtectObjectStorageInfo>();
        protectGroup.distinctStorageInfo().forEach(poStorageInfo -> allStorageResources.forEach(storageResource -> {
            Lun lun = (Lun)storageResource;
            if (poStorageInfo.getLunWWN().equals(lun.getWwn())) {
                ProtectObjectStorageInfo info = new ProtectObjectStorageInfo();
                info.setResourceId(lun.getResourceId());
                info.setResourceProviderSN(lun.getDevSn());
                info.setArchiveLog(poStorageInfo.getArchiveLog());
                info.setLunWWN(poStorageInfo.getLunWWN());
                storageInfoMap.put(poStorageInfo.getLunWWN(), info);
                ProtectGroupUtil.putObjectToMap((Map)storageMap, (Object)info.getResourceProviderSN(), (Object)info);
            }
        }));
        logger.debug((Object)"set hyper metro storage info success.");
        this.setReplicaInfoToStorageMap(protectGroup, storageInfoMap, storageMap);
        if (this.checkIfProductSiteIsHyperMetroSite(protectGroup)) {
            return storageMap;
        }
        List<StorageResource> replenishStorageResource = this.getStorageResourcesNotInHmSite(protectGroup);
        this.replenishStorageInfo(storageMap, replenishStorageResource, protectGroup);
        return storageMap;
    }

    private void replenishStorageInfo(Map<String, List<ProtectObjectStorageInfo>> storageMap, List<StorageResource> allStorageResources, ProtectGroup protectGroup) {
        HashMap<String, List<StorageResource>> wwnMap = new HashMap<String, List<StorageResource>>();
        for (StorageResource resource : allStorageResources) {
            String tmpWwn = ((Lun)resource).getWwn();
            List list = wwnMap.computeIfAbsent(tmpWwn, k -> new ArrayList());
            list.add(resource);
            wwnMap.put(tmpWwn, list);
        }
        RelicaStorageInfo storageInfo = this.getReplicaStorageInfo(protectGroup);
        String devSn = storageInfo.getStorageProviderSN();
        for (StorageResource resource : allStorageResources) {
            if (resource.getDevSn().equals(devSn)) continue;
            ProtectObjectStorageInfo info = new ProtectObjectStorageInfo();
            info.setResourceProviderSN(resource.getDevSn());
            info.setResourceId(resource.getResourceId());
            info.setLunWWN(((Lun)resource).getWwn());
            Optional<ProtectObjectStorageInfo> opt = this.getRemotePoStorageInfo(storageMap, wwnMap, devSn, resource);
            opt.ifPresent(protectObjectStorageInfo -> info.setArchiveLog(protectObjectStorageInfo.getArchiveLog()));
            ProtectGroupUtil.putObjectToMap(storageMap, (Object)resource.getDevSn(), (Object)info);
        }
    }

    private Optional<ProtectObjectStorageInfo> getRemotePoStorageInfo(Map<String, List<ProtectObjectStorageInfo>> map, Map<String, List<StorageResource>> wwnMap, String remoteDevSn, StorageResource resource) {
        List<ProtectObjectStorageInfo> storageInfos = map.get(remoteDevSn);
        List<StorageResource> list = wwnMap.get(((Lun)resource).getWwn());
        if (CollectionUtils.isEmpty(storageInfos) || CollectionUtils.isEmpty(list)) {
            return Optional.empty();
        }
        StorageResource hmStorageResource = null;
        for (StorageResource storageResource : list) {
            if (resource.getDevSn().equals(storageResource.getDevSn())) continue;
            hmStorageResource = storageResource;
        }
        for (ProtectObjectStorageInfo storageInfo : storageInfos) {
            if (storageInfo.getLunWWN().equals(((Lun)resource).getWwn())) {
                return Optional.of(storageInfo);
            }
            if (hmStorageResource == null || !storageInfo.getResourceProviderSN().equals(hmStorageResource.getDevSn()) || !storageInfo.getResourceId().equals(hmStorageResource.getResourceId())) continue;
            return Optional.of(storageInfo);
        }
        return Optional.empty();
    }

    protected void setReplicaInfoToStorageMap(ProtectGroup protectGroup, Map<String, ProtectObjectStorageInfo> storageInfoMap, Map<String, List<ProtectObjectStorageInfo>> map) {
        ProtectGroupReplica replicaAToB = Array4DCCascadeSyncAsyncVaultBuilder.getPgReplicaByLocation(protectGroup, DrmEnumDefine.ProtectLocation.A_B.getValue());
        ProtectGroupReplica replicaBToC = Array4DCCascadeSyncAsyncVaultBuilder.getPgReplicaByLocation(protectGroup, DrmEnumDefine.ProtectLocation.B_C.getValue());
        this.putStorageInfo(replicaAToB, map, storageInfoMap);
        this.putStorageInfo(replicaBToC, map, storageInfoMap);
    }

    @Override
    protected void putStorageInfo(ProtectGroupReplica replica, Map<String, List<ProtectObjectStorageInfo>> map, Map<String, ProtectObjectStorageInfo> storageInfoMap) {
        replica.getReplicas().forEach(poReplica -> poReplica.getStorageInfos().forEach(storageInfo -> {
            String replicaKey = storageInfo.getProtectObjectStorageWwn();
            ProtectObjectStorageInfo info = (ProtectObjectStorageInfo)storageInfoMap.get(replicaKey);
            if (info != null) {
                this.convertReplicaInfoToStorageInfo(map, info, (RelicaStorageInfo)storageInfo);
            }
        }));
    }
}

