/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySanAirGapSnapshotBuilder;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySanHyperMetroAsyncAirGapSnapshotFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ArraySanHyperMetroAsyncAirGapSnapshotBuilder
extends ArraySanAirGapSnapshotBuilder {
    private static final Log LOGGER = LogFactory.getInstance(ArraySanHyperMetroAsyncAirGapSnapshotBuilder.class);
    private ArraySanHyperMetroAsyncAirGapSnapshotFilter arraySanHyperMetroAsyncAirGapSnapshotFilter;

    @Override
    public int getType() {
        return 48;
    }

    @Override
    protected <T> T getAttrFromFilterContext(String key) {
        return (T)this.arraySanHyperMetroAsyncAirGapSnapshotFilter.getFilterContext().get(key);
    }

    public void setArraySanHyperMetroAsyncAirGapSnapshotFilter(ArraySanHyperMetroAsyncAirGapSnapshotFilter arraySanHyperMetroAsyncAirGapSnapshotFilter) {
        this.arraySanHyperMetroAsyncAirGapSnapshotFilter = arraySanHyperMetroAsyncAirGapSnapshotFilter;
    }

    @Override
    public ArraySanHyperMetroAsyncAirGapSnapshotFilter getAirGapFilter() {
        return this.arraySanHyperMetroAsyncAirGapSnapshotFilter;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        super.buildReplica(protectGroup);
    }

    @Override
    public void createReplica(ProtectGroup protectGroup, List<ReplicationPair> pairs) {
        Map<String, List<ReplicationPair>> replicationPairListMap = pairs.stream().collect(Collectors.groupingBy(ReplicationRelation::getSrcDevSN));
        if (replicationPairListMap.size() != 2) {
            LOGGER.error((Object)"Pairs in 3dc air gap must have 2 source sites, pg name=%s.", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(2117645L);
        }
        Iterator<Map.Entry<String, List<ReplicationPair>>> entryIterator = replicationPairListMap.entrySet().iterator();
        int index = 0;
        while (entryIterator.hasNext()) {
            List<ReplicationPair> replicationPairList = entryIterator.next().getValue();
            ReplicationPair tempPair = replicationPairList.get(0);
            this.getBuilderContext().put("REPLICA_INDEX", index + 1);
            this.getBuilderContext().put("PROTECT_TYPE", tempPair.getReplicationMode());
            this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.ProtectLocation.A_B.getValue());
            this.getBuilderContext().put("SRC_DEVICE", tempPair.getSrcDevSN());
            HashMap<String, ReplicationPair> repMap = new HashMap<String, ReplicationPair>();
            for (ReplicationPair replicationPair : replicationPairList) {
                ReplicationTargetLun tgtLun = (ReplicationTargetLun)replicationPair.getRepTgtLuns().get(0);
                repMap.put(tgtLun.getTgtLunId(), replicationPair);
            }
            this.generateReplicaByPair(protectGroup, tempPair.getReplicationMode(), repMap);
            ++index;
        }
    }
}

