/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.calculator.RPOUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplicationAlarmInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractReplicaBuilder;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.TryCatchThrowable;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ArraySyncReplicationBuilder
extends AbstractReplicaBuilder {
    protected static final String LUNID_TO_PAIR = "LUNID_TO_PAIR";
    protected static final String TGT_DEVSN_PREFIX = "TGT_DEVSN_PREFIX";
    protected static final String DEVSN_URL = "/{devSn}/replicationpairs?resIds={resIds}&isPrimary={isPrimary}";
    private static final Log logger = LogFactory.getInstance(ArraySyncReplicationBuilder.class);

    public void buildReplica(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupUtil.clearRemoteReplicas((Set)protectGroup.getReplicaList());
        String srcDevSN = this.getSrcDevSN(protectGroup);
        String productSite = protectGroup.getProductSiteId();
        protectGroup.setPgReplicaIndex(1);
        protectGroup.setProductSiteId(productSite);
        if (VerifyUtil.isEmpty((String)srcDevSN)) {
            logger.error((Object)"product array is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        this.getBuilderContext().put("REPLICA_INDEX", 1);
        this.getBuilderContext().put("PROTECT_TYPE", this.getReplicationType());
        this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.ProtectLocation.A_B.getValue());
        this.getBuilderContext().put("SRC_DEVICE", srcDevSN);
        ExecutionContext context = this.initData(protectGroup);
        ProtectGroupReplica protectGroupReplica = this.getProtectGroupReplica(protectGroup, context);
        protectGroupReplica.setStatus(1 == this.getReplicationType() ? DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue() : DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS.getValue());
        protectGroup.getReplicaList().add(protectGroupReplica);
    }

    protected ExecutionContext initData(ProtectGroup protectGroup) {
        ExecutionContext context = new ExecutionContext();
        HashSet<String> resourceIdSet = new HashSet<String>();
        HashMap<String, Lun> id2LunMap = new HashMap<String, Lun>();
        for (ProtectObject po : protectGroup.getPolist()) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo poStorageInfo : po.getUsedStorageResourceSet()) {
                if (poStorageInfo.getResourceType().intValue() == DrmEnumDefine.ResourceTypeE.NAS.getValue()) continue;
                String resourceId = poStorageInfo.getResourceId();
                resourceIdSet.add(resourceId);
                String devSn = poStorageInfo.getResourceProviderSN();
                Lun lun = new Lun();
                lun.setDevSn(devSn);
                lun.setResourceId(resourceId);
                id2LunMap.put(resourceId, lun);
            }
        }
        Map<String, List<ReplicationPair>> id2PairMap = this.getLunIdPairMap(resourceIdSet, new ArrayList<Lun>(id2LunMap.values()));
        IReplicaService repService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        List pgReplicas = repService.queryProtectGroupReplicaByGroup(protectGroup.getUuid(), null, false);
        boolean existProtectGroupReplica = !VerifyUtil.isEmpty((Collection)pgReplicas);
        this.filter3DcCascadePairMap(existProtectGroupReplica, protectGroup.getPoType(), this.getInt("PROTECT_LOCATION"), protectGroup.getTemplate().getType(), id2PairMap);
        context.setAttribute(LUNID_TO_PAIR, id2PairMap);
        return context;
    }

    protected List<ReplicationPair> getPairsByResources(Integer resourceType, StorageResource ... resources) {
        return this.getPairs(resourceType, resources);
    }

    protected List<ReplicationPair> getPairsByLun(Lun ... luns) {
        return this.getPairsByResources(DrmEnumDefine.ResourceTypeE.LUN.getValue(), (StorageResource[])luns);
    }

    protected List<ReplicationPair> getPairByNasList(List<NasFileSystem> nasFileSystems) {
        return this.getPairsByResources(DrmEnumDefine.ResourceTypeE.NAS.getValue(), (StorageResource[])nasFileSystems.toArray(new NasFileSystem[nasFileSystems.size()]));
    }

    protected ExecutionContext initDataBC(ProtectGroup protectGroup) {
        ExecutionContext context = new ExecutionContext();
        HashSet<String> resourceIdSet = new HashSet<String>();
        HashMap<String, Lun> id2LunMap = new HashMap<String, Lun>();
        for (ProtectObject po : protectGroup.getPolist()) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo poStorageInfo : po.getUsedStorageResourceSet()) {
                if (poStorageInfo.getResourceType().intValue() == DrmEnumDefine.ResourceTypeE.NAS.getValue()) continue;
                String resourceId = poStorageInfo.getResourceId();
                String devSn = poStorageInfo.getResourceProviderSN();
                Lun lun = this.getTgtLunBySrcLun(devSn, resourceId);
                if (null == lun) {
                    logger.error((Object)("lun is empty!devSn:" + devSn + ",resourceId:" + resourceId));
                    throw new LegoCheckedException(1073948453L);
                }
                resourceIdSet.add(lun.getResourceId());
                id2LunMap.put(lun.getResourceId(), lun);
            }
        }
        Map<String, List<ReplicationPair>> id2PairMap = this.getLunIdPairMap(resourceIdSet, new ArrayList<Lun>(id2LunMap.values()));
        context.setAttribute(LUNID_TO_PAIR, id2PairMap);
        return context;
    }

    public int getType() {
        logger.debug((Object)"get Type");
        return 0;
    }

    protected int getReplicationType() {
        logger.debug((Object)"get ReplicationType");
        return 1;
    }

    protected ProtectGroupReplica getProtectGroupReplica(ProtectGroup protectGroup, ExecutionContext context) {
        logger.debug((Object)"get ProtectGroupReplica.");
        ProtectGroupReplica protectGroupReplica = new ProtectGroupReplica();
        protectGroupReplica.setId(UUIDGenerator.getUUID());
        protectGroupReplica.setName("REMOTEREPLICA-" + protectGroup.getName() + "-" + this.getString("REPLICA_INDEX"));
        protectGroupReplica.setProductArray(this.getString("SRC_DEVICE"));
        protectGroupReplica.setType(this.getInt("PROTECT_TYPE"));
        protectGroupReplica.setIndex(this.getInt("REPLICA_INDEX"));
        protectGroupReplica.setPg(protectGroup);
        protectGroupReplica.setProtectLocation(this.getInt("PROTECT_LOCATION"));
        this.createProtectObjectReplica(protectGroup, protectGroupReplica, context);
        return protectGroupReplica;
    }

    protected void createProtectObjectReplica(ProtectGroup protectGroup, ProtectGroupReplica protectGroupReplica, ExecutionContext context) {
        logger.debug((Object)"create ProtectObjectReplica");
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            ProtectObjectReplica protectObjectReplica = new ProtectObjectReplica();
            protectObjectReplica.setId(UUIDGenerator.getUUID());
            protectObjectReplica.setPoId(protectObject.getUuid());
            protectObjectReplica.setPgReplica(protectGroupReplica);
            this.generatePosi(this.getInt("PROTECT_LOCATION"), protectObject, protectObjectReplica, protectGroupReplica, context);
            protectGroupReplica.getReplicas().add(protectObjectReplica);
        }
    }

    protected void generatePosi(int protectLocation, ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, ProtectGroupReplica protectGroupReplica, ExecutionContext context) {
        logger.debug((Object)"generate Posi");
        for (ProtectObjectStorageInfo posi : protectObject.getUsedStorageResourceSet()) {
            Lun lunMo = new Lun();
            lunMo.setDevSn(posi.getResourceProviderSN());
            lunMo.setLunId(posi.getResourceId());
            this.generatePosiByLun(1, protectObjectReplica, protectGroupReplica, posi, lunMo, context);
        }
    }

    protected void generatePosiByLun(int type, ProtectObjectReplica protectObjectReplica, ProtectGroupReplica protectGroupReplica, ProtectObjectStorageInfo protectObjectStorageInfo, Lun lunMo, ExecutionContext context) {
        Map lunId2Pair = (Map)context.getAttribute(LUNID_TO_PAIR);
        if (null == lunId2Pair) {
            logger.warn((Object)("master lun(" + lunMo.getMoId() + ")'s ReplicationPair is empty."), 90160758786989L);
            throw new LegoCheckedException(1073948175L);
        }
        List pairs = (List)lunId2Pair.get(lunMo.getResourceId());
        if (VerifyUtil.isEmpty((Collection)pairs)) {
            logger.warn((Object)("master lun(" + lunMo.getMoId() + ")'s ReplicationPair is empty."), 90160758786989L);
            throw new LegoCheckedException(1073948175L);
        }
        this.generateRp(type, protectObjectReplica, protectObjectStorageInfo, pairs, protectGroupReplica, context);
    }

    protected List<ReplicationPair> getPairsByStorageResource(StorageResource resourceMo, Integer resourceType) {
        if (VerifyUtil.isEmpty((Object)resourceMo)) {
            logger.error((Object)"getPairsByLun error, lunMo is null.", 90160758787071L);
            return Collections.emptyList();
        }
        Site site = this.getSiteByDeviceSN(resourceMo.getDevSn());
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getPairsByLun error, site is null, deviceSN:" + resourceMo.getDevSn()), 90160758787071L);
            return Collections.emptyList();
        }
        ArrayList<String> resIds = new ArrayList<String>();
        resIds.add(resourceMo.getResourceId());
        return this.queryValidReplicationPairsBy(resourceMo.getDevSn(), resIds, true, resourceType);
    }

    protected void generateRp(int type, ProtectObjectReplica protectObjectReplica, ProtectObjectStorageInfo protectObjectStorageInfo, List<ReplicationPair> pairs, ProtectGroupReplica protectGroupReplica, ExecutionContext context) {
        boolean hasValidPair = false;
        for (ReplicationPair replicationPair : pairs) {
            if (type != replicationPair.getReplicationMode()) continue;
            for (ReplicationTargetLun replicationTargetLun : replicationPair.getRepTgtLuns()) {
                RemoteStorageReplica remoteStorageReplica = new RemoteStorageReplica();
                remoteStorageReplica.setId(UUIDGenerator.getUUID());
                remoteStorageReplica.setSrcStorageId(replicationPair.getSrcLunId());
                remoteStorageReplica.setSrcStorageProviderSN(replicationPair.getSrcDevSN());
                remoteStorageReplica.setStorageId(replicationTargetLun.getTgtLunId());
                remoteStorageReplica.setStorageProviderSN(replicationTargetLun.getTgtDevSN());
                remoteStorageReplica.setPoReplica(protectObjectReplica);
                remoteStorageReplica.setReplicationPairId(replicationPair.getReplicationId());
                remoteStorageReplica.setConsistentGroupId(this.getRemoteReplicaConsistentGroupId(context, replicationPair));
                remoteStorageReplica.setSynchronization(Boolean.valueOf(1 == replicationPair.getReplicationMode()));
                remoteStorageReplica.setProtectObjectStorageWwn(protectObjectStorageInfo.getLunWWN());
                if (!VerifyUtil.isEmpty((String)replicationPair.getVstorePairId()) && !replicationPair.getVstorePairId().startsWith("--")) {
                    remoteStorageReplica.setVstorePairId(replicationPair.getVstorePairId());
                }
                remoteStorageReplica.setDrRingId(replicationPair.getDrRingId());
                protectObjectReplica.getStorageInfos().add(remoteStorageReplica);
                protectGroupReplica.setRecoveryArray(replicationTargetLun.getTgtDevSN());
                String recoverySiteId = this.getRecoverySiteId(context, replicationTargetLun);
                protectGroupReplica.setRecoverySite(recoverySiteId);
                hasValidPair = true;
                this.getBuilderContext().put(this.getDevAndLun(replicationPair.getSrcDevSN(), String.valueOf(replicationPair.getSrcLunId())), this.getDevAndLun(replicationTargetLun.getTgtDevSN(), String.valueOf(replicationTargetLun.getTgtLunId())));
            }
        }
        if (!hasValidPair) {
            logger.error((Object)("the Lun(" + protectObjectStorageInfo.getResourceProviderSN() + ":" + protectObjectStorageInfo.getResourceId() + ") has not valid pair"), 90160758786989L);
            throw new LegoCheckedException(1073948175L);
        }
    }

    private String getRemoteReplicaConsistentGroupId(ExecutionContext context, ReplicationPair replicationPair) {
        Boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (!isVasa.booleanValue() || !VerifyUtil.isEmpty((String)replicationPair.getConsistentGroupId())) {
            return replicationPair.getConsistentGroupId();
        }
        logger.warn((Object)"ReplicationPair has no cgId: pairId=%s, cgId=%s, srcLunName=%s, createTime=%s", new Object[]{replicationPair.getReplicationId(), replicationPair.getConsistentGroupId(), replicationPair.getSrcLunName(), replicationPair.getCreateTime()});
        Map lunIdToPair = (Map)context.getAttribute(LUNID_TO_PAIR);
        if (lunIdToPair == null) {
            return "";
        }
        Collection values = lunIdToPair.values();
        for (List pairList : values) {
            Optional<ReplicationPair> optionalReplicationPair;
            if (VerifyUtil.isEmpty((Collection)pairList) || !(optionalReplicationPair = pairList.stream().filter(rp -> !VerifyUtil.isEmpty((String)rp.getConsistentGroupId()) && !"--".equals(rp.getConsistentGroupId())).findFirst()).isPresent()) continue;
            return optionalReplicationPair.get().getConsistentGroupId();
        }
        logger.warn((Object)("Can't find consistent group id: pair=" + replicationPair));
        return "";
    }

    private String getRecoverySiteId(ExecutionContext context, ReplicationTargetLun replicationTargetLun) {
        String tgtDevSnKey = TGT_DEVSN_PREFIX + replicationTargetLun.getTgtDevSN();
        String recoverySiteId = (String)context.getAttribute(tgtDevSnKey, String.class);
        if (null == recoverySiteId) {
            logger.debug((Object)"recoverySiteId is null!");
            recoverySiteId = this.getSiteBySn(replicationTargetLun.getTgtDevSN());
            context.setAttribute(tgtDevSnKey, (Object)recoverySiteId);
        }
        return recoverySiteId;
    }

    protected StorageResource checkStorageResourceExsist(String deviceId, String resId, DrmEnumDefine.ResourceTypeE type) {
        ArrayList<String> resIds = new ArrayList<String>();
        resIds.add(resId);
        List reses = this.getStorageService().getStorageResources(deviceId, resIds, type);
        if (null == reses || reses.isEmpty()) {
            logger.warn((Object)("can't get StorageResource info(" + deviceId + "_" + resId + ")."), 90160758786989L);
            throw new LegoCheckedException(1073948175L);
        }
        return (StorageResource)reses.get(0);
    }

    protected Lun getTgtLunBySrcLun(String deviceId, String lunId) {
        String tgtLunInfo = String.valueOf(this.getBuilderContext().get(this.getDevAndLun(deviceId, lunId)));
        if (!VerifyUtil.isEmpty((String)tgtLunInfo)) {
            Object[] info = tgtLunInfo.split(":");
            if (VerifyUtil.isEmpty((Object[])info) || info.length < 2) {
                return null;
            }
            Lun lun = new Lun();
            lun.setDevSn((String)info[0]);
            lun.setResourceId((String)info[1]);
            return lun;
        }
        logger.warn((Object)"result is null!");
        return null;
    }

    protected Site getSiteByDeviceSN(String deviceSN) {
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null != drResource) {
            return this.getSiteService().getSiteById(drResource.getSiteId());
        }
        logger.warn((Object)("result is null!deviceSN:" + deviceSN));
        return null;
    }

    protected Map<String, List<ReplicationPair>> getLunIdPairMap(Set<String> resIdSet, List<Lun> lunList) {
        if (VerifyUtil.isEmpty(resIdSet) || VerifyUtil.isEmpty(lunList)) {
            return new HashMap<String, List<ReplicationPair>>();
        }
        Lun[] lunArray = new Lun[lunList.size()];
        lunList.toArray(lunArray);
        long startTime = System.currentTimeMillis();
        List<ReplicationPair> pairList = this.getPairs(DrmEnumDefine.ResourceTypeE.LUN.getValue(), (StorageResource[])lunArray);
        logger.debug((Object)("get getPairsByLun. cost time:" + (System.currentTimeMillis() - startTime)));
        Map<String, List<ReplicationPair>> devicesnPairMap = this.classifyPairs(pairList);
        this.checkPairNum(resIdSet, lunList, devicesnPairMap);
        return devicesnPairMap;
    }

    private void checkPairNum(Set<String> resourceIdSet, List<Lun> lunList, Map<String, List<ReplicationPair>> devicesnPairMap) {
        if (devicesnPairMap.size() != lunList.size()) {
            logger.error((Object)("Some luns not exist replication pair!lun size:" + lunList.size() + ",devicesnPairMap size:" + devicesnPairMap.size() + ". lunIds:" + resourceIdSet + ", devicesnPairMap lunIds:" + devicesnPairMap.keySet()));
            throw new LegoCheckedException(1073948175L);
        }
    }

    protected List<ReplicationPair> getPairs(Integer resourceType, StorageResource ... resourcees) {
        if (VerifyUtil.isEmpty((Object[])resourcees)) {
            logger.error((Object)"resourcees is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        String deviceSn = "";
        ArrayList<String> resIDList = new ArrayList<String>();
        for (StorageResource res : resourcees) {
            deviceSn = res.getDevSn();
            resIDList.add(res.getResourceId());
        }
        Site site = this.getSiteByDeviceSN(deviceSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getPairs error, site is null, deviceSN:" + deviceSn));
            return Collections.emptyList();
        }
        return this.queryValidReplicationPairsBy(deviceSn, resIDList, true, resourceType);
    }

    private Map<String, List<ReplicationPair>> classifyPairs(List<ReplicationPair> replicationPairList) {
        if (VerifyUtil.isEmpty(replicationPairList)) {
            logger.warn((Object)"replicationPairList is empty.");
            throw new LegoCheckedException(1073948175L);
        }
        HashSet<ReplicationPair> replicationPairs = new HashSet<ReplicationPair>();
        replicationPairs.addAll(replicationPairList);
        HashMap<String, List<ReplicationPair>> lunId2PairMap = new HashMap<String, List<ReplicationPair>>();
        for (ReplicationPair replicationPair : replicationPairs) {
            List<ReplicationPair> pairs;
            String srcLunId = replicationPair.getSrcLunId();
            if (!lunId2PairMap.containsKey(srcLunId)) {
                pairs = new ArrayList<ReplicationPair>();
                pairs.add(replicationPair);
                lunId2PairMap.put(srcLunId, pairs);
                continue;
            }
            pairs = (List)lunId2PairMap.get(srcLunId);
            pairs.add(replicationPair);
        }
        return lunId2PairMap;
    }

    protected List<ReplicationPair> getReplicationPairsByResources(String devSn, Collection<String> resIdList, boolean isPrimary) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty(resIdList)) {
            logger.error((Object)"error param.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = this.getSiteByDeviceSN(devSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getPairsByLun error, site is null, deviceSN:" + devSn));
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String resId : resIdList) {
            builder.append(resId).append(";");
        }
        String resIds = builder.substring(0, builder.length() - 1);
        logger.debug((Object)("resIds:" + resIds));
        return this.getStorageService().getReplicationPairsByResourceIds(devSn, resIdList, isPrimary, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
    }

    public ProtectGroupReplicationAlarmInfo calculateProtectGroupReplicaStatus(ProtectGroupReplica pgReplica) {
        ProtectGroupReplicationAlarmInfo pgReplicationAlarmInfo = new ProtectGroupReplicationAlarmInfo();
        HashMap<String, Map<String, RemoteStorageReplica>> slaveSnLunIdAndReplica = new HashMap<String, Map<String, RemoteStorageReplica>>();
        Set poReplicas = pgReplica.getReplicas();
        for (ProtectObjectReplica poReplica : poReplicas) {
            Set rplicaInfos = poReplica.getStorageInfos();
            for (RelicaStorageInfo relicaStorageInfo : rplicaInfos) {
                if (!RemoteStorageReplica.class.isInstance(relicaStorageInfo)) continue;
                RemoteStorageReplica remoteReplica = (RemoteStorageReplica)RemoteStorageReplica.class.cast(relicaStorageInfo);
                String slaveDevASn = remoteReplica.getStorageProviderSN();
                HashMap<String, RemoteStorageReplica> slavelunIdAndReplica = (HashMap<String, RemoteStorageReplica>)slaveSnLunIdAndReplica.get(slaveDevASn);
                if (null == slavelunIdAndReplica) {
                    slavelunIdAndReplica = new HashMap<String, RemoteStorageReplica>();
                }
                slavelunIdAndReplica.put(remoteReplica.getStorageId(), remoteReplica);
                slaveSnLunIdAndReplica.put(slaveDevASn, slavelunIdAndReplica);
            }
        }
        if (slaveSnLunIdAndReplica.size() != 1) {
            logger.error((Object)"device sn must one.");
            throw new LegoCheckedException(1073947393L);
        }
        Map<String, ReplicationPair> slaveLunIdAndSlavePairs = this.getSlaveLunIdAndPairsMap(slaveSnLunIdAndReplica, false, pgReplica);
        this.calculateProtectGroupReplicaStatus(slaveLunIdAndSlavePairs, ((Map)CommonUtil.getFirstElement(slaveSnLunIdAndReplica.values())).values(), pgReplicationAlarmInfo);
        String devSn = pgReplicationAlarmInfo.getDeviceSn();
        if (VerifyUtil.isEmpty((String)devSn)) {
            return pgReplicationAlarmInfo;
        }
        StorageNE storage = (StorageNE)CommonDAOLocator.getMoDao().getMo(StorageNE.class, "sn", (Object)devSn);
        if (VerifyUtil.isEmpty((Object)storage)) {
            logger.error((Object)("storage is null, sn : " + devSn));
            throw new LegoCheckedException(2117645L);
        }
        pgReplicationAlarmInfo.setDeviceIp(storage.getLinkIp());
        return pgReplicationAlarmInfo;
    }

    private void calculateProtectGroupReplicaStatus(Map<String, ReplicationPair> pairIdAndPairs, Collection<RemoteStorageReplica> remoteStorageReplicas, ProtectGroupReplicationAlarmInfo pgReplicationAlarmInfo) {
        HashSet<String> errorStatusPgReplica = new HashSet<String>();
        for (RemoteStorageReplica remoteReplica : remoteStorageReplicas) {
            ReplicationPair tarPair = pairIdAndPairs.get(remoteReplica.getStorageId());
            ProtectGroupReplica pgReplica = remoteReplica.getPoReplica().getPgReplica();
            if (null == tarPair) {
                pgReplica.setTimeStamp("");
                pgReplica.setStatus(DrmEnumDefine.ReplicaStatus.ERROR_STATUS.getValue());
                errorStatusPgReplica.add(pgReplica.getId());
                pgReplicationAlarmInfo.addProtectGroupReplicaParam(remoteReplica);
                continue;
            }
            pgReplicationAlarmInfo.setProtectGroupReplicaId(pgReplica.getId());
            this.calculateProtectGroupReplicaStatusBytgtLun(tarPair, pgReplica, remoteReplica, pgReplicationAlarmInfo, errorStatusPgReplica);
        }
    }

    private void calculateProtectGroupReplicaStatusBytgtLun(ReplicationPair tarPair, ProtectGroupReplica pgReplica, RemoteStorageReplica remoteReplica, ProtectGroupReplicationAlarmInfo pgReplicaAlarmInfo, Set<String> errorStatusPgReplica) {
        for (ReplicationTargetLun tgtLun : tarPair.getRepTgtLuns()) {
            if (!tarPair.isNormal()) {
                pgReplicaAlarmInfo.addProtectGroupReplicaParam(remoteReplica, tarPair);
            }
            if (5 != tgtLun.getDataStatus() && tarPair.isAsync()) {
                if (pgReplica.getStatus() == DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue() || errorStatusPgReplica.contains(pgReplica.getId())) continue;
                Long activeTime = RPOUtil.getLastSuccessExcTime((ProtectGroup)pgReplica.getPg(), (String)pgReplica.getId());
                if (null != activeTime) {
                    pgReplica.setTimeStamp(String.valueOf(activeTime));
                    pgReplica.setStatus(DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue());
                    continue;
                }
                pgReplica.setStatus(DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS.getValue());
                continue;
            }
            if (5 != tgtLun.getDataStatus() && !tarPair.isAsync() && !errorStatusPgReplica.contains(pgReplica.getId())) {
                pgReplica.setStatus(DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue());
                continue;
            }
            pgReplica.setTimeStamp("");
            pgReplica.setStatus(DrmEnumDefine.ReplicaStatus.ERROR_STATUS.getValue());
            errorStatusPgReplica.add(pgReplica.getId());
            pgReplicaAlarmInfo.addProtectGroupReplicaParam(remoteReplica, tarPair);
        }
    }

    private Map<String, ReplicationPair> getSlaveLunIdAndPairsMap(final Map<String, Map<String, RemoteStorageReplica>> snLunIdAndReplica, final boolean isPrimary, ProtectGroupReplica pgReplica) {
        final boolean isAsyncReplica = pgReplica.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_B.getValue();
        final HashMap<String, ReplicationPair> slaveLunIdAndpairMap = new HashMap<String, ReplicationPair>();
        new TryCatchThrowable(){

            protected void doTry() {
                Set entries = snLunIdAndReplica.entrySet();
                for (Map.Entry entry : entries) {
                    Map siteAlunIdAndReplica;
                    String devASn = (String)entry.getKey();
                    List<ReplicationPair> tempList = ArraySyncReplicationBuilder.this.getReplicationPairsByResources(devASn, (siteAlunIdAndReplica = (Map)entry.getValue()).keySet(), isPrimary);
                    if (VerifyUtil.isEmpty(tempList)) {
                        return;
                    }
                    this.updateSlaveLunIdAndpairMap(tempList);
                }
            }

            private void updateSlaveLunIdAndpairMap(List<ReplicationPair> tempList) {
                for (ReplicationPair replicationPair : tempList) {
                    if (replicationPair.isStandby() || (!isAsyncReplica || !replicationPair.isAsync()) && (isAsyncReplica || replicationPair.isAsync())) continue;
                    slaveLunIdAndpairMap.put(((ReplicationTargetLun)CommonUtil.getFirstElement((Collection)replicationPair.getRepTgtLuns())).getTgtLunId(), replicationPair);
                }
            }

            protected void doCatch(Throwable throwable) {
                logger.error((Object)"get pairs error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)throwable)});
            }
        }.run();
        return slaveLunIdAndpairMap;
    }
}

