/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.filter.Array4DCCascadeSyncAsyncFilter;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class Array4DCCascadeSyncAsyncVaultFilter
extends Array4DCCascadeSyncAsyncFilter {
    private static final Log logger = LogFactory.getInstance(Array4DCCascadeSyncAsyncVaultFilter.class);

    @Override
    public int getType() {
        return 40;
    }

    @Override
    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        List<ProtectLocationPath> paths = super.getProtectLocationPaths(protectObjects);
        HashSet pathSet = new HashSet();
        paths.forEach(path -> pathSet.add(path.getProtectedStorageSN()));
        List<StorageResource> resources = this.getPoStorageResource(protectObjects);
        if (CollectionUtils.isEmpty(resources) || resources.size() != 2) {
            logger.error((Object)"resources is empty or the size is not two!", 90160758786897L);
            return paths;
        }
        resources.forEach(storageResource -> {
            if (!pathSet.contains(storageResource.getDevSn())) {
                ProtectLocationPath path = new ProtectLocationPath();
                Site site = this.getSiteFromSn(storageResource.getDevSn());
                path.setProtectedSiteId(site.getSiteId());
                path.setProtectedSiteName(site.getName());
                path.setRecoverySiteId(site.getSiteId());
                path.setRecoverySiteName(site.getName());
                path.setProtectedStorageSN(storageResource.getDevSn());
                path.setRecoveryStorageSN(storageResource.getDevSn());
                path.setProtectLocation(DrmEnumDefine.ProtectLocation.B_B.getValue());
                path.setReplicationMode("");
                paths.add(path);
            }
        });
        return paths;
    }

    private List<StorageResource> getPoStorageResource(List<ProtectObject> protectObjects) {
        ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)protectObjects.iterator().next().getUsedStorageResourceSet().iterator().next();
        return ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{storageInfo.getLunWWN()});
    }

    protected boolean isSetPathExtend() {
        return true;
    }
}

