/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter.oracle;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.application.model.AppStorageInfo;
import com.huawei.ism.drm.application.model.ApplicationResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class OracleAllFlashFilter
extends ArraySyncReplicationFilter {
    public static final String SITE_A_SN = "siteASn";
    public static final String SITE_B_SN = "siteBSn";
    public static final String OCACLE_SITE_A = "OCACLE_SITE_A";
    public static final String OCACLE_SITE_B = "OCACLE_SITE_B";
    public static final String STAND_BY_HOSTSNS = "STAND_BY_HOSTSNS";
    public static final String REMOTE_PAIR_SRCLUNIDS = "REMOTE_PAIR_SRCLUNIDS";
    public static final String REMOTE_PAIR_TRGLUNIDS = "REMOTE_PAIR_TRGLUNIDS";
    public static final String DB_NAMES = "DB_NAMES";
    public static final String REDO_LUN_WWN = "REDO_LUN_WWN";
    public static final String REDO_BACK_UP_LUN_IDS = "REDO_BACK_UP_LUN_IDS";
    public static final String REDO = "REDO";
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashFilter.class);

    @Override
    public int getType() {
        return 47;
    }

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            LOGGER.warn((Object)"The parameter protectObjects is empty!");
            LOGGER.info((Object)"End %s", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            throw new LegoCheckedException(1073948191L);
        }
        LOGGER.info((Object)"Start %s isMatch", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        String arraySn = this.checkSameSrcDevice(protectObjects);
        Site site = this.getSiteFromSn(arraySn);
        if (VerifyUtil.isEmpty((Object)site)) {
            LOGGER.warn((Object)"Can't get site by deviceSN: %s", new Object[]{arraySn});
            throw new LegoCheckedException(1073948449L);
        }
        this.getFilterContext().clear();
        return this.isMatchByLocation(DrmEnumDefine.ProtectLocation.A_B.getValue(), protectObjects);
    }

    protected boolean isMatchByLocation(int locationType, List<ProtectObject> protectObjects) {
        boolean isMatch;
        this.getLunTgtDevs().clear();
        this.getLunTgtdevSn().clear();
        ExecutionContext context = this.init(locationType, protectObjects);
        try {
            isMatch = this.arrayFilterRules(protectObjects, context);
        }
        catch (LegoCheckedException e) {
            LOGGER.warn((Object)"Array replication filter failed!");
            throw e;
        }
        this.getLunTgtDevs().clear();
        this.getLunTgtdevSn().clear();
        if (!isMatch) {
            LOGGER.error((Object)"The template is not match.");
            throw new LegoCheckedException(1073948191L);
        }
        return true;
    }

    public boolean arrayFilterRules(List<ProtectObject> protectObjects, ExecutionContext context) {
        String devSn = (String)context.getAttribute("DEVICE_SN", String.class);
        Set resourceIdSet = null;
        if (context.getAttribute("RESOURCE_ID_SET") instanceof Set) {
            resourceIdSet = (Set)context.getAttribute("RESOURCE_ID_SET");
        }
        LOGGER.info((Object)"ResourceIdSet: %s", new Object[]{resourceIdSet.toString()});
        List<Lun> lunList = this.queryLuns(devSn, resourceIdSet);
        Lun[] lunArray = new Lun[lunList.size()];
        lunList.toArray(lunArray);
        List<ApplicationResource> appStandbyResource = this.getApplicationResources(protectObjects);
        HashMap<String, String> siteSns = new HashMap<String, String>();
        siteSns.put(SITE_A_SN, ((ProtectObjectStorageInfo)protectObjects.get(0).getUsedStorageResourceSet().iterator().next()).getResourceProviderSN());
        siteSns.put(SITE_B_SN, appStandbyResource.get(0).getDevSn());
        this.checkSites(siteSns);
        ArrayList dbNames = new ArrayList();
        ArrayList redoWWNs = new ArrayList();
        ArrayList redoBackUpLunIds = new ArrayList();
        ArrayList hostSnList = new ArrayList();
        dbNames.add(appStandbyResource.get(0).getExtendParams().get("STANDBY_DB_NAME"));
        Set appStorageInfos = appStandbyResource.get(0).getAppStorageInfos();
        appStorageInfos.forEach(appStorageInfo -> redoWWNs.add(appStorageInfo.getWwn()));
        List<ReplicationPair> pairList = this.getPairsByLun(lunArray);
        pairList.forEach(pair -> redoBackUpLunIds.add(pair.getTgtLunId()));
        appStandbyResource.forEach(applicationResource -> hostSnList.add(applicationResource.getHostSn()));
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put(STAND_BY_HOSTSNS, String.join((CharSequence)",", hostSnList));
        extendParams.put(DB_NAMES, String.join((CharSequence)",", dbNames));
        extendParams.put(REDO_LUN_WWN, String.join((CharSequence)",", redoWWNs));
        extendParams.put(REDO_BACK_UP_LUN_IDS, String.join((CharSequence)",", redoBackUpLunIds));
        this.filterPairsByTgtSN(pairList, (String)siteSns.get(SITE_B_SN));
        List<ReplicationPair> remotePairs = this.getpairsByApplicationResource(appStandbyResource);
        this.filterPairsByTgtSN(remotePairs, (String)siteSns.get(SITE_A_SN));
        if (this.checkPairEqualNum(pairList, remotePairs) && this.checkReplicationPairs(siteSns, pairList, remotePairs) && this.checkArchivePairs(remotePairs, appStandbyResource)) {
            this.fillContext(siteSns, extendParams, remotePairs);
            this.fillDeviceSnPairMap(pairList);
            return true;
        }
        return false;
    }

    private void checkSites(Map<String, String> siteSns) {
        String siteBsn;
        String devAsn = siteSns.get(SITE_A_SN);
        String devBsn = siteSns.get(SITE_B_SN);
        String siteAsn = this.checkSite(devAsn);
        if (Objects.equals(siteAsn, siteBsn = this.checkSite(devBsn))) {
            throw new LegoCheckedException(1073948210L);
        }
    }

    private boolean checkArchivePairs(List<ReplicationPair> remotePairs, List<ApplicationResource> appStandbyResource) {
        Set appStorageInfos = appStandbyResource.get(0).getAppStorageInfos();
        Set archiveSrcLunId = appStorageInfos.stream().filter(AppStorageInfo::isArchive).map(AppStorageInfo::getResourceId).collect(Collectors.toSet());
        long countArchiveLunWithPair = remotePairs.stream().filter(pair -> archiveSrcLunId.contains(pair.getSrcLunId())).count();
        return countArchiveLunWithPair == 0L || countArchiveLunWithPair == (long)archiveSrcLunId.size();
    }

    private List<ApplicationResource> getApplicationResources(List<ProtectObject> protectObjects) {
        IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(protectObjects.get(0).getPoType());
        applicationManager.checkEnvStatus(protectObjects.get(0));
        List appStandbyResource = applicationManager.getAppStandbyResource(protectObjects.get(0));
        if (VerifyUtil.isEmpty((Collection)appStandbyResource)) {
            LOGGER.error((Object)"%s has no data in siteB.", new Object[]{protectObjects.get(0).getName()});
            throw new LegoCheckedException(1073948191L);
        }
        return appStandbyResource;
    }

    private void filterPairsByTgtSN(List<ReplicationPair> pairList, String tgtSN) {
        pairList.removeIf(pair -> !tgtSN.equals(pair.getTgtDevSN()));
    }

    private void fillDeviceSnPairMap(List<ReplicationPair> pairList) {
        LOGGER.debug((Object)"Begin fill PairMap");
        Object policyTemplateContext = this.getFilterContext().get("temp_policy_template_context");
        if (policyTemplateContext != null && policyTemplateContext instanceof PolicyTemplateContext) {
            Map<String, List<ReplicationPair>> devicesnPairMap = this.classifyPair(pairList);
            ((PolicyTemplateContext)policyTemplateContext).addObject("DR_RING_SITE_A_SYNC_PAIR_MAP", devicesnPairMap);
        }
    }

    private void fillContext(Map<String, String> siteSns, Map<String, String> extendParams, List<ReplicationPair> remotePairs) {
        this.getFilterContext().put(SITE_A_SN, siteSns.get(SITE_A_SN));
        this.getFilterContext().put(SITE_B_SN, siteSns.get(SITE_B_SN));
        this.getFilterContext().put(OCACLE_SITE_A, this.getSiteByDeviceSN(siteSns.get(SITE_A_SN)).getSiteId());
        this.getFilterContext().put(OCACLE_SITE_B, this.getSiteByDeviceSN(siteSns.get(SITE_B_SN)).getSiteId());
        this.getFilterContext().put(STAND_BY_HOSTSNS, extendParams.get(STAND_BY_HOSTSNS));
        this.getFilterContext().put(REDO_LUN_WWN, extendParams.get(REDO_LUN_WWN));
        this.getFilterContext().put(DB_NAMES, extendParams.get(DB_NAMES));
        this.getFilterContext().put(REDO_BACK_UP_LUN_IDS, extendParams.get(REDO_BACK_UP_LUN_IDS));
        ArrayList srcLunIds = new ArrayList();
        ArrayList trgLunIds = new ArrayList();
        remotePairs.forEach(pair -> {
            srcLunIds.add(pair.getSrcLunId());
            trgLunIds.add(pair.getTgtLunId());
        });
        this.getFilterContext().put(REMOTE_PAIR_SRCLUNIDS, String.join((CharSequence)",", srcLunIds));
        this.getFilterContext().put(REMOTE_PAIR_TRGLUNIDS, String.join((CharSequence)",", trgLunIds));
    }

    private List<ReplicationPair> getpairsByApplicationResource(List<ApplicationResource> appStandbyResource) {
        if (VerifyUtil.isEmpty(appStandbyResource)) {
            LOGGER.warn((Object)"The parameter appStandbyResource is empty!");
            LOGGER.info((Object)"End %s", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            throw new LegoCheckedException(1073948191L);
        }
        String siteBSn = appStandbyResource.get(0).getDevSn();
        Set appLunInfos = appStandbyResource.get(0).getAppStorageInfos();
        List<String> lunIdList = appLunInfos.stream().map(AppStorageInfo::getResourceId).collect(Collectors.toList());
        Site site = this.getSiteByDeviceSN(siteBSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            LOGGER.warn((Object)"Can't get site by deviceSN: %s", new Object[]{siteBSn});
            throw new LegoCheckedException(1073948449L);
        }
        return this.getPairsByResourceIds(siteBSn, lunIdList, site, DrmEnumDefine.ResourceTypeE.LUN.getValue());
    }

    private boolean checkPairEqualNum(List<ReplicationPair> pairs, List<ReplicationPair> remotePairs) {
        return pairs.size() == remotePairs.size();
    }

    private boolean checkReplicationPairs(Map<String, String> siteSns, List<ReplicationPair> replicationPairs, List<ReplicationPair> remotePairs) {
        if (!siteSns.containsKey(SITE_A_SN) || !siteSns.containsKey(SITE_B_SN)) {
            return false;
        }
        LOGGER.debug((Object)"Begin Check Pairs");
        return this.checkSiteAPairs(siteSns, replicationPairs) && this.checkSiteBPairs(siteSns, remotePairs);
    }

    private boolean checkSiteA(Map<String, String> siteSns, ReplicationPair replicationPair) {
        boolean isMatch = false;
        String siteBSn = siteSns.get(SITE_B_SN);
        LOGGER.debug((Object)"Begin check siteA pairs");
        if (!siteBSn.equals(replicationPair.getTgtDevSN())) {
            return isMatch;
        }
        boolean isSync = replicationPair.getReplicationMode() == 1;
        boolean isPairNormalOrSynchorizing = String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(replicationPair.getRunningState()) || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue()).equals(replicationPair.getRunningState());
        LOGGER.info((Object)"IsSync: %s. IsPairNormalOrSynchorizing: %s.", new Object[]{String.valueOf(isSync), String.valueOf(isPairNormalOrSynchorizing)});
        return isSync && isPairNormalOrSynchorizing;
    }

    private boolean checkSiteAPairs(Map<String, String> siteSns, List<ReplicationPair> replicationPairs) {
        if (VerifyUtil.isEmpty(replicationPairs)) {
            LOGGER.error((Object)"There are no pairs");
            return false;
        }
        String siteASn = siteSns.get(SITE_A_SN);
        String siteBSn = siteSns.get(SITE_B_SN);
        LOGGER.debug((Object)"Begin check siteA pairs");
        boolean isConsistentGroup = !VerifyUtil.isEmpty((String)replicationPairs.get(0).getConsistentGroupId());
        boolean isSiteAAndSiteB = true;
        boolean isSync = true;
        boolean isPairNormalOrSynchorizing = true;
        for (ReplicationPair pair : replicationPairs) {
            if (VerifyUtil.isEmpty((String)pair.getConsistentGroupId()) == isConsistentGroup) {
                LOGGER.warn((Object)"IsConsistentGroup: %s", new Object[]{isConsistentGroup});
                return false;
            }
            isSiteAAndSiteB = siteASn.equals(pair.getSrcDevSN()) && siteBSn.equals(pair.getTgtDevSN());
            isSync = pair.getReplicationMode() == 1;
            boolean bl = isPairNormalOrSynchorizing = String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(pair.getRunningState()) || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue()).equals(pair.getRunningState());
            if (isSync && isPairNormalOrSynchorizing && isSiteAAndSiteB) continue;
            LOGGER.warn((Object)"IsSync: %s. IsPairNormalOrSynchorizing: %s.IsSiteAAndSiteB: %s.", new Object[]{isSync, isPairNormalOrSynchorizing, isSiteAAndSiteB});
            return false;
        }
        return true;
    }

    private boolean checkSiteB(Map<String, String> siteSns, ReplicationPair replicationPair) {
        boolean isMatch = false;
        String siteASn = siteSns.get(SITE_A_SN);
        LOGGER.debug((Object)"Begin check siteB pairs");
        if (!siteASn.equals(replicationPair.getTgtDevSN())) {
            return isMatch;
        }
        return replicationPair.getReplicationMode() == 1;
    }

    private boolean checkSiteBPairs(Map<String, String> siteSns, List<ReplicationPair> replicationPairs) {
        boolean isMatch = false;
        if (VerifyUtil.isEmpty(replicationPairs)) {
            return false;
        }
        String siteASn = siteSns.get(SITE_A_SN);
        String siteBSn = siteSns.get(SITE_B_SN);
        LOGGER.debug((Object)"Begin check siteA pairs");
        boolean isConsistentGroup = !VerifyUtil.isEmpty((String)replicationPairs.get(0).getConsistentGroupId());
        boolean isSiteAAndSiteB = true;
        boolean isSync = true;
        LOGGER.debug((Object)"Begin check siteB pairs");
        for (ReplicationPair pair : replicationPairs) {
            if (VerifyUtil.isEmpty((String)pair.getConsistentGroupId()) == isConsistentGroup) {
                return false;
            }
            isSiteAAndSiteB = siteBSn.equals(pair.getSrcDevSN()) && siteASn.equals(pair.getTgtDevSN());
            boolean bl = isSync = pair.getReplicationMode() == 1;
            if (isSync && isSiteAAndSiteB) continue;
            return false;
        }
        LOGGER.debug((Object)"IsSync: %s.IsSiteAAndSiteB: %s.IsConsistentGroup: %s", new Object[]{String.valueOf(isSync), String.valueOf(isSiteAAndSiteB), String.valueOf(isConsistentGroup)});
        return true;
    }

    @Override
    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        this.isMatch(protectObjects);
        String siteA = null;
        String siteB = null;
        if (this.getFilterContext().get(OCACLE_SITE_A) instanceof String) {
            siteA = (String)this.getFilterContext().get(OCACLE_SITE_A);
        }
        if (this.getFilterContext().get(OCACLE_SITE_B) instanceof String) {
            siteB = (String)this.getFilterContext().get(OCACLE_SITE_B);
        }
        ArrayList<ProtectLocationPath> path = new ArrayList<ProtectLocationPath>();
        path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.A_B.getValue(), siteA, siteB));
        return path;
    }
}

