/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;

public abstract class BaseRollbackProcessor
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(BaseRollbackProcessor.class);
    private static final long serialVersionUID = 4288965246836424512L;

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroupReplica replica = (ProtectGroupReplica)context.getAttribute("Recovery_PgReplica");
        if (VerifyUtil.isEmpty((Object)replica)) {
            logger.error((Object)"replica is null");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.handleSubProcessorByReplica(replica);
        if (this.getChildProc() == null || this.getChildProc().isEmpty()) {
            logger.error((Object)("not create sub processor,replica id:" + replica.getId()));
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(this.getChildProc()));
        recoveryTemplate.process(context);
        boolean result = this.calcProcessResultBySubProc();
        logger.debug((Object)("finished process, result:" + result));
        return result;
    }

    protected abstract void handleSubProcessorByReplica(ProtectGroupReplica var1);
}

