/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.operation.sdk.model.OperationResultBill;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.ForceSwapReplicationSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;

public abstract class BaseSwapReplicationSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -3637569113293563945L;
    private static final Log logger = LogFactory.getInstance(ForceSwapReplicationSubProcessor.class);
    private String replicationId;
    private String srcDeviceId;
    private String tgtDeviceId;
    private Integer relationType;
    private String replicationName;
    private boolean onlySplit = false;

    public String getReplicationName() {
        return this.replicationName;
    }

    public void setReplicationName(String replicationName) {
        this.replicationName = replicationName;
    }

    public String getReplicationId() {
        return this.replicationId;
    }

    public void setReplicationId(String replicationId) {
        this.replicationId = replicationId;
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public void setSrcDeviceId(String srcDeviceId) {
        this.srcDeviceId = srcDeviceId;
    }

    public String getTgtDeviceId() {
        return this.tgtDeviceId;
    }

    public void setTgtDeviceId(String tgtDeviceId) {
        this.tgtDeviceId = tgtDeviceId;
    }

    public Integer getRelationType() {
        return this.relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public boolean isOnlySplit() {
        return this.onlySplit;
    }

    public void setOnlySplit(boolean onlySplit) {
        this.onlySplit = onlySplit;
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getSwapProcessResultKey((String)this.replicationId, (String)this.srcDeviceId, (String)this.tgtDeviceId, (int)this.relationType);
    }

    public boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessNameParams(new String[]{this.replicationId});
            this.updateProcessDetail("ism.drm.recovery.replication.already.swapped", new String[]{this.replicationId});
            return true;
        }
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        boolean isVstoreReplicationPair = ReplicationConstantDefine.ReplicationDescription.isVsotrePair((int)this.relationType);
        ReplicationRelation replication = null;
        if (isVstoreReplicationPair) {
            VstoreReplicationPair vstoreReplicationPair = recoveryService.queryVstoreReplicationPair(this.srcDeviceId, this.tgtDeviceId, this.replicationId);
            if (null != vstoreReplicationPair) {
                replication = new ReplicationRelation();
                replication.setRelationType(this.relationType);
                replication.setReplicationName(vstoreReplicationPair.getName());
                replication.setReplicationId(vstoreReplicationPair.getVstorePairId());
                replication.setReplicationMode(Integer.valueOf(2));
            }
        } else {
            replication = recoveryService.queryReplication(this.srcDeviceId, this.tgtDeviceId, this.replicationId, ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)this.relationType));
        }
        if (null == replication) {
            logger.error((Object)("The replication does not exist. DevID:" + this.srcDeviceId + ",RepID:" + this.replicationId), 90160758784000L);
            this.updateProcessNameParams(new String[]{this.replicationId});
            this.updateProcessDetail("lego.err.1073948677", new String[]{this.replicationId});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.updateProcessNameParams(new String[]{replication.getReplicationId()});
        this.setReplicationName(replication.getReplicationName());
        long startTime = System.currentTimeMillis();
        OperationResultBill bill = this.swapReplication(isVstoreReplicationPair);
        logger.debug((Object)("swapReplication cost time:" + (System.currentTimeMillis() - startTime)));
        if (bill.isHasFailRecord() && !VerifyUtil.isEmpty((Collection)bill.getOperationResults())) {
            OperationResult operationResult = (OperationResult)bill.getOperationResults().get(0);
            this.updateProcessDetail("lego.err." + operationResult.getErrorCode(), operationResult.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    abstract boolean isNeedForceSwap();

    private OperationResultBill swapReplication(boolean isVstorePair) {
        IRecoveryProcessHandler recoveryProcessHandler = (IRecoveryProcessHandler)RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        if (isVstorePair) {
            return recoveryProcessHandler.setVstoreSecondaryPairProtection(this.srcDeviceId, this.tgtDeviceId, this.replicationId, this.isNeedForceSwap());
        }
        if (this.isNeedForceSwap()) {
            return recoveryProcessHandler.forceSwap(this.replicationId, this.srcDeviceId, this.tgtDeviceId, ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)this.relationType), this.isOnlySplit());
        }
        return recoveryProcessHandler.swap(this.replicationId, this.srcDeviceId, this.tgtDeviceId, ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)this.relationType), this.isOnlySplit());
    }
}

