/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateNativeLunSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteNativeLunSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class DeleteNativeLunProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 4105771873623308463L;
    private static final Log logger = LogFactory.getInstance(DeleteNativeLunProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"execute delete native lun processor");
        if (VerifyUtil.isEmpty((Object)context)) {
            logger.error((Object)"DeleteNativeLunProcessor: context is null.", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE lastRunType = DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA;
        try {
            List createLunProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), lastRunType, CreateNativeLunSubProcessor.class);
            if (!this.generateSubProcessor(context, createLunProcessors)) {
                logger.error((Object)"generate delete native lun failed", 90160758784001L);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"generate sub processor failed", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (this.getChildProc().size() == 0) {
            logger.info((Object)"have not create lun processor, exec succ.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        return this.executeSubProcessor(context);
    }

    private boolean generateSubProcessor(RecoveryProcessorContext context, List<RecoveryProcessor> createLunProcessors) {
        HashSet<DeleteNativeLunSubProcessor> delLunProcessors = new HashSet<DeleteNativeLunSubProcessor>();
        for (RecoveryProcessor tmpProcessor : createLunProcessors) {
            if (!(tmpProcessor instanceof CreateNativeLunSubProcessor)) continue;
            CreateNativeLunSubProcessor createProcessor = (CreateNativeLunSubProcessor)tmpProcessor;
            DeleteNativeLunSubProcessor subProcessor = new DeleteNativeLunSubProcessor();
            subProcessor.setProcName(subProcessor.getName());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setProcType(this.getProcType());
            subProcessor.setDeviceId(createProcessor.getDeviceId());
            subProcessor.setLunId(createProcessor.getDstLunId());
            subProcessor.setLunName(createProcessor.getDstLunName());
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            delLunProcessors.add(subProcessor);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(delLunProcessors);
        } else {
            this.setChildProc(delLunProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

