/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class DeleteNativeLunSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -3620569753100196115L;
    private static final long LUN_NOT_EXISTS = 1077936859L;
    private static final Log logger = LogFactory.getInstance(DeleteNativeLunSubProcessor.class);
    private String deviceId;
    private String lunId;
    private String lunName;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        logger.debug((Object)"Execute DeleteNativeLunSubProcessor, lun id: %s, device id: %s", new Object[]{this.lunId, this.deviceId});
        this.updateProcessNameParams(new String[]{this.lunName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (VerifyUtil.isEmpty((Object)context)) {
            logger.error((Object)"CreateNativeLunSubProcessor: context is null.", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return this.deleteNativeLun();
    }

    private boolean deleteNativeLun() {
        logger.info((Object)("Begin to delete native lun " + this.lunId + " from " + this.deviceId + "."));
        try {
            Lun lun = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(this.deviceId).getLunById(this.deviceId, this.lunId);
            if (null == lun) {
                logger.info((Object)("lun " + this.lunId + " from " + this.deviceId + " is not exists"));
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(this.deviceId).deleteLun(this.deviceId, new String[]{this.lunId});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            logger.info((Object)("delete lun id " + this.lunId + ", device id" + this.deviceId + " succ."));
            return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1077936859L) {
                logger.info((Object)("lun " + this.lunId + " from " + this.deviceId + " is not exists"));
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            logger.error((Object)("deleteNativeLun error: Id=" + this.lunId + " from device=" + this.deviceId + "," + ExceptionUtil.getErrorMessage((Throwable)e) + ",errorcode=" + e.getErrorCode()));
            this.updateProcessDetail(e.getErrorMessageKey(), null);
        }
        catch (Exception e) {
            logger.error((Object)("deleteNativeLun error: Id=" + this.lunId + " from device=" + this.deviceId + "," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return false;
    }
}

