/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroBaseManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class DisableHyperMetroSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 8224410639855787346L;
    private static final Log logger = LogFactory.getInstance(DisableHyperMetroSubProcessor.class);
    private String deviceId;
    private String pairId;
    private Boolean isConsistentGroup;
    private Integer runningState;
    private Boolean isPrimary;
    private int roleType;
    private String vstoreId;

    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public void setIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public int getRoleType() {
        return this.roleType;
    }

    public void setRoleType(int roleType) {
        this.roleType = roleType;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getPairId() {
        return this.pairId;
    }

    public void setPairId(String pairId) {
        this.pairId = pairId;
    }

    public Boolean getIsConsistentGroup() {
        return this.isConsistentGroup;
    }

    public void setIsConsistentGroup(Boolean isConsistentGroup) {
        this.isConsistentGroup = isConsistentGroup;
    }

    public Integer getRunningState() {
        return this.runningState;
    }

    public void setRunningState(Integer runningState) {
        this.runningState = runningState;
    }

    public String getVstoreId() {
        return this.vstoreId;
    }

    public void setVstoreId(String vstoreId) {
        this.vstoreId = vstoreId;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getPairId()});
        return this.disableHyperMetroPair();
    }

    protected String generateResultKey() {
        return this.getDisableHyperMetroPairResultKey();
    }

    private boolean disableHyperMetroPair() {
        try {
            if (this.isSuccessStatus()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            if (this.isNormalStatus()) {
                this.setRoleType(this.getIsPrimary() != false ? DrmEnumDefine.RoleType.NONE_PRIORITY.getValue() : DrmEnumDefine.RoleType.PRIORITY.getValue());
                DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.getDeviceId());
                if (null == drResource) {
                    logger.error((Object)("DrResource is null, sn=" + this.getDeviceId()));
                    return false;
                }
                IStorageHyperMetroBaseManager manager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(this.getDeviceId());
                manager.disable(this.getDeviceId(), this.getPairId(), DrmEnumDefine.RoleType.getType((int)this.roleType), this.getIsConsistentGroup().booleanValue(), this.vstoreId);
                logger.info((Object)"Local: Success!");
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            this.updateProcessDetail("lego.err.1073948754", new String[]{this.getPairId()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Disable HyperMetro pair failed. PairId:" + this.getPairId() + " ,DevSN:" + this.getDeviceId()), (Throwable)e, 90160758784001L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Disable HyperMetro pair failed. PairId:" + this.getPairId() + " ,DevSN:" + this.getDeviceId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.updateProcessDetail("lego.err.1073948755", new String[]{this.getPairId()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
    }

    private boolean isNormalStatus() {
        return XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() == this.getRunningState().intValue();
    }

    private boolean isSuccessStatus() {
        return XveEuumDefineParent.RUNNING_STATUS_E.PAUSE.getValue() == this.getRunningState().intValue();
    }

    private String getDisableHyperMetroPairResultKey() {
        StringBuilder builder = new StringBuilder();
        builder.append("DisableHyperMetroPair:");
        builder.append("DeviceId=");
        builder.append(this.getDeviceId());
        builder.append(";");
        builder.append("PairId=");
        builder.append(this.getPairId());
        builder.append("IsConsistentGroup=");
        builder.append(this.getIsConsistentGroup());
        return builder.toString();
    }
}

