/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageVstoreReplicationPairManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class DisableTargetResourceSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -3637569113293563945L;
    private static final Log logger = LogFactory.getInstance(DisableTargetResourceSubProcessor.class);
    private String replicationId;
    private String srcDeviceId;
    private String tgtDeviceId;
    private Integer relationType;
    private String replicationName;

    public String getReplicationName() {
        return this.replicationName;
    }

    public void setReplicationName(String replicationName) {
        this.replicationName = replicationName;
    }

    public String getReplicationId() {
        return this.replicationId;
    }

    public void setReplicationId(String replicationId) {
        this.replicationId = replicationId;
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public void setSrcDeviceId(String srcDeviceId) {
        this.srcDeviceId = srcDeviceId;
    }

    public String getTgtDeviceId() {
        return this.tgtDeviceId;
    }

    public void setTgtDeviceId(String tgtDeviceId) {
        this.tgtDeviceId = tgtDeviceId;
    }

    public Integer getRelationType() {
        return this.relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getDisableTargetResourceProcResultKey((String)this.replicationId, (String)this.srcDeviceId, (String)this.tgtDeviceId, (int)this.relationType);
    }

    public boolean execute(RecoveryProcessorContext context) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        boolean isVstoreReplicationPair = ReplicationConstantDefine.ReplicationDescription.isVsotrePair((int)this.relationType);
        ReplicationRelation replication = null;
        if (isVstoreReplicationPair) {
            VstoreReplicationPair vstoreReplicationPair = recoveryService.queryVstoreReplicationPair(this.srcDeviceId, this.tgtDeviceId, this.replicationId);
            if (null != vstoreReplicationPair) {
                replication = new ReplicationRelation();
                replication.setRelationType(this.relationType);
                replication.setReplicationName(vstoreReplicationPair.getName());
                replication.setReplicationId(vstoreReplicationPair.getVstorePairId());
                replication.setReplicationMode(Integer.valueOf(2));
            }
        } else {
            replication = recoveryService.queryReplication(this.srcDeviceId, this.tgtDeviceId, this.replicationId, ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)this.relationType));
        }
        if (null == replication) {
            logger.error((Object)("The replication does not exist. DevID:" + this.srcDeviceId + ",RepID:" + this.replicationId), 90160758784000L);
            this.updateProcessNameParams(new String[]{this.replicationId});
            this.updateProcessDetail("lego.err.1073948677", new String[]{this.replicationId});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.updateProcessNameParams(new String[]{replication.getReplicationId()});
        this.setReplicationName(replication.getReplicationName());
        OperationResult operationResult = this.disableTargetResource(isVstoreReplicationPair);
        if (!operationResult.isSuccess()) {
            this.updateProcessDetail("lego.err." + operationResult.getErrorCode(), operationResult.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    private OperationResult disableTargetResource(boolean isVstoreReplicationPair) {
        OperationResult result;
        if (isVstoreReplicationPair) {
            StorageVstoreReplicationPairManagerProxy proxy = StorageVstoreReplicationPairManagerProxy.getInstance();
            result = proxy.getMgrByDevId(this.tgtDeviceId).setSecondaryPairReadWrite(this.tgtDeviceId, this.replicationId, String.valueOf(2));
        } else {
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            result = proxy.setLunWriteProtection(this.tgtDeviceId, this.replicationId, ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)this.relationType), 2);
        }
        if (null == result) {
            result = new OperationResult("ism.drm.set.targetresource.readonly.operation", true, false, new String[]{this.replicationId});
        }
        return result;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

