/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.backup.BackupManagerProxy;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateNativeLunSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RestoreNativeReplicaSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -4639225666622509624L;
    private static final Log logger = LogFactory.getInstance(RestoreNativeReplicaSubProcessor.class);
    private String imageId;
    private ProtectGroupReplica pgReplica;
    private String imagePath;
    private transient NativeLunInfo nativeLunInfo;
    private List<RecoveryProcessor> recoveryProcesses;
    private String requestId;

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"execute RestoreNativeReplicaSubProcessor");
        this.setContextRef(context);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            logger.error((Object)"RestoreNativeReplicaSubProcessor: recoveryplan is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.updateProcessNameParams(new String[]{this.imagePath});
        this.pgReplica = context.getProtectGroupReplica();
        this.recoveryProcesses = this.getRecoveryProcessors(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), CreateNativeLunSubProcessor.class);
        if (!this.replaceReplicaInfo(context, this.recoveryProcesses)) {
            logger.error((Object)"RestoreNativeReplicaSubProcessor: replace storage info failed.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            context.setAttribute("context_restore_request_id", (Object)this.requestId);
            context.setAttribute("Recovery_PgReplica", (Object)this.pgReplica);
            return true;
        }
        if (VerifyUtil.isEmpty((Object)context)) {
            logger.error((Object)"CreateNativeLunSubProcessor: context is null.", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return this.restoreNativeLun(context);
    }

    private boolean restoreNativeLun(RecoveryProcessorContext context) {
        HashMap<String, String> restoreParams = new HashMap<String, String>();
        this.buildRestoreParam(restoreParams);
        IBackupManager manager = BackupManagerProxy.getInstance().getBackupService("NativeBackupEngine");
        this.requestId = manager.restore(this.pgReplica.getStorageDeviceId(), this.imageId, restoreParams);
        context.setAttribute("context_restore_request_id", (Object)this.requestId);
        context.setAttribute("Recovery_PgReplica", (Object)this.pgReplica);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private boolean replaceReplicaInfo(RecoveryProcessorContext context, List<RecoveryProcessor> createProcessors) {
        this.nativeLunInfo = new NativeLunInfo();
        String mapDeviceSn = this.buildSrcLunAndLun(createProcessors);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Set pgs = recoveryPlan.getProtectGroups();
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (VerifyUtil.isEmpty((Collection)pgs)) {
            logger.error((Object)("RestoreNativeReplicaSubProcessor: recoveryplan " + recoveryPlan.getName() + " have no protectgroup."));
            return false;
        }
        ProtectGroup fstPg = (ProtectGroup)CommonUtil.getFirstElement((Collection)pgs);
        this.configCommonData(context, mapDeviceSn);
        if (fstPg.getPoType() != 10) {
            this.configAppData(fstPg, replica);
        } else if (fstPg.getPoType() == 10) {
            for (ProtectGroupReplica pgr : fstPg.getReplicaList()) {
                if (!pgr.getId().equals(replica.getId())) continue;
                for (ProtectObjectReplica por : pgr.getReplicas()) {
                    this.setReplicaStorage(por);
                }
                for (ProtectObjectReplica por : replica.getReplicas()) {
                    this.setReplicaStorage(por);
                }
            }
            this.setContextRef(context);
        }
        return true;
    }

    private void setReplicaStorage(ProtectObjectReplica por) {
        for (RelicaStorageInfo replicaStorage : por.getStorageInfos()) {
            Lun lun = this.nativeLunInfo.getLunByLunWwn(replicaStorage.getProtectObjectStorageWwn());
            if (!VerifyUtil.isEmpty((Object)lun)) {
                this.configPORLunInfoVM(replicaStorage, lun);
                continue;
            }
            this.replaceReplicaPairInfoVM(replicaStorage.getProtectObjectStorageWwn(), replicaStorage, replicaStorage.getSrcStorageId());
        }
    }

    private void configPORLunInfo(RelicaStorageInfo replicaStorage, Lun nativeLun) {
        logger.debug((Object)"replace config, lunId:%s=>%s, lunWwn:%s=>%s, deviceSn:%s.", new Object[]{replicaStorage.getSrcStorageId(), nativeLun.getLunId(), replicaStorage.getProtectObjectStorageWwn(), nativeLun.getWwn(), replicaStorage.getSrcStorageProviderSN()});
        replicaStorage.setSrcStorageId(nativeLun.getLunId());
        replicaStorage.setProtectObjectStorageWwn(nativeLun.getWwn());
    }

    private void configPORLunInfoVM(RelicaStorageInfo replicaStorage, Lun nativeLun) {
        logger.debug((Object)"replace config, lunId:%s=>%s, lunWwn:%s, deviceSn:%s=>%s.", new Object[]{replicaStorage.getSrcStorageId(), nativeLun.getLunId(), replicaStorage.getProtectObjectStorageWwn(), nativeLun.getWwn(), replicaStorage.getSrcStorageProviderSN(), nativeLun.getDevSn()});
        replicaStorage.setStorageId(nativeLun.getLunId());
        replicaStorage.setStorageProviderSN(nativeLun.getDevSn());
    }

    private void configPOSLunInfo(ProtectObjectStorageInfo hostStorage, Lun nativeLun) {
        logger.debug((Object)"replace config, lunId:%s=>%s, lunWwn:%s=>%s.", new Object[]{hostStorage.getResourceId(), nativeLun.getLunId(), hostStorage.getLunWWN(), nativeLun.getWwn()});
        ProtectGroup fstPg = this.getContextRef().getProtectGroup();
        if (null != fstPg && fstPg.getPoType() != 10) {
            logger.info((Object)"Config protect object lun info in type: %s", (long)fstPg.getPoType());
            hostStorage.setLunWWN(nativeLun.getWwn());
            hostStorage.setResourceId(nativeLun.getLunId());
        }
    }

    private void replaceReplicaPairInfo(String lunWwn, Object storageInfo, String srcLunId) {
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List pairList = storageService.queryReplicationPairsByMasterLunWWN(Stream.of(lunWwn).collect(Collectors.toList()), true);
        if (pairList.isEmpty()) {
            logger.error((Object)"can not get wwn %s pairs, srclunId %s.", new Object[]{srcLunId, lunWwn});
            return;
        }
        for (ReplicationPair pair : pairList) {
            Lun lun;
            Lun tgtLun = storageService.getLunBySnAndLunId(pair.getTgtDevSN(), pair.getTgtLunId());
            if (VerifyUtil.isEmpty((Object)tgtLun)) {
                logger.error((Object)"can not get tgt lun. tgtLunId: %s.", new Object[]{pair.getTgtLunId()});
            }
            if (!VerifyUtil.isEmpty((Object)(lun = this.nativeLunInfo.getLunByLunWwn(tgtLun.getWwn())))) {
                if (storageInfo instanceof ProtectObjectStorageInfo) {
                    this.configPOSLunInfo((ProtectObjectStorageInfo)storageInfo, lun);
                    continue;
                }
                if (storageInfo instanceof RelicaStorageInfo) {
                    this.configPORLunInfo((RelicaStorageInfo)storageInfo, lun);
                    continue;
                }
                logger.error((Object)"replace lunid %s failed, storage info is %s, wwn is %s.", new Object[]{srcLunId, storageInfo.getClass().getName(), lunWwn});
                continue;
            }
            logger.error((Object)"can not replace config, srclunId %s, get www %s pairs.", new Object[]{srcLunId, lunWwn});
        }
    }

    private void replaceReplicaPairInfoVM(String lunWwn, Object storageInfo, String srcLunId) {
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List pairList = storageService.queryReplicationPairsByMasterLunWWN(Stream.of(lunWwn).collect(Collectors.toList()), true);
        if (pairList.isEmpty()) {
            logger.error((Object)"can not get wwn %s pairs, srclunId %s.", new Object[]{srcLunId, lunWwn});
            return;
        }
        for (ReplicationPair pair : pairList) {
            Lun lun;
            Lun tgtLun = storageService.getLunBySnAndLunId(pair.getTgtDevSN(), pair.getTgtLunId());
            if (VerifyUtil.isEmpty((Object)tgtLun)) {
                logger.error((Object)"can not get tgt lun. tgtLunId: %s.", new Object[]{pair.getTgtLunId()});
            }
            if (!VerifyUtil.isEmpty((Object)(lun = this.nativeLunInfo.getLunByLunWwn(tgtLun.getWwn())))) {
                if (storageInfo instanceof RelicaStorageInfo) {
                    this.configPORLunInfoVM((RelicaStorageInfo)storageInfo, lun);
                    continue;
                }
                logger.error((Object)"replace lunid %s failed, storage info is %s, wwn is %s.", new Object[]{srcLunId, storageInfo.getClass().getName(), lunWwn});
                continue;
            }
            logger.error((Object)"can not replace config, srclunId %s, get www %s pairs.", new Object[]{srcLunId, lunWwn});
        }
    }

    private void configCommonData(RecoveryProcessorContext context, String mapDeviceSn) {
        logger.info((Object)("mapDeviceSn:" + mapDeviceSn));
        Set pos = context.getRecoveryProtectObjects();
        for (ProtectObject po : pos) {
            for (ProtectObjectStorageInfo hostStorage : po.getUsedStorageResourceSet()) {
                Lun lun = this.nativeLunInfo.getLunByLunWwn(hostStorage.getLunWWN());
                if (!VerifyUtil.isEmpty((Object)lun)) {
                    this.configPOSLunInfo(hostStorage, lun);
                    continue;
                }
                this.replaceReplicaPairInfo(hostStorage.getLunWWN(), hostStorage, hostStorage.getResourceId());
            }
        }
    }

    private void configAppData(ProtectGroup pg, ProtectGroupReplica replica) {
        for (ProtectGroupReplica pgr : pg.getReplicaList()) {
            if (!pgr.getId().equals(replica.getId())) continue;
            for (ProtectObjectReplica por : pgr.getReplicas()) {
                for (RelicaStorageInfo replicaStorage : por.getStorageInfos()) {
                    Lun lun = this.nativeLunInfo.getLunByLunWwn(replicaStorage.getProtectObjectStorageWwn());
                    if (!VerifyUtil.isEmpty((Object)lun)) {
                        this.configPORLunInfo(replicaStorage, lun);
                        continue;
                    }
                    this.replaceReplicaPairInfo(replicaStorage.getProtectObjectStorageWwn(), replicaStorage, replicaStorage.getSrcStorageId());
                }
            }
        }
        for (ProtectObjectReplica po : this.pgReplica.getReplicas()) {
            for (RelicaStorageInfo info : po.getStorageInfos()) {
                Lun lun = this.nativeLunInfo.getLunByLunWwn(info.getProtectObjectStorageWwn());
                if (!VerifyUtil.isEmpty((Object)lun)) {
                    this.configPORLunInfo(info, lun);
                    continue;
                }
                this.replaceReplicaPairInfo(info.getProtectObjectStorageWwn(), info, info.getSrcStorageId());
            }
        }
    }

    private String buildSrcLunAndLun(List<RecoveryProcessor> createProcessors) {
        String mapDeviceSn = "";
        for (RecoveryProcessor subProcessor : createProcessors) {
            CreateNativeLunSubProcessor createLunProcessor = (CreateNativeLunSubProcessor)subProcessor;
            Lun lun = new Lun();
            lun.setLunId(createLunProcessor.getDstLunId());
            lun.setWwn(createLunProcessor.getDstLunWwn());
            lun.setName(createLunProcessor.getDstLunName());
            lun.setDevSn(createLunProcessor.getDeviceId());
            this.nativeLunInfo.addLunInfo(createLunProcessor.getLunId(), createLunProcessor.getLunWwn(), lun);
            mapDeviceSn = createLunProcessor.getDeviceId();
        }
        return mapDeviceSn;
    }

    private void buildRestoreParam(Map<String, String> restoreParams) {
        for (RecoveryProcessor processor : this.recoveryProcesses) {
            CreateNativeLunSubProcessor createProcessor = (CreateNativeLunSubProcessor)processor;
            String srcLun = createProcessor.getLunId() + ":" + createProcessor.getLunWwn();
            String dstLun = createProcessor.getDstLunId() + ":" + createProcessor.getDstLunWwn();
            restoreParams.put(srcLun, dstLun);
        }
    }

    static class NativeLunInfo {
        private Map<String, Lun> lunIdAndLuns;
        private Map<String, Lun> lunWwnAndLuns;

        NativeLunInfo() {
        }

        public void addLunInfo(String lunId, String lunWwn, Lun lun) {
            if (VerifyUtil.isEmpty(this.lunIdAndLuns)) {
                this.lunIdAndLuns = new HashMap<String, Lun>();
                this.lunWwnAndLuns = new HashMap<String, Lun>();
            }
            this.lunIdAndLuns.put(lunId, lun);
            this.lunWwnAndLuns.put(lunWwn, lun);
        }

        public Lun getLunByLunId(String lunId) {
            if (!this.lunIdAndLuns.containsKey(lunId)) {
                return null;
            }
            return this.lunIdAndLuns.get(lunId);
        }

        public Lun getLunByLunWwn(String lunWwn) {
            if (!this.lunWwnAndLuns.containsKey(lunWwn)) {
                return null;
            }
            return this.lunWwnAndLuns.get(lunWwn);
        }
    }
}

