/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.recovery.process.RollbackBackupSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RollbackBackupProcessor
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(RollbackBackupProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        this.updateSubProcessors(recoveryTasks, context);
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.updateProcessDetail("ism.drm.recovery.no.rollback.backup", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(this.getChildProc()));
        recoveryTemplate.process(context);
        boolean result = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            result = false;
            RecoveryServiceUtil.setProtectGroupsInvalidByPlan((RecoveryPlan)context.getRecoveryPlan(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        }
        return result;
    }

    private boolean updateSubProcessors(Collection<RecoveryTask> recoveryTasks, RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty(recoveryTasks)) {
            return true;
        }
        if (null != this.getChildProc()) {
            this.getChildProc().clear();
        }
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        HashSet<RollbackBackupSubProcessor> subProcessors = new HashSet<RollbackBackupSubProcessor>();
        RollbackBackupSubProcessor processor = new RollbackBackupSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        RecoveryTask task = (RecoveryTask)CommonUtil.getFirstElement(recoveryTasks);
        String devSn = task.getSrcDeviceId();
        processor.setDeviceId(devSn);
        String imageId = (String)replica.getProps().get("IMAGE_ID");
        processor.setImageId(imageId);
        processor.setLunRelationships(this.createLunRelationShips(devSn, recoveryTasks));
        subProcessors.add(processor);
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private Map<String, String> createLunRelationShips(String devSn, Collection<RecoveryTask> recoveryTasks) {
        HashMap<String, String> lunRelationships = new HashMap<String, String>();
        StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
        IStorageLunBaseManager lunManager = proxy.getStorageLunMgrByDevId(devSn);
        for (RecoveryTask recoveryTask : recoveryTasks) {
            String srcLunId = (String)CommonUtil.getFirstElement((Collection)recoveryTask.getSrcStorageIds());
            Lun lun = lunManager.getLunById(devSn, srcLunId);
            String srcWwn = lun.getWwn();
            if (VerifyUtil.isEmpty((String)srcLunId) || VerifyUtil.isEmpty((String)srcWwn)) {
                logger.error((Object)("lun ids or lun wwns is null. lunIds:" + srcLunId));
                throw new LegoCheckedException(1073947393L);
            }
            lunRelationships.put(srcLunId + ":" + srcWwn, srcLunId + ":" + srcWwn);
        }
        return lunRelationships;
    }
}

