/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;

public class RollbackNasSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7761963017234340294L;
    private String deviceId;
    private String srcDeviceId;
    private String resourceId;
    private String resourceName;
    private String snapshotId;
    private String snapshotName;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public void setSrcDeviceId(String srcDeviceId) {
        this.srcDeviceId = srcDeviceId;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        OperationResult result = this.rollbackNasSnapshot(context);
        if (!result.isSuccess()) {
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    protected String generateResultKey() {
        return RecoveryProcessResult.getRollbackSnapshotResultKey((String)this.getDeviceId(), (String)this.getResourceId(), (String)this.getSnapshotId());
    }

    protected OperationResult rollbackNasSnapshot(RecoveryProcessorContext context) {
        NasFileSystem fileSystem = (NasFileSystem)((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getStorageResource(this.getDeviceId(), this.getResourceId(), NasFileSystem.class);
        String nfsName = VerifyUtil.isEmpty((Object)fileSystem) ? "" : fileSystem.getName();
        this.updateProcessNameParams(new String[]{nfsName, this.getSnapshotName()});
        IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance().getStorageFileSystemSnapshotManager(this.getDeviceId());
        String rollbackSpeed = (String)context.getRecoveryPlan().getGlobalSettings().get("ROLLBACK_RATE");
        return fileSystemSnapshotManagerProxy.rollBackSnapshot(this.getDeviceId(), this.getSnapshotId(), rollbackSpeed);
    }
}

